-- --------------------------------------------------------

--
-- Structure for view `rynk_cards_view`
--
DROP VIEW IF EXISTS `rynk_cards_view`;

CREATE VIEW `rynk_cards_view`  AS  select `rynk_cards`.`id` AS `id`,`rynk_cards`.`order_id` AS `order_id`,`rynk_cards`.`code` AS `code`,`rynk_cards`.`sold` AS `sold`,`rynk_cards`.`deactive_date` AS `deactive_status`,`rynk_cards`.`publish` AS `publish`,`rynk_products`.`title` AS `product_title`,`rynk_categories`.`title_fa` AS `category_title` from ((`rynk_cards` join `rynk_products` on((`rynk_cards`.`product_id` = `rynk_products`.`id`))) join `rynk_categories` on((`rynk_products`.`category_id` = `rynk_categories`.`id`))) ;

-- --------------------------------------------------------

--
-- Structure for view `rynk_coupons_view`
--
DROP VIEW IF EXISTS `rynk_coupons_view`;

CREATE VIEW `rynk_coupons_view`  AS  select `rynk_coupons`.`id` AS `id`,`rynk_coupons`.`title` AS `title`,`rynk_coupons`.`code` AS `code`,`rynk_coupons`.`count` AS `count`,`rynk_coupons`.`start_date` AS `start_date`,`rynk_coupons`.`end_date` AS `end_date`,`rynk_coupons`.`discount_type` AS `discount_type`,`rynk_coupons`.`amount` AS `amount`,`rynk_coupons`.`publish` AS `publish`,count(`rynk_orders`.`id`) AS `number_used` from (`rynk_coupons` left join `rynk_orders` on(((`rynk_coupons`.`id` = `rynk_orders`.`coupon_id`) and (`rynk_orders`.`paid` = 1)))) where (`rynk_coupons`.`deleted` = 0) group by `rynk_coupons`.`id` ;

-- --------------------------------------------------------

--
-- Structure for view `rynk_orders_view`
--
DROP VIEW IF EXISTS `rynk_orders_view`;

CREATE VIEW `rynk_orders_view` AS select `rynk_orders`.`id` AS `id`,`rynk_orders`.`user_id` AS `user_id`,`rynk_orders`.`tracking_code` AS `tracking_code`,`rynk_orders`.`paid` AS `paid`,`rynk_orders`.`price` AS `price`,`rynk_orders`.`reading` AS `reading`,`rynk_orders`.`pending` AS `pending`,`rynk_orders`.`card2card` AS `card2card`,`rynk_orders`.`email` AS `email`,`rynk_orders`.`cell_phone` AS `cell_phone`,`rynk_orders`.`created` AS `created`,`rynk_orders`.`jalali_created` AS `jalali_created`,`rynk_coupons`.`code` AS `coupon_code` from (`rynk_orders` left join `rynk_coupons` on((`rynk_orders`.`coupon_id` = `rynk_coupons`.`id`)));

-- --------------------------------------------------------

--
-- Structure for view `rynk_transactions_view`
--
DROP VIEW IF EXISTS `rynk_transactions_view`;

CREATE VIEW `rynk_transactions_view`  AS  select `rynk_transactions`.`id` AS `id`,`rynk_transactions`.`order_id` AS `order_id`,`rynk_transactions`.`gateway` AS `gateway`,`rynk_transactions`.`type` AS `type`,`rynk_transactions`.`amount` AS `amount`,`rynk_transactions`.`reference` AS `reference`,`rynk_transactions`.`created` AS `created`,`rynk_transactions`.`completed` AS `completed`,`rynk_transactions`.`reject` AS `reject`,`rynk_users`.`cell_phone` AS `cell_phone`,`rynk_orders`.`tracking_code` AS `tracking_code` from ((`rynk_transactions` join `rynk_users` on(((`rynk_transactions`.`user_id` = `rynk_users`.`id`) and ((`rynk_transactions`.`completed` = 1) or (`rynk_transactions`.`gateway` = 'card2card'))))) left join `rynk_orders` on((`rynk_transactions`.`order_id` = `rynk_orders`.`id`)));

-- --------------------------------------------------------

--
-- Structure for view `rynk_tickets_view`
--
DROP TABLE IF EXISTS `rynk_tickets_view`;

CREATE VIEW `rynk_tickets_view` AS select `rynk_tickets`.`id` AS `id`,`rynk_tickets`.`user_id` AS `user_id`,`rynk_tickets`.`title` AS `title`,`rynk_tickets`.`priority` AS `priority`,`rynk_tickets`.`unread_admin` AS `unread_admin`,`rynk_tickets`.`unread_user` AS `unread_user`,`rynk_tickets`.`updated` AS `updated`,`rynk_tickets`.`created` AS `created`,`rynk_tickets`.`category_id` AS `category_id`,`rynk_categories`.`title_fa` AS `category_title`,concat(`rynk_users`.`first_name`,' ',`rynk_users`.`last_name`) AS `full_name`,`rynk_users`.`username` AS `username`,if((`rynk_tickets`.`status` = 'close'),'close',if((`last_messages`.`user_id` = `rynk_tickets`.`user_id`),'pending','done')) AS `status` from (((`rynk_tickets` join `rynk_users` on(((`rynk_tickets`.`user_id` = `rynk_users`.`id`) and (`rynk_users`.`deleted` = 0)))) join `rynk_categories` on((`rynk_tickets`.`category_id` = `rynk_categories`.`id`))) join `rynk_messages` `last_messages` on((`rynk_tickets`.`last_message_id` = `last_messages`.`id`)));

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;