<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<section class="py-lg-3 py-4">
    <div class="container">
        <div class="row">
            <div class="col-md-8 m-auto">
                <div class="card box-shadow-xl overflow-hidden mb-4">
                    <div class="row">
                        <div class="col-lg-5 position-relative bg-cover" style="background-image: url(<?= base_url($bg_image_side) ?>);" loading="lazy">
                            <div class="w-100 h-100 z-index-2 d-flex m-auto justify-content-center">
                                <div class="mask bg-gradient-dark"></div>
                                <div class="side-texts position-relative my-auto z-index-2">
                                    <h2 class="text-center mb-3 bold mt-5"><?= $settings->site_name ?></h2>
                                    <div class="d-flex p-2 text-white my-3">
                                        <div>
                                            <i class="fa fa-check ms-2"></i>
                                        </div>
                                        <div class="ps-3">
                                            <span>با ورود و یا ثبت نام در</span>
                                            <span>شما</span>
                                            <?php if ($rules_page) : ?>
                                                <a href="#" data-bs-toggle="modal" data-bs-target="#modal-rules" class="coditions-link">شرایط و قوانین</a>
                                            <?php else : ?>
                                                </span>شرایط و قوانین</span>
                                            <?php endif; ?>
                                            <span>استفاده از سرویس های سایت را می‌پذیرید.</span>
                                        </div>
                                    </div><!-- /.d-flex -->
                                </div><!-- /.side-texts -->
                            </div><!-- /.w-100 -->
                        </div><!-- /.col -->

                        <div class="col-lg-7">
                            <form class="form-modal p-xl-3" action="<?= base_url('users/login') ?>" method="POST">
                                <div class="card-body pt-1">
                                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                                    
                                    <div class="card-header px-4 py-2">
                                        <h1 class="bold text-center">ورود | ثبت نام</h1>
                                    </div>

                                    <div class="row" id="alert-message">
                                        <div class="col-12">
                                            <?php if ($this->session->flashdata('frontend_error')) : ?>
                                                <div class="alert alert-danger">
                                                    <?= $this->session->flashdata('frontend_error') ?>
                                                </div>
                                            <?php elseif ($this->session->flashdata('frontend_success')) : ?>
                                                <div class="alert alert-success">
                                                    <?= $this->session->flashdata('frontend_success') ?>
                                                </div>
                                            <?php elseif (isset($message_danger)) : ?>
                                                <div class="alert alert-danger">
                                                    <?= $message_danger ?>
                                                </div>
                                            <?php endif; ?>
                                        </div><!-- /.col -->
                                    </div><!-- /.row -->

                                    <div class="row">
                                        <div class="col-12 col-12 pe-2 mb-3">
                                            <label class="p-t-10">شماره همراه</label>
                                            <?php
                                            if ($this->session->flashdata('username') != false) {
                                                $value = html_escape($this->session->flashdata('username'));
                                            }else{
                                                $value = set_value('username');
                                            }
                                            ?>
                                            <input type="text" class="form-control numeric text-center ltr font-lg" maxlength="11" name="username" value="<?= $value ?>">
                                            <div class="help-block"></div>
                                        </div><!-- /.col-12 -->


                                        <?php if (isset($captcha_image)) : ?>
                                            <div class="col-12 col-12 pe-2 mb-3 col-field col-captcha">
                                                <label>
                                                    کد امنیتی:
                                                    <a href="javascript:void(0);" class="btn-link text-dark reload-captcha" tabindex="-1"><i class="fa fa-undo"></i> کد جدید</a>
                                                </label>
                                                <div class="row">
                                                    <div class="col-7 captcha-image">
                                                        <?= $captcha_image ?>
                                                    </div>
                                                    <div class="col-5">
                                                        <input type="number" class="form-control txt-captcha text-center ltr font-lg numeric tahoma" name="captcha" title="کد امنیتی" required>
                                                    </div>
                                                </div>
                                                <div class="help-block"></div>
                                            </div><!-- /.col -->
                                        <?php endif; ?>
                                    </div><!-- /.row -->

                                    <div class="row mt-3">
                                        <div class="col-md-6 m-auto">
                                            <button class="btn bg-gradient-primary w-100" name="submit" value="submit">
                                                ورود به سایت
                                            </button>
                                        </div><!-- /.col -->
                                    </div><!-- /.row -->
                                </div><!-- /.card-body -->
                            </form>
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.card -->

                <div class="text-center">
                    <a href="<?= base_url('') ?>"> <i class="fa fa-arrow-right"></i> بازگشت به صفحه اصلی</a>
                </div>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</section>


<?php if($rules_page): ?>
    <!-- Modal -->
    <div id="modal-rules" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                    <h4 class="modal-title"><?= $rules_page->title ?></h4>
                </div>
                <div class="modal-body">
                    <?= $rules_page->content ?>
                </div>
            </div>
        </div>
    </div>
<?php endif;?>