<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<section class="py-lg-3 py-4">
    <div class="container inquiry-page">
        <div class="row">
            <div class="col-md-8 m-auto">
                <div class="card box-shadow-xl overflow-hidden mb-4">
                    <div class="row">
                        <div class="col-lg-5 position-relative bg-cover d-none d-sm-flex" style="background-image: url(<?= base_url($bg_image_side) ?>);" loading="lazy">
                            <div class=" w-100 h-100 z-index-2 d-flex m-auto justify-content-center">
                                <div class="mask bg-gradient-dark"></div>
                                <div class="side-texts position-relative my-auto z-index-2">
                                    <h2 class="text-center mb-3 bold mt-5"><?= $settings->site_name ?></h2>
                                    <div class="d-flex p-2 text-white my-3">
                                        <div class="ps-3">
                                            <ul>
                                                <?php if(!in_array('national_code', $user_login->matched_fields)): ?>
                                                    <li><i class="fa fa-check"></i> کد ملی با شماره همراه مطابقت داشته باشد.</li>
                                                <?php endif ?>
                                                <?php if(!in_array('birth_date', $user_login->matched_fields)): ?>
                                                    <li><i class="fa fa-check"></i> تاریخ تولد با کد ملی مطابقت داشته باشد.</li>
                                                <?php endif ?>
                                            </ul>
                                        </div>
                                    </div><!-- /.d-flex -->
                                </div><!-- /.side-texts -->
                            </div><!-- /.w-100 -->
                        </div><!-- /.col -->

                        <div class="col-lg-7">
                            <form class="form-modal p-xl-3" action="<?= base_url('identity-inquiry') ?>" method="POST">
                                <div class="card-body pt-1">
                                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                                    
                                    <div class="card-header px-4 py-2">
                                        <h1 class="bold text-center">
                                            <?php 
                                            if(!in_array('national_code', $user_login->matched_fields) && !in_array('birth_date', $user_login->matched_fields)){
                                                echo 'ثبت کد ملی و تاریخ تولد';
                                            } elseif(!in_array('national_code', $user_login->matched_fields)){
                                                echo 'ثبت کد ملی';
                                            } else {
                                                echo 'ثبت تاریخ تولد';
                                            }
                                            ?>
                                        </h1>
                                    </div>

                                    <div class="row" id="alert-message">
                                        <div class="col-12">
                                            <?php if (isset($error_message)) : ?>
                                                <div class="alert alert-danger">
                                                    <?= $error_message ?>
                                                </div>
                                            <?php elseif ($this->session->flashdata('frontend_success')) : ?>
                                                <div class="alert alert-success">
                                                    <?= $this->session->flashdata('frontend_success') ?>
                                                </div>
                                            <?php elseif ($this->session->flashdata('frontend_error')) : ?>
                                                <div class="alert alert-danger">
                                                    <?= $this->session->flashdata('frontend_error') ?>
                                                </div>
                                            <?php endif; ?>
                                        </div><!-- /.col -->
                                    </div><!-- /.row -->

                                    <div class="row">
                                        <div class="col-12 col-12 pe-2 mb-3">
                                            <label>شماره همراه</label>
                                            <input type="text" class="form-control ltr text-center" disabled value="<?= $user_login->cell_phone ?>">
                                        </div><!-- /.col-12 -->
                                        <div class="col-12 col-12 pe-2 mb-3">
                                            <label>
                                                کد ملی
                                                <?php if(!in_array('national_code', $user_login->matched_fields)): ?>
                                                    <small>(با شماره همراه مطابقت داشته باشد.)</small>
                                                <?php endif; ?>
                                            </label>
                                            <input type="text" class="form-control ltr text-center" <?= (in_array('national_code', $user_login->matched_fields)) ? 'disabled' : ''; ?> maxlength="10" name="national_code" value="<?= set_value('national_code', $user_login->national_code) ?>" >
                                        </div><!-- /.col-12 -->

                                        <div class="col-12 col-12 pe-2 mb-3">
                                            <label>تاریخ تولد <small>(با کد ملی مطابقت داشته باشد.)</small></label>
                                            <input type="text" class="form-control ltr text-center" id="txt-birth-date" name="birth_date" value="<?= (isset($posted_data->birth_date_gregorian)) ? $posted_data->birth_date_gregorian : '' ?>" autocomplete="off">
                                        </div><!-- /.col-12 -->
                                        
                                    </div><!-- /.row -->

                                    <div class="row mt-3">
                                        <div class="col-md-8 m-auto">
                                            <a href="javascript:void(0);" class="btn bg-gradient-primary w-100 btn-save">ذخیره</a>
                                            <button class=" d-none" name="submit" value="submit" disabled></button>
                                        </div><!-- /.col -->
                                    </div><!-- /.row -->
                                </div><!-- /.card-body -->
                            </form>
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.card -->

                <div class="text-center">
                    <a href="<?= base_url('') ?>"> <i class="fa fa-arrow-right"></i> بازگشت به صفحه اصلی</a>
                </div>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</section>
<script>
    $(".btn-save").on("click", function(){
        $(this).addClass("disabled");
        $(this).attr("disabled", true);
        $(this).next("button").removeAttr("disabled").click();
    });
</script>