<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="text-center caption">
                    <h1><i class="fa fa-credit-card"></i> تراکنش های من</h1>
                </div>

                <div class="card px-3 py-3">
                    <?php if ($this->session->flashdata('frontend_success')): ?>
                        <div class="row  m-t-10 m-b-10">
                            <div class="col-12 col-lg-6 m-auto">
                                <div class="alert alert-success text-center">
                                    <?= $this->session->flashdata('frontend_success') ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($transactions) : ?>
                        <div class="m-b-10">
                            <span class="bold">راهنمای رنگ</span>
                            <label>:</label>
                            <label class="badge btn-success">موفق</label>
                            <label class="badge btn-warning">منتظر تایید</label>
                            <label class="badge btn-danger">ناموفق/ رد شده</label>
                            <label class="badge bg-secondary">خرید / برداشت</label>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover text-center m-t-10">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>ش. پیگیری سفارش</th>
                                        <th>مبلغ(تومان)</th>
                                        <th>ش. پیگیری تراکنش</th>
                                        <th>نوع</th>
                                        <th>درگاه</th>
                                        <th>زمان</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($transactions as $key => $item) : ?>
                                        <?php
                                        $card2card_status = '';
                                        if($item->gateway == 'card2card'){
                                            if($item->completed == 1){
                                                $card2card_status = 'accept';
                                            } elseif($item->reject == 0){
                                                $card2card_status = 'pending';
                                            } elseif($item->reject == 1){
                                                $card2card_status = 'reject';
                                            }
                                        }

                                        if($item->completed){
                                            $color = ($item->amount > 0) ? 'badge btn-success' : 'badge bg-secondary';
                                        } else {
                                            $color = ($item->reject) ? 'badge btn-danger' : 'badge btn-warning';
                                        }
                                        ?>
                                        <tr>
                                            <td><?= $offset + $key + 1  ?></td>
                                            <td><?= $item->tracking_code ?></td>
                                            <td class="text-left ltr">
                                                <span class="font-sm <?= $color ?>"><?= ($item->amount > 0 ) ? '+' : '' ?><?=  number_format($item->amount) ?></span>
                                                <?php if($item->amount_dollar): ?>
                                                    <div class="curve px-2 bg-info text-white font-xs mt-1 rtl bold">
                                                        <span>
                                                            <span>مبلغ دلاری:</span>
                                                            <span class="font-en"><?= floatval($item->amount_dollar) ?></span>
                                                        </span>
                                                        <span>
                                                            <span>قیمت دلار:</span>
                                                            <?= $item->dollar_rate ? number_format($item->dollar_rate) : '0' ?> تومان
                                                        </span>
                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="maybe-long"><?= $item->reference ?></div>
                                            </td>
                                            <td><?= getTransactionTypes($item->type) ?></td>
                                            <td>
                                                <?php if($item->gateway == 'card2card'): ?>
                                                    <span class="cursor-pointer btn-detail" data-id="<?= $item->id ?>">
                                                        <span><?= $item->gateway_fa ?></span>
                                                        (<span class="">بیشتر</span>)
                                                    </span>
                                                <?php else: ?>
                                                    <span><?= $item->gateway_fa ?></span>
                                                <?php endif ?>
                                            </td>
                                            <td><?= $item->created ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->

                        <div class="text-center">
                            <?php
                            echo $this->pagination->create_links();
                            ?>
                        </div><!-- /.text-center -->
                    <?php else : ?>
                        <div class="alert alert-info curv text-center">
                            <p>
                                <i class="fa fa-info-circle"></i>
                                کاربر گرامی هنوز تراکنشی از سمت شما انجام نشده است.
                            </p>
                        </div><!-- /.alert -->
                    <?php endif; ?>
                </div>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.main -->

<div id="modal-transaction-detail" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                <h4 class="modal-title">اطلاعات کارت به کارت</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12 col-md-10 m-auto">
                        <div class="text-center">
                            <h2> شماره پیگیری سفارش : <span class="tracking-code">TRACKING-CODE</span></h2>
                        </div>
                        <hr>
                    </div><!-- /.col -->

                    <div class="col-12 col-md-10 m-auto text-center">
                        <div class="row">
                            <div class="col-12 col-md-4">
                                <p>شماره پیگیری تراکنش:</p>
                                <p class="fw-bold mt-1 reference">REFERENCR</p>
                            </div><!-- /.col -->
                            <div class="col-12 col-md-4">
                                <p>شماره کارت:</p>
                                <p class="fw-bold mt-1 customer-card">CUSTOMER-CARD</p>
                            </div><!-- /.col -->
                            <div class="col-12 col-md-4">
                                <p>زمان واریز:</p>
                                <p class="fw-bold mt-1 ltr transfer-date">TRANSFER-DATE</p>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <hr>
                    </div><!-- /.col -->
                    <div class="col-12 col-md-10 m-auto text-center">
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <p class="d-none d-md-block">توضیحات:</p>
                                <p class="fw-bold mt-1 transfer-description">TRANSFER-DESCRIPTION</p>
                            </div><!-- /.col -->
                            <div class="col-12 col-md-6">
                                <p class="d-none d-md-block">تصویر:</p>
                                <p class="mt-1"><img class="img-fluid transfer-image" src=""></p>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div>
        </div>
    </div>
</div>

<script>
    let transactions = new Array();
    <?php if($transactions): ?>
        <?php foreach ($transactions as $transaction): ?>
            <?php if($transaction->gateway == 'card2card'): ?>
                transactions.push({
                    'id': '<?= number_format($transaction->id) ?>',
                    'amount': '<?= number_format($transaction->amount) ?>',
                    'trackingCode': '<?= $transaction->tracking_code ?>',
                    'reference': '<?= html_escape($transaction->reference) ?>',
                    'customerCard': '<?= $transaction->detail->customer_card ?>',
                    'transferDate': '<?= $transaction->detail->transfer_date ?>',
                    'image': '<?= $transaction->detail->image ?>',
                    'transferDescription': '<?= html_escape($transaction->detail->description) ?>',
                });
            <?php endif; ?>
        <?php endforeach ?>
    <?php endif; ?>

    $(document).ready(function(){
        $(".btn-detail").on("click", function(){
            let id = $(this).attr("data-id");
            let transaction = null;
            transactions.forEach(function(item, key){
                if(item.id == id){
                    transaction = item;
                }
            });

            if(transaction == null){
                return;
            }

            let target = $("#modal-transaction-detail");

            target.find(".reference").html(transaction.reference);
            target.find(".tracking-code").html(transaction.trackingCode);
            target.find(".customer-card").html(transaction.customerCard);
            target.find(".transfer-date").html(transaction.transferDate);
            target.find(".transfer-description").html(transaction.transferDescription);

            target.find("img").attr("src", transaction.image);
            if(transaction.image){
                target.find("img").removeClass("d-none");
            } else {
                target.find("img").addClass("d-none");

            }

            target.modal("show");
        });
    });
</script>