<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="text-center caption">
                    <h1>
                        <span class="bold"><?= html_escape($ticket->title) ?></span>
                    </h1>
                </div>

                <div class="row">
                    <div class="col-xl-10 m-auto">
                        <div class="card p-1 p-md-4">
                            <div class="page-text">
                                <div class="discussion-con">
                                    <ul class="discussion">
                                        <?php if ($messages) : ?>
                                            <?php foreach ($messages as $item) : ?>
                                                <?php
                                                $sender = ($item->user_id == $ticket->user_id) ? 'self' : 'other';
                                                $senedr_name = html_escape("$item->user_first_name $item->user_last_name");
                                                ?>
                                                <li class="<?= $sender ?>" data-id="<?= $item->id ?>">
                                                    <div class="avatar">
                                                        <img src="<?= base_url($item->user_image) ?>" alt="<?= $senedr_name ?>" title="<?= $senedr_name ?>">
                                                    </div>
                                                    <div class="message">
                                                        <div class="content">
                                                            <?= nl2br(html_escape($item->text)) ?>
                                                        </div><!-- /content -->
                                                        <span class="sender-name">
                                                            <i class="icon-pencil"></i>
                                                            <?= $senedr_name . ' در ' ?>
                                                        </span>
                                                        <time><?= $item->created ?></time>
                                                        <?php if($item->attach && file_exists($item->attach)): ?>
                                                            <a href="<?= base_url("tickets/download/$item->id") ?>" class="btn bg-gradient-primary btn-sm round btn-download">
                                                                <i class="icon-cloud-download"></i>
                                                                پیوست
                                                            </a>
                                                        <?php endif ?>
                                                    </div><!-- /message -->
                                                </li>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </ul>


                                    <div class="form-box mb-3 px-3">
                                        <?php if ($this->session->flashdata('frontend_error')): ?>
                                            <div class="alert alert-danger my-3">
                                                <p><?= $this->session->flashdata('frontend_error') ?></p>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($ticket->status != 'close' || ($ticket->status == 'close' && $settings->ticket->allow_send_after_close)): ?>
                                            <form class="center-block" id="form-data" role="form" method="POST" enctype="multipart/form-data">
                                                <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                                                <input type="hidden" name="ticket_id" value="<?= $ticket->id ?>">
                                                <textarea name="text" id="comment" rows="5" class="form-control" placeholder="پیام جدید"></textarea>
                                                <hr>
                                                <?php if($allowed_file_types): ?>
                                                    <div>
                                                        <p>فایل پیوست (پسوند های مجاز: <?= implode(', ', $allowed_file_types)?>) (حداکثر سایز: 3 MB)</p>
                                                        <input type="file" class="form-control ltr" name="attach">
                                                    </div>
                                                <?php endif ?>
                                                <div class="text-center mt-3">
                                                    <a href="javascript: void(0)" class="btn bg-gradient-primary btn-save">
                                                        <i class="fa fa-send"></i>
                                                        ارسال پیام
                                                    </a>
                                                    <?php if($ticket->status != 'close' && $settings->ticket->allow_close): ?>
                                                        <a href="javascript: void(0)" class="btn bg-gradient-danger me-2 btn-ticket-close">
                                                            <i class="fa fa-close"></i>
                                                            بستن تیکت
                                                        </a>
                                                    <?php endif;?>
                                                    <a href="<?= base_url('tickets') ?>" class="btn bg-gradient-secondary me-2">
                                                        <i class="fa fa-arrow-right"></i>
                                                        بازگشت
                                                    </a>
                                                </div>
                                            </form>
                                        <?php else: ?>
                                            <div class="row">
                                                <div class="col-lg-6 m-auto  text-center">
                                                    <div class="alert alert-danger">
                                                        <p>تیکت بسته شده است.</p>
                                                    </div>
                                                    <a href="<?= base_url('tickets') ?>" class="btn bg-gradient-secondary me-2">
                                                        <i class="fa fa-arrow-right"></i>
                                                        بازگشت
                                                    </a>
                                                </div><!-- /.col -->
                                            </div><!-- /.row -->
                                        <?php endif; ?>
                                    </div><!-- /.form-box -->
                                </div><!-- /.col .discussion-con -->
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.main -->


<script>
    $(document).ready(function() {
        <?php if (isset($first_message_unread)) : ?>
            var position_message = $("li[data-id='<?= $first_message_unread ?>']").offset().top - 200;
        <?php else : ?>
            var position_message = $("textarea[id='comment']").offset().top - 400;
        <?php endif; ?>
        $('html, body').animate({
            scrollTop: position_message
        }, 'fast');

        $(".btn-save").click(function() {
            var formData = new FormData(document.getElementById("form-data"));

            $.ajax({
                type: 'POST',
                url: baseUrl + 'tickets/messageSave',
                async: false,
                processData: false,
                contentType: false,
                cache: false,
                enctype: 'multipart/form-data',
                data: formData, // serializes the form's elements.
                success: function(data) {
                    var result = JSON.parse(data);

                    if (typeof result.csrf !== 'undefined') {
                        $("input[name='" + csrfToken + "']").val(result.csrf);
                    }

                    if (result.condition == true) {
                        window.location.assign(result.url);
                    } else {
                        swal({
                            title: 'ناموفق',
                            html: result.msg,
                            type: "error",
                            confirmButtonText: "باشه"
                        });
                    }
                }
            });
        });

        <?php if($ticket->status != 'close' && $settings->ticket->allow_close): ?>
            $(".btn-ticket-close").click(function() {
                swal({
                    title: "",
                    text: "آیا اطمینان دارید که این تیکت بسته شود؟",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonText: "بله",
                    cancelButtonText: "انصراف",
                    // closeOnConfirm: false,
                    // closeOnCancel: true //false
                }).then(function() {

                    var formData = new FormData(document.getElementById("form-data"));
                    $.ajax({
                        type: 'POST',
                        url: baseUrl + 'tickets/close',
                        async: false,
                        processData: false,
                        contentType: false,
                        cache: false,
                        data: formData, // serializes the form's elements.
                        success: function(data) {
                            var result = JSON.parse(data);

                            if (typeof result.csrf !== 'undefined') {
                                $("input[name='" + csrfToken + "']").val(result.csrf);
                            }

                            if (result.condition == true) {
                                window.location.assign(result.url);
                            } else {
                                swal({
                                    title: 'ناموفق',
                                    html: result.msg,
                                    type: "error",
                                    confirmButtonText: "باشه"
                                });
                            }
                        }
                    });
                }, function(dismiss) {
                });
            });
        <?php endif; ?>
    });
</script>