<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="text-center caption">
                    <h1>درخواست جدید</h1>
                </div>

                <div class="row">
                    <div class="col-xl-10 m-auto">
                        <div class="card px-4 py-4">
                            <div class="page-text mt-3">
                                <form action="<?= base_url('tickets/add') ?>" method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                                    <div class="row" id="alert-message">
                                        <div class="col-sm-12">
                                            <?php if ($this->session->flashdata('frontend_error')) : ?>
                                                <div class="alert alert-danger">
                                                    <?= $this->session->flashdata('frontend_error') ?>
                                                </div>
                                            <?php elseif ($this->session->flashdata('frontend_success')) : ?>
                                                <div class="alert alert-success">
                                                    <?= $this->session->flashdata('frontend_success') ?>
                                                </div>
                                            <?php elseif (isset($message_danger)) : ?>
                                                <div class="alert alert-danger">
                                                    <?= $message_danger ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div><!-- /.row -->

                                    <div class="row m-b-25">
                                        <div class="col-sm-3">
                                            <label class="p-t-10">عنوان</label>
                                            <span class="text-danger">*</span>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" placeholder="عنوان" name="title" value="<?= set_value('title') ?>">
                                        </div>
                                    </div><!-- /.row -->

                                    <div class="row m-b-25">
                                        <div class="col-sm-3">
                                            <label class="p-t-10">بخش</label>
                                            <span class="text-danger">*</span>
                                        </div>
                                        <div class="col-sm-9">
                                            <select class="form-select" name="category_id">
                                                <?php if ($categories) : ?>
                                                    <?php foreach ($categories as $item) : ?>
                                                        <option value="<?= $item->id ?>" <?= set_select('category_id', $item->id) ?>><?= $item->title ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div><!-- /.row -->

                                    <div class="row m-b-25">
                                        <div class="col-sm-3">
                                            <label class="p-t-10">فوریت</label>
                                            <span class="text-danger">*</span>
                                        </div>
                                        <div class="col-sm-9">
                                            <select class="form-select" name="priority">
                                                <option value="low" <?= set_select('priority', 'low') ?>><?= translatePriority('low') ?></option>
                                                <option value="normal" <?= set_select('priority', 'normal') ?>><?= translatePriority('normal') ?></option>
                                                <option value="high" <?= set_select('priority', 'high') ?>><?= translatePriority('high') ?></option>
                                            </select>
                                        </div>
                                    </div><!-- /.row -->

                                    <div class="row m-b-25">
                                        <div class="col-sm-3">
                                            <label>متن پیام:</label><span class="text-danger">*</span>
                                        </div>
                                        <div class="col-sm-9">
                                            <textarea class="form-control" rows="6" name="text"><?= set_value('text') ?></textarea>
                                        </div>
                                    </div><!-- /.row -->
                                    
                                    <?php if($allowed_file_types): ?>
                                        <div class="row m-b-25">
                                            <div class="col-sm-3">
                                                <label>فایل پیوست</label>
                                            </div>
                                            <div class="col-sm-9">
                                                <p>
                                                    (پسوند های مجاز: <?= implode(', ', $allowed_file_types)?>)
                                                    <span> | (حداکثر سایز: 3 MB)</span>
                                                </p>
                                                
                                                <input type="file" class="form-control ltr" name="attach">
                                            </div>
                                        </div><!-- /.row -->
                                    <?php endif ?>

                                    <div class="row">
                                        <div class="col-sm-3"></div>
                                        <div class="col-sm-9 mt-4 text-center">
                                            <button class="btn bg-gradient-primary" name="submit" value="submit">
                                                <i class="fa fa-send"></i>
                                                ارسال تیکت
                                            </button>
                                            <a href="<?= base_url('tickets') ?>" class="btn bg-gradient-secondary me-2">
                                                <i class="fa fa-arrow-right"></i>
                                                بازگشت
                                            </a>
                                        </div><!-- /.col -->
                                    </div><!-- /.row -->
                                </form>
                            </div><!-- /.page-text -->
                        </div><!-- /.card -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.main -->