<?php
/**
* @author Rayanik.com
*/
if (!defined('BASEPATH')) exit('No direct script access allowed');

// Product image
$img = '';
if($selected_product){
    if($image_size == 'large'){
        if($selected_product->large_image && file_exists($selected_product->large_image)){
            $img = $selected_product->large_image;
        } else if($selected_product->category_large_image && file_exists($selected_product->category_large_image)){
            $img = $selected_product->category_large_image;
        } else if($settings->default_category_large_image && file_exists($settings->default_category_large_image)){
            $img = $settings->default_category_large_image;
        } else {
            $img = 'assets/images/default-image-480x360.png';
        }
    } else {
        if($selected_product->image && file_exists($selected_product->image)){
            $img = $selected_product->image;
        } else if($selected_product->category_image && file_exists($selected_product->category_image)){
            $img = $selected_product->category_image;
        } else if($settings->default_category_image && file_exists($settings->default_category_image)){
            $img = $settings->default_category_image;
        } else {
            $img = 'assets/images/default-image-80x80.png';
        }
    }

}
?>
<div class="col-xl-9 m-auto" id="selected-product" data-id="<?= ($selected_product) ? $selected_product->id : '' ?>">
    <div class="card mb-4">
        <div class="row">
            <div class="col-12">
                <div class="selected-box">
                    <div class="col-selected-img">
                        <img src="<?= ($img) ? base_url($img) : '' ?>" alt="<?= ($selected_product) ? $selected_product->title : '' ?>">
                        <span class="special <?= ($selected_product && $selected_product->is_special) ? '' : 'hide' ?>">ویژه</span>
                    </div><!-- /.col-selected-img -->
                    <div class="col-selected-product">
                        <h1 class="title"><?= ($selected_product) ? $selected_product->title : '' ?></h1>
                        <a href="javascript:void(0);" class="btn-product-info final hide">
                            <span class="btn bg-gradient-primary">راهنما</span>
                        </a>

                        <?php if($selected_product && !$selected_product->is_exists): ?>
                            <p>
                                <span class="not-exist">ناموجود</span>
                            </p>
                        <?php endif ?>

                        <div class="price-box <?= ($selected_product && $selected_product->is_exists) ? '' : 'hide'  ?>">
                            <span class="del-price"><?= ($selected_product && $selected_product->price) ? number_format($selected_product->price) : '' ?></span>
                            <span class="price"><?= ($selected_product) ? number_format($selected_product->sell_price) : '' ?></span>
                            <span class="currency">تومان</span>
                        </div><!-- /.price-box -->
                    </div><!-- /.col-selected-product -->
                </div><!-- /.selected-box -->
            </div><!-- /.col -->

            <?php if($access_buy->condition == false): ?>
                <div class="col-12">
                    <?php
                    switch ($access_buy->error) {
                        case 'no_login':
                            $message = 'کاربر گرامی برای تکمیل خرید خود لطفا ابتدا وارد سایت شوید.';
                            $btn_title = 'ورود به سایت';
                            break;
                        case 'no_national_code':
                            $message = 'کاربر گرامی برای تکمیل خرید خود لطفا ابتدا کد ملی خود را ثبت کنید.';
                            $btn_title = 'ثبت کد ملی';
                            break;
                        case 'no_birth_date':
                            $message = 'کاربر گرامی برای تکمیل خرید خود لطفا ابتدا تاریخ تولد خود را ثبت کنید.';
                            $btn_title = 'ثبت تاریخ تولد';
                            break;
                        
                        default:
                            $message = '';
                            break;
                    }
                    ?>
                    <?php if($message): ?>
                        <hr>
                        <div class="not-access-buy text-center <?= ($selected_product && !$selected_product->is_exists) ? 'hide' : ''; ?>">
                            <div class="">
                                <p><?= $message ?></p>
                            </div>
                            <a href="javascript:void(0)" class="btn bg-gradient-primary m-b-0" id="btn-redirect" data-redirect="<?= $access_buy->redirect ?>"><?= $btn_title ?></a>
                        </div>
                    <?php endif ?>
                </div><!-- /.col -->
            <?php endif ?>

            <?php if($selected_product && $selected_product->has_description): ?>
                <div class="col-12">
                    <div class="category-description mb-2">
                        <hr>
                        <div class="text">
                            <?= $selected_product->description ?>
                        </div>
                        <button type="button" class="btn bg-gradient-primary btn-toggle-description d-none">اطلاعات بیشتر</button>
                    </div>
                </div><!-- /.col -->
            <?php endif ?>
        </div><!-- /.row -->
    </div><!-- /.card -->
</div>
<?php if($access_buy->condition == true && ($is_spa || (!$is_spa && $selected_product && $selected_product->is_exists))): ?>
    <form id="main-form" action="<?= base_url('order/save') ?>" method="post" enctype="multipart/form-data" class="<?= ($selected_product && $selected_product->is_exists) ? '' : 'hide' ?>">
        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
        <input type="hidden" name="product_id" value="<?php if($selected_product) echo $selected_product->id; ?>">
        <input type="hidden" name="qty" value="<?php if($selected_product) echo $selected_product->min_qty; ?>">
        <input type="hidden" name="price" value="<?php if($selected_product) echo $selected_product->min_qty * $selected_product->sell_price; ?>">
        <div class="row">
            <div class="col-md-6 m-b-20 information-box">
                <div class="shadow half-box p-15">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label>شماره همراه <span class="small"><?php if(!$user_login) echo '(اجباری)'; ?></span></label>
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-mobile font-lg"></i>
                                    </span>
                                    <input value="<?php if($user_login) echo  $user_login->cell_phone; ?>" type="text" id="txt-cellphone" name="cell_phone" class="form-control ltr numeric" maxlength="11" placeholder="مثلا 09123456789" data-validation="cellphone" title="شماره همراه" <?= ($user_login) ? 'disabled' : 'required'; ?>>
                                </div><!-- /.input-group -->
                                <div class="help-block"></div>
                            </div><!-- /.form-group -->
                        </div><!-- /.col -->
                        <div class="col-12">
                            <div class="row" id="other-fields">
                                <?php if($selected_category || $selected_product): ?>
                                    <?php $category_fields = ($selected_category) ? $selected_category->fields : $selected_product->category_fields; ?>
                                    <?php foreach ($category_fields as $item): ?>
                                        <div class="<?= $item->col ?>">
                                            <div class="form-group">
                                                <label>
                                                    <?= $item->title ?> 
                                                    <span class="small"><?= ($item->required) ? '(اجباری)' : '(اختیاری)' ?></span>
                                                </label>
                                                <div class="input-group">
                                                    <span class="input-group-addon">
                                                        <i class="<?= $item->icon ?>"></i>
                                                    </span>
                                                    <?php if($item->statics_key == 'description'): ?>
                                                        <textarea value="<?= html_escape($item->value) ?>"  name="<?= $item->name ?>" class="form-control <?= $item->class?>" placeholder="" data-validation="<?= $item->validation ?>" title="<?= $item->title ?>" <?= ($item->required) ? 'required' : '' ?>></textarea>
                                                    <?php else: ?>
                                                        <input value="<?= html_escape($item->value) ?>" type="text" name="<?= $item->name ?>" class="form-control <?= ($item->ltr) ? 'ltr' : '' ?> <?= $item->class ?>" placeholder="" data-validation="<?= $item->validation ?>" title="<?= $item->title ?>" <?= ($item->required) ? 'required' : '' ?> <?= (isset($item->disabled)) ? 'disabled' : '' ?> >
                                                    <?php endif; ?>
                                                </div><!-- /.input-group -->
                                                <div class="help-block"></div>
                                            </div><!-- /.form-group -->
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                                
                            </div><!-- /.col -->
                        </div><!-- /.col -->
                            
                        <?php if($settings->show_coupon_box): ?>
                            <div class="col-12">
                                <hr class="double">
                                <div class="form-group">
                                    <label>کد تخفیف <span class="small">(اگر کد دارید وارد کنید)</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control ltr text-left" id="txt-coupon" name="coupon" placeholder="در صورتی که کد تخفیف دارید وارد کنید" title="کد تخفیف">
                                        <span class="input-group-btn">
                                            <button class="btn bg-gradient-success" id="apply-coupon" type="button">
                                                <span class="loading hide"><i class="fa fa-spinner fa-spin"></i></span>
                                                ثبت
                                            </button>
                                        </span>
                                    </div>
                                    <div class="help-block"></div>
                                    <div class="alert hide" id="alert-result-coupon"></div>
                                </div><!-- /.form-group -->
                            </div><!-- /.col -->
                        <?php endif; ?>
                        <?php if($settings->show_gift_box): ?>
                            <div class="col-12">
                                <hr class="double">
                                <div class="form-group">
                                    <label>کارت هدیه <span class="small">(اگر کد دارید وارد کنید)</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control ltr text-left" id="txt-gift" name="gift" placeholder="در صورتی که کارت هدیه دارید وارد کنید" title="کارت هدیه"  autocomplete="off">
                                        <span class="input-group-btn">
                                            <button class="btn bg-gradient-success" id="save-gift" type="button">
                                                <span class="loading hide"><i class="fa fa-spinner fa-spin"></i></span>
                                                ثبت
                                            </button>
                                        </span>
                                    </div>
                                    <div class="help-block"></div>
                                    <div class="alert hide" id="alert-result-gift"></div>
                                </div><!-- /.form-group -->
                            </div><!-- /.col -->
                        <?php endif; ?>
                        <?php
                        $payment_alerts = json_decode($settings->payment_alerts);
                        if ($payment_alerts) {
                            ?>
                            <div class="col-md-12 col-sm-12 m-t-5">
                                <div class="alert alert-info <?= ($settings->show_coupon_box || $settings->show_gift_box) ? '' : 'm-t-20' ?>">
                                    <?php foreach ($payment_alerts as $item) : ?>
                                        <?php if ($item): ?>
                                            <p>
                                                <i class="fa fa-check"></i>
                                                <?= $item ?>
                                            </p>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            </div><!-- /.col -->
                            <?php
                        }
                        ?>
                    </div><!-- /.row -->
                </div><!-- /.half-box -->
            </div><!-- /.col -->
    
            <div class="col-md-6 m-b-20 pay-box">
                <div class="shadow half-box p-15">
                    <div class="row has-style form-group">
                        <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                            <span class="title-box">تعداد:</span>
                        </div>
                        <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                            <div class="quantity">
                                <button class="btn btn-icon btn-default btn-plus" type="button">
                                    <i class="fa fa-plus"></i>
                                </button>
                                <input type="text" value="<?= ($selected_product) ? $selected_product->min_qty : 1 ?>" class="numeric" id="txt-qty" min="<?= ($selected_product) ? $selected_product->min_qty : 1 ?>" max="<?= ($selected_product) ? $selected_product->max_qty : 1 ?>" title="تعداد">
                                <button class="btn btn-icon btn-default btn-minus" type="button">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </div><!-- /.quantity -->
                        </div>
                        <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9 me-auto">
                            <div class="help-block mb-1 mt-0"></div>
                        </div>
                    </div><!-- /.row -->
                    <div class="row has-style">
                        <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                            <span class="title-box">جمع کل:</span>
                        </div>
                        <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                            <label class="box">
                                <?php
                                $main_price = 0;
                                if($selected_product){
                                    $main_price = ($selected_product->price > $selected_product->sell_price) ? $selected_product->price : $selected_product->sell_price;
                                    $main_price *= $selected_product->min_qty;
                                }
                                ?>
                                <span class="price" id="total"><?= number_format($main_price) ?></span>
                                <small class="currency">تومان</small>
                            </label>
                        </div>
                    </div><!-- /.row -->
                    <div class="row has-style">
                        <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                            <span class="title-box">تخفیف:</span>
                        </div>
                        <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                            <label class="box">
                                <span class="price" id="discount"><?= ($selected_product && $selected_product->price > $selected_product->sell_price) ? number_format($selected_product->min_qty * ($selected_product->price - $selected_product->sell_price)) : 0 ?></span>
                                <small class="currency">تومان</small>
                            </label>
                        </div>
                    </div><!-- /.row -->
                    <?php if($settings->show_coupon_box): ?>
                        <div class="row has-style hide">
                            <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                                <span class="title-box">تخفیف کوپن:</span>
                            </div>
                            <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                                <label class="box">
                                    <span class="price" id="coupon-discount">0</span>
                                    <small class="currency">تومان</small>
                                </label>
                            </div>
                        </div><!-- /.row -->
                    <?php endif; ?>
                    <?php if($user_login): ?>
                        <div class="row m-b-20 <?= ($user_login->credit) ? '' : 'hide'; ?>">
                            <div class="col-12">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="1" name="use_wallet" id="chk-use-wallet">
                                    <label class="form-check-label" for="chk-use-wallet">
                                        از کیف پولم استفاده می کنم.(موجودی:  <span class="user-credit"><?= number_format($user_login->credit) ?></span> تومان)
                                    </label>
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    <?php endif; ?>
                    <div class="row has-style">
                        <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                            <span class="title-box">قابل پرداخت:</span>
                        </div>
                        <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                            <label class="box source">
                                <span id="pure-total">
                                    <span class="price" ><?= ($selected_product) ? number_format($selected_product->min_qty * $selected_product->sell_price) : 0 ?></span>
                                    <small class="currency">تومان</small>
                                </span>
                                <span id="use-amount-wallet" class="hide">
                                    <span class="plus hide">+</span>
                                    <span class="price"></span>
                                    <small class="currency">تومان از کیف پول</small>
                                </span>
                            </label>
                        </div>
                    </div><!-- /.row -->
                    
                    <div id="pure-dollar-total" class="row has-style <?= intval($settings->rate->dollar) > 0 ? '' : 'd-none' ?> <?= in_array($default_gateway, $dollar_gateways) ? '' : 'hide'?>">
                        <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                            <span class="title-box">معادل:</span>
                        </div>
                        <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                            <label class="box">
                                <span class="amount"></span>
                                <span class="currency pe-1">دلار</span>
                            </label>
                        </div>
                    </div><!-- /.row -->

                    <?php if (isset($captcha_image)): ?>
                        <div class="row has-style">
                            <div class="col-4 col-sm-3 col-md-5 col-lg-4 col-xl-3">
                                <span class="title-box">کد امنیتی<span class="text-danger">*</span></span>
                            </div>
                            <div class="col-8 col-sm-9 col-md-7 col-lg-8 col-xl-9">
                                <div class="row">
                                    <div class="col-sm-7 col-md-12 col-lg-8 col-xl-7">
                                        <btn class="btn btn-dark btn-icon has-tooltip reload-captcha mb-1" title="کد امنیتی جدید" ><i class="fa fa-refresh"></i></btn>
                                        <span class="captcha-image"><?= $captcha_image ?></span>
                                    </div>
                                    <div class="col-sm-5 col-md-12 col-lg-4 col-xl-5">
                                        <input type="text" class="form-control ltr text-left" id="captcha" title="کد امنیتی" placeholder="کد امنیتی" autocomplete="off" name="captcha" required>
                                        <div class="help-block"></div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.row -->
                    <?php endif ?>
                    
                    <?= $html_gateways ?>
    
                    <div class="col-12 m-t-10 m-b-10">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="" id="chk-agreement" checked>
                            <label class="form-check-label" for="chk-agreement">
                                قوانین و ضوابط سایت را مطالعه کرده و می پذیرم.
                                <?php if($rules_page): ?>
                                    <a href="#" data-bs-toggle="modal" data-bs-target="#modal-rules">مشاهده قوانین و ضوابط</a>
                                <?php endif; ?>
                            </label>
                            <div class="help-block"></div>
                        </div>
                    </div><!-- /.col -->
                    <div class="col-md-12 col-xs-12">
                        <div class="alert alert-danger <?php if($selected_product) echo 'hide'; ?>" id="product-not-selected">
                            <div class="text-center">محصولی انتخاب نشده است.</div>
                        </div><!-- /.alert -->
                    </div><!-- /.col -->
                    <div class="col-12 text-center m-t-30">
                        <button type="button" class="btn bg-gradient-primary font-md m-t-0" id="btn-save">
                            <i class="fa fa-credit-card"></i> پرداخت و ثبت
                        </button>
                    </div><!-- /.col -->
                </div><!-- /.half-box -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    </form>
<?php endif; ?>

