<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="container">
    <?php if(isset($error_message)): ?>
        <div class="alert alert-danger text-center p-t-50 p-b-50 m-t-40 curve">
            <h2>
                <?= (is_array($error_message)) ? implode('<br>', $error_message) :$error_message ?>
            </h2>
        </div>

        <div class="text-center m-t-20">
            <a class="btn btn-secondary" href="<?= base_url() ?>">
                <i class="fa fa-arrow-right"></i>
                بازگشت به صفحه نخست
            </a>
        </div><!-- /.text-center -->
    <?php elseif(isset($transaction) && $transaction->type == 'charge'): ?>
        <div class="row products">
            <div class="col-md-8 m-auto">
                <div class="caption text-center">
                    <h1>اطلاعات تراکنش :  </h1>
                </div>
                <div class="alert alert-success text-center mb-0">کیف پول شما با موفقیت شارژ شد.</div>
            </div><!-- /.col -->

            <div class="col-md-8 m-auto m-b-50 en-numbers">
                <div class="general-info bg-white shadow border curve m-t-20 p-t-15 p-b-15">
                    <div class="row">
                        <div class="col-md-4">
                            ش.پیگیری تراکنش: <?= $transaction->reference ?>
                        </div><!-- /.col -->
                        <div class="col-md-4">
                            مبلغ: <?= number_format($transaction->amount) ?> تومان
                        </div><!-- /.col -->
                        <div class="col-md-4">
                            تاریخ: <?= $this->pdate->date('Y-m-d H:i', strtotime($transaction->created)) ?>
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.general-info -->
                <div class="text-center m-t-20">
                    <a class="btn btn-secondary" href="<?= base_url() ?>">
                        <i class="fa fa-arrow-right"></i>
                        بازگشت به صفحه نخست
                    </a>
                </div><!-- /.text-center -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    <?php else: ?>
        <div class="row products">
            <div class="col-md-8 m-auto">
                <div class="caption text-center">
                    <h1>اطلاعات خرید شما :  </h1>
                </div>
                <?php if(isset($transaction) && isset($unpaid_order_error)): ?>
                    <div class="alert alert-success text-center">
                        پرداخت شما با موفقیت انجام شد و مبلغ 
                        <span class="bold"><?= number_format($transaction->amount)?></span>
                        تومان کیف پول شما شارژ شد.
                    </div>

                    <div class="alert alert-danger text-center">
                        <?= $unpaid_order_error ?>
                    </div>

                    <div class="col-md-12 m-b-50 en-numbers">
                        <div class="general-info bg-white shadow border curve m-t-20 p-t-15 p-b-15">
                            <div class="row">
                                <div class="col-md-4">
                                    ش.پیگیری تراکنش: <?= $transaction->reference ?>
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    مبلغ: <?= number_format($transaction->amount) ?> تومان
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    تاریخ: <?= $this->pdate->date('Y-m-d H:i', strtotime($transaction->created)) ?>
                                </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div><!-- /.general-info -->
                        <div class="text-center m-t-20">
                            <a class="btn btn-secondary" href="<?= base_url() ?>">
                                <i class="fa fa-arrow-right"></i>
                                بازگشت به صفحه نخست
                            </a>
                        </div><!-- /.text-center -->
                    </div><!-- /.col -->

                <?php else: ?>
                    <div class="alert alert-success text-center mb-0">خرید شما با موفقیت انجام شد</div>
                <?php endif; ?>
            </div><!-- /.col -->
            <?php if(isset($order)): ?>
                <div class="col-md-8 m-auto m-b-50 en-numbers">
                    <div class="general-info bg-white shadow border curve m-t-20 p-t-15 p-b-15">
                        <div class="row">
                            <div class="col-sm-6">
                                شماره پیگیری: <?= $order->tracking_code ?>
                            </div><!-- /.col -->
                            <div class="col-sm-6">
                                شماره سفارش: <?= $order->id ?>
                            </div><!-- /.col -->
                            <div class="col-sm-6">
                                مبلغ: <?= number_format($order->price) ?> تومان
                            </div><!-- /.col -->
                            <div class="col-sm-6">
                                تاریخ: <?= $order->jalali_created ?>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.general-info -->
                    <hr class="double">
                    <div class="shadow border bg-white curve m-b-30 p-t-15 p-b-15  standard-cards">
                        <?php if(isset($auth_call_required) && $auth_call_required): ?>
                            <div class="alert alert-success text-center m-15 curve">
                                برای دریافت اطلاعات خرید خود، لطفا <strong>احراز هویت تلفنی</strong> را انجام دهید.
                            </div>
                        <?php elseif($order->pending): ?>
                            <div class="alert alert-success text-center m-15 curve">
                                اطلاعات سفارش شما به زودی در <strong>خریدهای من</strong> بارگذاری خواهد گردید.
                            </div>
                        <?php elseif(isset($cards) && $cards): ?>
                            <?php foreach ($cards as $key => $card): ?>
                                <?php $line_number = $key + 1;?>
                                <div class="card-row">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="title bold">
                                                <span>نام محصول</span>
                                                <?= $line_number . ': ' . $card->title ?>
                                            </div>
                                        </div><!-- /.col -->
                                        <div class="col-sm-12 card-code-info">
                                                <div class="title">
                                                    <?= $category_fields->field1_title ?> :
                                                </div>
                                                <div class="serial">
                                                    <button type="button" class="btn bg-gradient-success btn-sm btn-copy" data-copy="serial1-<?= $line_number ?>">
                                                        کپی 
                                                        <i class="fa fa-copy"></i>
                                                    </button>
                                                    <span id="serial1-<?= $line_number ?>"><?= $card->code ?></span>
                                                </div>
                                        </div><!-- /.col -->
                                        <?php if ($card->code2): ?>
                                            <div class="col-sm-12 card-code-info">
                                                <div class="title">
                                                    <?= $category_fields->field2_title ?> : 
                                                </div>
                                                <div class="serial">
                                                    <button type="button" class="btn bg-gradient-success btn-sm btn-copy" data-copy="serial2-<?= $line_number ?>">
                                                        کپی
                                                        <i class="fa fa-copy"></i>
                                                    </button>
                                                    <span id="serial2-<?= $line_number ?>"><?= $card->code2 ?></span>
                                                </div>
                                            </div><!-- /.col -->
                                        <?php endif; ?>
                                        <?php if ($card->code3): ?>
                                            <div class="col-sm-12 card-code-info">
                                                <div class="title">
                                                    <?= $category_fields->field3_title ?> : 
                                                </div>
                                                <div class="serial">
                                                    <button type="button" class="btn bg-gradient-success btn-sm btn-copy" data-copy="serial3-<?= $line_number ?>">
                                                        کپی
                                                        <i class="fa fa-copy"></i>
                                                    </button>
                                                    <span id="serial3-<?= $line_number ?>"><?= $card->code3 ?></span>
                                                </div>
                                            </div><!-- /.col -->
                                        <?php endif; ?>
                                        <?php if ($card->information): ?>
                                            <div class="col-sm-12">
                                                <div class="card-other-information">
                                                    <?= $card->information ?>                                                
                                                </div>
                                            </div><!-- /.col -->
                                        <?php endif; ?>
                                        <?php if ($card->file && file_exists($card->file)): ?>
                                            <div class="col-sm-12 text-center m-t-20">
                                                <a href="<?= base_url("cards/download/$card->id") ?>" class="btn bg-gradient-secondary">
                                                    <i class="fa fa-download"></i>
                                                    دانلود فایل
                                                </a>
                                            </div><!-- /.col -->
                                        <?php endif; ?>
                                    </div><!-- /.row -->
                                </div><!-- /.card-row -->
                            <?php endforeach ?>
                        <?php endif; ?>
                        
                        <hr class="double">

                        <div class="text-center m-t-20">
                            <?php if(isset($auth_call_required) && $auth_call_required): ?>
                                <a class="btn btn-success" href="<?= base_url('auth-call') ?>">
                                    احراز هویت تلفنی
                                </a>
                            <?php elseif($order->pending): ?>
                                <a class="btn btn-success" href="<?= base_url('cards') ?>">
                                    <i class="fa fa-file-text-o"></i>
                                    خرید های من
                                </a>
                            <?php endif; ?>
                            <a class="btn btn-secondary" href="<?= base_url() ?>">
                                <i class="fa fa-arrow-right"></i>
                                بازگشت به صفحه نخست
                            </a>
                        </div><!-- /.text-center -->
                    </div><!-- /.shadow -->
                </div><!-- /.col -->
            <?php endif; ?>
        </div><!-- /.row -->
    <?php endif; ?>
</div><!-- /.container -->
