<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="text-center caption">
                    <h1><i class="fa fa-question-circle-o"></i> سوالات متداول</h1>
                </div>

                <div class="row">
                    <div class="col-xl-8 col-lg-10 m-auto page-faqs">
                        <div class="px-3 py-3">
                        <?php if ($faqs): ?>
                        <div id="accordion" class="accordion-list" role="tablist" aria-multiselectable="true">
                            <?php foreach ($faqs as $key => $faq) : ?>
                                <div class="card overflow-hidden m-b-20">
                                    <div class="card-header" role="tab" id="heading<?= $key ?>">
                                        <h4 class="card-title">
                                            <a data-bs-toggle="collapse" data-bs-parent="#accordion" href="#collapse<?= $key ?>" aria-expanded="true" aria-controls="collapse<?= $key ?>">
                                                <?= $key+1 .'. ' .$faq->question ?>
                                            </a>
                                        </h4>
                                        <div class="icon">
                                            <i class="fa fa-question"></i>
                                        </div>
                                    </div>
                                    <div id="collapse<?= $key ?>" class="panel-collapse collapse <?= ($key == 0) ? 'in' : '' ?>" role="tabpanel" aria-labelledby="heading<?= $key ?>">
                                        <div class="long-text"><?= $faq->answer ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <div class="col-12">
                            <div class="section-title text-center mb-0">
                                <div class="alert alert-danger m-t-20">هنوز توسط مدیر سایت سوالی ثبت نشده است. این موضوع را می توانید از طریق صفحه تماس با ما به مدیر سایت اطلاع دهید.</div>
                            </div>
                        </div>
                    <?php endif; ?>
                        </div>
                    </div>
                </div><!-- /.row -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.main -->