<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

?>
<div class="main m-b-50 mt-md-5 mt-4 contact-page">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="text-center caption">
                    <h1>
                        <i class="fa fa-fax fa-flip-horizontal"></i>
                        تماس با سایت
                    </h1>
                </div>

                <div class="row">
                    <div class="col-lg-6 contact-form">
                        <div class="card px-4 py-4 mb-4">
                            <?php
                            if (isset($message_danger)) {
                                ?>
                                <div class="alert alert-danger curve">
                                    <?= $message_danger ?>
                                </div>
                                <?php
                            } elseif (isset($message_success)) {
                                ?>
                                <div class="alert alert-success curve">
                                    <?= $message_success ?>
                                </div>
                                <?php
                            }
                            ?>

                            <form action="<?= base_url('contact-us') ?>" method="POST">
                                <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">

                                <div class="row m-t-15">
                                    <div class="col-md-3">
                                        <label>ایمیل :</label><span class="text-danger">*</span>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="text" class="form-control ltr text-left" placeholder="ایمیل" name="email" value="<?= isset($message_send) ? '' : set_value('email') ?>">
                                    </div>
                                </div><!-- /.row -->

                                <div class="row m-t-15">
                                    <div class="col-md-3">
                                        <label>نام :</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="text" class="form-control" maxlength="100" placeholder="نام" name="name" value="<?= isset($message_send) ? '' : set_value('name') ?>">
                                    </div>
                                </div><!-- /.row -->

                                <div class="row m-t-15">
                                    <div class="col-md-3">
                                        <label>شماره همراه:</label>
                                    </div>
                                    <div class="col-md-9">
                                        <input type="text" class="form-control ltr text-left" maxlength="11" placeholder="شماره همراه" name="cell_phone" value="<?= isset($message_send) ? '' : set_value('cell_phone') ?>">
                                    </div>
                                </div><!-- /.row -->

                                <div class="row m-t-15">
                                    <div class="col-md-3">
                                        <label>بخش:</label>
                                    </div>
                                    <div class="col-md-9">
                                        <select class="form-select" name="subject">
                                            <?php $value = isset($message_send) ? '' : set_value('subject'); ?>
                                            <?php if ($subjects): ?>
                                                <?php foreach ($subjects as $subject): ?>
                                                    <option value="<?= $subject->id ?>" <?= ($value == $subject->id) ? 'selected' : '' ?>><?= $subject->title ?></option>
                                                <?php endforeach ?>
                                            <?php endif ?>
                                        </select>
                                    </div>
                                </div><!-- /.row -->

                                <div class="row m-t-15">
                                    <div class="col-md-3">
                                        <label>متن پیام:</label><span class="text-danger">*</span>
                                    </div>
                                    <div class="col-md-9">
                                        <textarea class="form-control" rows="6" name="text"><?= isset($message_send) ? '' : set_value('text') ?></textarea>
                                    </div>
                                </div><!-- /.row -->

                                <?php if (isset($captcha_image)) : ?>
                                    <div class="row m-t-15">
                                        <div class="col-md-3">
                                            <label>
                                                کد امنیتی:
                                                <a href="javascript:void(0);" class="btn-link text-dark reload-captcha" tabindex="-1"><i class="fa fa-undo"></i> </a>
                                            </label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="row">
                                                <div class="col-7 captcha-image">
                                                    <?= $captcha_image ?>
                                                </div>
                                                <div class="col-5">
                                                    <input type="number" class="form-control txt-captcha text-center ltr numeric" name="captcha" title="کد امنیتی" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <?php endif; ?>

                                <div class="row mt-3 justify-content-end">
                                    <div class="col-md-9">
                                        <button class="btn bg-gradient-primary w-100" name="submit" value="submit">
                                            ارسال پیام
                                        </button>
                                    </div><!-- /.col -->
                                </div><!-- /.row -->
                            </form>
                        </div><!-- /.card -->
                    </div><!-- /.col -->
                    <div class="col-lg-6 contact-info">
                        <div class="card px-4 py-4">
                            <h2 class="bold mb-4">
                                <i class="fa fa-phone fa-flip-horizontal"></i>
                                اطلاعات تماس
                            </h2>
                            <div class="quick-info">
                                <?php if ($settings->address) { ?>
                                    <p>
                                        <i class="fa fa-map-marker"></i>
                                        <span>
                                            نشانی  : <?= $settings->address ?>
                                        </span>
                                    </p>
                                    <?php
                                }
                                if ($settings->phone1) {
                                    ?>
                                    <p class="ltr text-left">
                                        <i class="fa fa-phone"></i>
                                        <a href="tel:<?= str_replace(' ', '', $settings->phone1) ?>"><?= $settings->phone1 ?></a>
                                    </p>
                                    <?php
                                }
                                if ($settings->phone2) {
                                    ?>
                                    <p class="ltr text-left">
                                        <i class="fa fa-phone"></i>
                                        <a href="tel:<?= str_replace(' ', '', $settings->phone2) ?>"><?= $settings->phone2 ?></a>
                                    </p>
                                    <?php
                                }
                                if ($settings->info_email) {
                                    ?>
                                    <p class="ltr text-left">
                                        <i class="fa fa-envelope"></i>
                                        <a><?= str_replace('@', '<span class="fa fa-at qwerty"></span>', $settings->info_email) ?></a>
                                    </p>
                                <?php } ?>
                            </div><!-- /.quick-info -->
                        </div><!-- /.card -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->
</div><!-- /.main -->