<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

    function drawMainMenu(array $array) {
        $html = '' . PHP_EOL;
    
        foreach ($array as $value) {
            if ($value['type'] == 'custom') {
                $url = $value['url'];
            } else {
                $url = base_url() . $value['url'];
            }
            $title = 'title';
    
            if (!empty($value['children'])) {
                $html .= '<li class="dropdown-submenu">';
                $html .= '<a  class="dropdown-item dropdown-toggle" href="' . $url . '" data-bs-toggle="dropdown" ><span class="nav-link-inner-text">' . $value[$title] . '</span><span class="fa fa-angle-down nav-link-arrow"></span></a>';
                $html .= '<ul class="dropdown-menu">';
                $html .= drawMainMenu($value['children']);
                $html .= '</ul>';
                $html .= '</li>';
            } else {
                $html .= '<li class="nav-item">';
                $html .= '<a class="dropdown-item" href="' . $url . '">' . $value[$title] . '</a>';
                $html .= '</li>';
            }
        }
    
        $html .= '' . PHP_EOL;
    
        return $html;
    }
?>

<div class="laoding-container" style="top: -100%; display: none;">
    <div class="spinner spinner-1"></div>
</div>

<header class="header-global">
    <nav id="navbar-main" class="navbar navbar-main navbar-expand-lg headroom py-1 px-lg-6 navbar-dark navbar-theme-primary">
        <div class="container-fluid">
            <a href="<?= base_url() ?>">
                <img src="<?= base_url().$settings->logo?>" class="img-logo has-tooltip" alt="<?= $settings->site_name ?>" title="صفحه نخست" data-bs-placement="bottom">
            </a>
            <button class="navbar-toggler shadow-none ms-2" id="btn-navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#top-navbar" aria-controls="top-navbar" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon mt-2">
                    <span class="navbar-toggler-bar bar1"></span>
                    <span class="navbar-toggler-bar bar2"></span>
                    <span class="navbar-toggler-bar bar3"></span>
                </span>
            </button>

            <div class="navbar-collapse collapse" id="top-navbar">
                <ul class="navbar-nav">
                    <?php if(!isset($unpublish_header)): ?>
                        <?php echo drawMainMenu($menu); ?>
                    <?php endif; ?>
                </ul>
            </div>
            
            <?php if($settings->theme->allowed_to_use == 'both'): ?>
                <div class="btn-dark-container me-auto">
                    <input type="checkbox" id="btn-dark" <?php if($theme == 'dark') echo 'checked'; ?>>
                    <label for="btn-dark" class="toggle-label">
                        <div class="toggle-container">
                            <div class="toggle-light-icon icon">
                                <svg viewBox="0 0 24 24" fill="none" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="5"></circle><line x1="12" y1="1" x2="12" y2="3"></line><line x1="12" y1="21" x2="12" y2="23"></line><line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line><line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line><line x1="1" y1="12" x2="3" y2="12"></line><line x1="21" y1="12" x2="23" y2="12"></line><line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line><line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line></svg>
                            </div>
                            <div class="toggle-dark-icon icon">
                                <svg viewBox="0 0 24 24" fill="none" stroke-linecap="round" stroke-linejoin="round"><path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z"></path></svg>
                            </div>
                            <div class="toggle-circle"></div>
                        </div>
                    </label>
                </div><!-- /.btn-dark-container -->
            <?php endif; ?>

            <?php if(!isset($unpublish_header)): ?>
                <div class="dropdown btn-user bg-gradient-primary">
                    <?php if($user_login && $number_of_message): ?>
                        <span class="unread-message"><?= $number_of_message ?></span>
                    <?php endif; ?>
                    <a href="<?= $user_login ? '#' : base_url('login') ?>" class="nav-link <?= $user_login ? 'dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false' : ''; ?>">
                        <i class="fa fa-user"></i>
                        <?php if ($user_login): ?>
                            <span>پنل کاربری <span class="fa fa-angle-down nav-link-arrow"></span></span>
                        <?php else: ?>
                            <span>
                                <span>ثبت نام/</span>
                                <span>ورود</span>
                            </span>
                        <?php endif; ?>
                    </a>
                    <?php if ($user_login): ?>
                        <ul class="dropdown-menu">
                            <?php if ($user_login): ?>
                                <li>
                                    <a class="dropdown-item" href="<?= base_url('charge') ?>">
                                        موجودی
                                        <span class="bold user-credit"><?= number_format($user_login->credit) ?></span>
                                        تومان
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= base_url('cards') ?>">
                                        <i class="fa fa-list-alt fa-alip-horizontal"></i>
                                        خریدهای من
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= base_url('charge') ?>">
                                        <i class="fa fa-bolt"></i>
                                        شارژ کیف پول
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= base_url('transactions') ?>">
                                        <i class="fa fa-credit-card"></i>
                                        تراکنش ها
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= base_url('tickets') ?>">
                                        <i class="fa fa-send"></i>
                                        تیکت(پشتیبانی)
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= base_url('edit-profile') ?>">
                                        <i class="fa fa-edit"></i>
                                        ویرایش پروفایل
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?= base_url('logout') ?>">
                                        <i class="fa fa-power-off"></i>
                                        خروج
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    <?php endif; ?>
                </div><!-- /.dropdown -->
            <?php endif ?>
        </div><!-- /.container-fluid -->
    </nav>
</header>

<?php
if(isset($sliders) && $sliders){
    $slider_margain = '';
} else {
    $slider_margain = (isset($content) && $content == 'home') ? 'mt-md-5 mt-4' : '';
}
?>
<section class="<?= $slider_margain ?>">
    <!-- BEGIN MAIN SLIDER -->
    <?php if (isset($sliders) && $sliders): ?>
        <section>
            <div class="main-carousel-box">
                <div id="owl-main" class="owl-carousel owl-theme">
                <?php foreach ($sliders as $slider): ?>
                    <div class="item">
                        <div class="img-box">
                            <?php if($slider->link): ?>
                                <a href="<?= $slider->link ?>">
                                    <img src="<?= base_url($slider->image) ?>" alt="<?= $slider->title ?>">
                                </a>
                            <?php else: ?>
                                <img src="<?= base_url($slider->image) ?>" alt="<?= $slider->title ?>">
                            <?php endif ?>

                        </div><!-- /.img-box -->
                        <?php if($slider->title): ?>
                            <div class="image-text-box">
                                <div class="texts">
                                    <h2><?= $slider->title ?></h2>
                                </div><!-- /.texts -->
                            </div><!-- /.image-text-box -->
                        <?php endif ?>
                    </div><!-- /.item -->
                <?php endforeach ?>
                </div><!-- /#owl-main -->
            </div><!-- /.main-carousel-box -->
        </section>
    <?php endif ?>
    <!-- END MAIN SLIDER -->
</section>
