<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="main m-b-50 mt-md-5 mt-4">
    <div class="profile-content">
        <div class="container">
            <div class="row">
                <div class="col-md-10 col-lg-8 m-auto">
                    <div class="text-center caption mb-3">
                        <h1>
                            <i class="fa fa-list-alt fa-alip-horizontal"></i>
                            <?= ($tracking_code) ? "خرید با کد پیگیری: $tracking_code" :  'خریدهای من' ?>
                        </h1>
                    </div>

                    <?php if ($cards) : ?>
                        <?php foreach ($cards as $item) : ?>
                            <?php
                            if($item->image && file_exists($item->image)){
                                $img = $item->image;
                            } else if($item->category_image && file_exists($item->category_image)){
                                $img = $item->category_image;
                            } else if($settings->default_category_image && file_exists($settings->default_category_image)) {
                                $img = $settings->default_category_image;
                            } else {
                                $img = 'assets/images/default-image-80x80.png';
                            }
                            ?>
                            <div class="row my-card en-numbers standard-cards">
                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-md-1 text-center">
                                            <img src="<?= base_url($img) ?>" alt="<?= $item->product_title ?>">
                                        </div><!-- /.col -->
                                        <div class="col-md-6 text-center">
                                            <span><?= $item->product_title ?></span>
                                        </div><!-- /.col -->
                                        <div class="col-md-5 text-center">
                                            <span>ش.پیگیری:</span>
                                            <span><?= $item->tracking_code ?></span>
                                        </div><!-- /.col -->
                                    </div><!-- /.row -->
                                </div><!-- /.col -->
                                <?php if($item->pending): ?>
                                    <div class="col-12 m-t-10">
                                        <div class="alert alert-info text-center">
                                            <p>اطلاعات سفارش شما به زودی بارگذاری خواهد شد.</p>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="col-md-10 m-auto">
                                        <div class="card-code-info">
                                            <div class="title">
                                                <?= $item->field1_title ?>
                                            </div>
                                            <div class="serial">
                                                <button type="button" class="btn bg-gradient-success btn-sm btn-copy" data-copy="serial1-<?=$item->id?>">
                                                    کپی
                                                    <i class="fa fa-copy"></i>
                                                </button>
                                                <span id="serial1-<?=$item->id?>"><?= $item->code ?></span>
                                            </div>
                                        </div>
                                        <?php if ($item->field2_title) : ?>
                                            <div class="card-code-info">
                                                <div class="title">
                                                    <?= $item->field2_title ?>
                                                </div>
                                                <div class="serial">
                                                    <button type="button" class="btn bg-gradient-success btn-sm btn-copy" data-copy="serial2-<?=$item->id?>">
                                                        کپی
                                                        <i class="fa fa-copy"></i>
                                                    </button>
                                                    <span id="serial2-<?=$item->id?>"><?= $item->code2 ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ($item->field3_title) : ?>
                                            <div class="card-code-info">
                                                <div class="title">
                                                    <?= $item->field3_title ?>
                                                </div>
                                                <div class="serial">
                                                    <button type="button" class="btn bg-gradient-success btn-sm btn-copy" data-copy="serial3-<?=$item->id?>">
                                                        کپی
                                                        <i class="fa fa-copy"></i>
                                                    </button>
                                                    <span id="serial3-<?=$item->id?>"><?= $item->code3 ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ($item->information): ?>
                                            <div class="card-other-information">
                                                <?= $item->information ?>                                                
                                            </div>
                                        <?php endif; ?>
                                    </div><!-- /.col -->
                                    <div class="col-12 text-center mt-4">
                                        <?php if ($item->file && file_exists($item->file)): ?>
                                            <a href="<?=base_url("cards/download/$item->id") ?>" class="btn bg-gradient-secondary">
                                                <i class="fa fa-download"></i>
                                                دانلود فایل
                                            </a>
                                        <?php endif; ?>
                                        <a href="<?= getProductSlug($item->product_slug, $item->product_id) ?>" class="btn bg-gradient-primary"><i class="fa fa-shopping-cart fa-flip-horizontal"></i> خرید دوباره</a>
                                    </div><!-- /.col -->
                                <?php endif; ?>
                            </div><!-- /.row -->
                        <?php endforeach; ?>
                        <div class="text-center">
                            <?php
                            echo $this->pagination->create_links();
                            ?>
                        </div><!-- /.text-center -->
                    <?php else : ?>
                        <div class="alert alert-info text-center">
                            <p>
                                <i class="fa fa-info-circle"></i>
                                <?= ($tracking_code) ? 'کاربر گرامی خرید با این کد پیگیری یافت نشد!' : 'کاربر گرامی شما هنوز خریدی انجام نداده اید.'; ?>
                                
                            </p>
                        </div><!-- /.alert -->
                    <?php endif; ?>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </div><!-- /.profile-content -->
</div><!-- /.main -->