<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">                                        
                    <i class="<?= $transaction->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $transaction->id == 0 ? 'تراکنش جدید' : 'ویرایش تراکنش' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <form id="form-data" role="form" method="POST">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name() ?>" value="<?= $this->security->get_csrf_hash() ?>">
                        <input type="hidden" value="<?= $transaction->id ?>" name="id"/>
                        <input type="hidden" value="<?= $user->id ?>" name="user_id"/>
                        <div class="form-body">
                            <div class="row">                                
                                <div class="col-md-4">                                
                                    <div class="form-group">
                                        <label>شماره همراه</label>
                                        <input type="text" class="form-control ltr text-left" value="<?= $user->cell_phone ?>" disabled>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-md-4">                                
                                    <div class="form-group">
                                        <label>نام و نام خانوادگی</label>
                                        <input type="text" class="form-control" value="<?= html_escape("{$user->first_name} {$user->last_name}") ?>" disabled>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-md-4">                                
                                    <div class="form-group">
                                        <label>موجودی فعلی(تومان)</label>
                                        <input type="text" class="form-control ltr text-left" value="<?=  number_format($credit) ?>" disabled>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>افزایش / کاهش</label>
                                        <select class="form-control" name="action" <?= ($transaction->id) ? 'disabled' : '' ?>>
                                            <option value="increase" <?= ($transaction->id && $transaction->amount > 0) ? 'selected' : ''; ?>>افزایش</option>
                                            <option value="decrease" <?= ($transaction->id && $transaction->amount < 0) ? 'selected' : ''; ?>>کاهش</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>مبلغ(تومان)</label>
                                        <input type="text" class="form-control ltr text-left numeric separate" name="amount" value="<?=  ($transaction->amount) ? number_format(abs($transaction->amount)) : '' ?>" <?= ($transaction->id) ? 'disabled' : '' ?>>
                                    </div>
                                </div><!-- /.col -->
                                <?php if($transaction->gateway == 'card2card'): ?>
                                    <div class="col-md-12">
                                        <div class="portlet box border shadow">
                                            <div class="portlet-body">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <p>
                                                            <span>وضعیت تراکنش:</span>
                                                            <?php if($transaction->completed): ?>
                                                                <span class="label label-success">تایید شده</span>
                                                            <?php elseif($transaction->reject) : ?>
                                                                <span class="label label-danger">رد شده</span>
                                                            <?php else: ?>
                                                                <span class="label label-warning">در انتظار تایید</span>
                                                            <?php endif; ?>
                                                        </p>
                                                    </div><!-- /.col -->
                                                    <div class="col-md-6">
                                                        <div>اطلاعات وارد شده <b>توسط کاربر</b>:</div>
                                                        <div>تاریخ کارت به کارت: <b><?= $this->pdate->date('Y/m/d H:i', strtotime($transaction->detail->transfer_date)) ?></b></div>
                                                        <div>شماره کارت واریز کننده: <b class="inline-block"><?= wordwrap($transaction->detail->customer_card , 4 , '-' , true) ?></b></div>
                                                        <div>شماره پیگیری تراکنش: <b><?= $transaction->reference ?></b></div>
                                                        <div>توضیحات: <?= html_escape($transaction->detail->description) ?></div>
                                                        <?php if(!$transaction->completed && !$transaction->reject): ?>
                                                            <?php if($transaction->order_id): ?>
                                                                <div class="alert alert-warning fill curve text-inverse">
                                                                    <p>این تراکنش برای سفارش ثبت شده است، بنابر‌این برای تایید یا رد آن لطفا از لینک زیر اقدام کنید.</p>
                                                                </div>
                                                                <div class="text-center">
                                                                    <a href="<?= base_url("admin/orders/detail/$transaction->order_id") ?>" class="btn btn-info btn-round">تایید یا رد تراکنش</a>
                                                                </div>
                                                            <?php else: ?>
                                                                <hr>
                                                                <div class="text-center">
                                                                    <div class="form-group">
                                                                        <label>
                                                                            <input type="checkbox" name="send_sms" value="1">
                                                                            برای کاربر پیامک ارسال شود.
                                                                        </label>
                                                                    </div><!--/.form-group-->
                                                                    <a href="javascript:void(0);" class="btn btn-success btn-round btn-change-status" data-value="accept"><i class="icon-check"></i> تایید تراکنش</a>
                                                                    <a href="javascript:void(0);" class="btn btn-danger btn-round btn-change-status" data-value="reject"><i class="icon-close"></i> رد تراکنش</a>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div><!-- /.col -->
                                                    <div class="col-md-6">
                                                        <?php if($transaction->detail->image && file_exists($transaction->detail->image)): ?>
                                                            <img src="<?= base_url($transaction->detail->image) ?>" class="img-responsive" />
                                                        <?php else: ?>
                                                            <img src="<?= base_url('assets/images/default-image-480x360.png') ?>" class="img-responsive thumbnail" style="opacity: 0.4;"/>
                                                        <?php endif; ?>
                                                    </div><!-- /.col -->
                                                </div><!-- /.row -->
                                            </div>
                                        </div>
                                    </div><!-- /.col -->
                                <?php endif; ?>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>توضیحات</label>
                                        <textarea class="form-control" name="description" rows="5"><?= $transaction->description ?></textarea>
                                    </div>
                                </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a class="btn btn-info btn-round btn-save" onclick="insert('<?= base_url('admin/transactions/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert');">
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= ($transaction->id) ?  base_url('admin/transactions') : base_url('admin/customers')  ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
<?php 
if(
    $transaction->gateway == 'card2card' && 
    !$transaction->order_id &&
    !$transaction->completed &&
    !$transaction->reject
):
?>
    <script>
        $(document).ready(function () {
            $(".btn-change-status").on("click", function() {
                let status = $(this).attr("data-value");

                if(status == 'accept'){
                    text = "آیا اطمینان دارید که اطلاعات کارت به کارت را <b>تایید</b> می کنید.";
                    btnTitle = "بله، تایید می کنم";
                } else {
                    text = "آیا اطمینان دارید که اطلاعات کارت به کارت را <b>رد</b> می کنید.";
                    btnTitle = "بله، رد می کنم";
                }
                var target = $(this).closest(".box-image");
                swal({
                    title: "این عملیات برگشت پذیر نیست!",
                    html: text,
                    type: "error",
                    showCancelButton: true,
                    confirmButtonColor: "#f44336",
                    confirmButtonText: btnTitle,
                    cancelButtonText: "انصراف",
                    cancelButtonColor: '#55b559',
                    closeOnConfirm: false,
                    closeOnCancel: true //false
                }).then(function() {
                    //confirm
                    insert('<?= base_url('admin/transactions/changeStatus/'); ?>' + status, '#form-data', '', '', '#msg', false, true, 'sweetalert');

                }, function(dismiss) {
                    //cancel
                });
                
            });
        });
    </script>
<?php endif; ?>