<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
$user_id = ($user) ? $user->id : 0;
?>
<style>
    .ticket-in-table{
        display: inline-block;
        max-width: 200px;
        vertical-align: middle;
    }

    /* Hide admin unread */
    #admin-ticket-table tr td:nth-child(8),
    #admin-ticket-table tr th:nth-child(8){
        display:none;
    }

    /* Hide full name */
    #admin-ticket-table tr td:nth-child(4),
    #admin-ticket-table tr th:nth-child(4){
        display:none;
    }

    #admin-ticket-table tfoot{
        display:none;
    }

    #admin-ticket-table tr th{
        text-align: center;
    }
</style>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-cursor"></i>
                    تیکت ها
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row m-b-10">
                <div class="col col-md-12">
                    <?php if($user): ?>
                        <div>
                            <span>تیکت های:</span>
                            <strong>(<?= html_escape($user->full_name) ?> <?= $user->cell_phone ?>)</strong>
                        </div>
                    <?php endif; ?>
                    <?php if (in_array('ticket_categories', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/categories/index/ticket') ?>" class="btn btn-primary btn-round" >
                            <i class="icon-organization"></i>
                            موضوعات
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('tickets_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/tickets/edit') ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('tickets_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/tickets/changeStatus/open') ?>', '#frm-main', '<?= base_url('admin/tickets/view/'.$user_id) ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="باز کردن تیکت">
                            <i class="icon-lock-open"></i>
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?= base_url('admin/tickets/changeStatus/close') ?>', '#frm-main', '<?= base_url('admin/tickets/view/'.$user_id) ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="بستن تیکت">
                            <i class="icon-lock"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('tickets_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);" onclick="deleteRow('<?php echo base_url('admin/tickets/delete'); ?>', '#frm-main', '<?= base_url('admin/tickets/view/'.$user_id) ?>', '#res', 'deleteMulti', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>
                        </a>
                    <?php endif; ?>
                </div><!-- col -->
            </div><!-- row -->
            <div class="row">
                <div class="form-body form-filter">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>شماره همراه</label>
                            <input class="form-control ltr text-left numeric" maxLength="11" data-target="username">
                        </div><!-- /.form-group -->
                    </div><!-- /.col -->
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>بخش</label>
                            <select class="form-control" data-target="category">
                                <option value="">همه</option>
                                <?php if($categories): ?>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?= $category->id ?>"><?= $category->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif ?>
                            </select>
                        </div><!-- /.form-group -->
                    </div><!-- /.col -->
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>فوریت</label>
                            <select class="form-control" data-target="priority">
                                <option value="">همه</option>
                                <option value="low"><?= translatePriority('low') ?></option>
                                <option value="normal"><?= translatePriority('normal') ?></option>
                                <option value="high"><?= translatePriority('high') ?></option>
                            </select>
                        </div><!-- /.form-group -->
                    </div><!-- /.col -->
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>وضعیت</label>
                            <select class="form-control" data-target="status">
                                <option value="">همه</option>
                                <option value="pending">در انتظار</option>
                                <option value="done">پاسخ داده شده</option>
                                <option value="close">بسته شده</option>
                            </select>
                        </div><!-- /.form-group -->
                    </div><!-- /.col -->
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>وضعیت مشاهده </label>
                            <select class="form-control" data-target="unread-admin">
                                <option value="">همه</option>
                                <option value="1">مشاهده شده ها</option>
                                <option value="0">مشاهده نشده ها</option>
                            </select>
                        </div><!-- /.form-group -->
                    </div><!-- /.col -->
                </div><!-- /.form-body -->
            </div><!-- /.row -->
            <div>
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids" />
                </form>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped text-center" id="admin-ticket-table">
                    <tfoot class="top-search">
                        <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th class="searchable username"></th>
                            <th class="searchable category"></th>
                            <th class="searchable priority"></th>
                            <th class="searchable unread-admin"></th>
                            <th class="searchable status"></th>
                            <th></th>
                            <th></th>
                        </tr>
                    </tfoot>
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th>عنوان</th>
                            <th>نام کاربر</th>
                            <th>شماره همراه</th>
                            <th>بخش</th>
                            <th>فوریت</th>
                            <th>وضعیت مشاهده مدیر سایت</th>
                            <th>وضعیت</th>
                            <th>آخرین پیام کاربر</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->

        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->


<script>
    $(document).ready(function() {
        var selectedMain = [];
        var tableMain = $('#admin-ticket-table').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            // "stateSave": true,
            "pageLength": 25,
            "ajax": {
                "url": "<?php echo base_url("admin/tickets/ajax_list/$user_id") ?>",
                "type": "POST",
                data: function(d) {
                    d.<?= $this->security->get_csrf_token_name() ?> = $("input[name='" + csrfTokenName + "']").val();
                },
                dataSrc: function(json) {
                    if (json.csrf !== undefined)
                        $("input[name='" + csrfTokenName + "']").val(json.csrf);
                    return json.data;
                },
                "complete": function(settings, json) {
                    $(".has-tooltip").tooltip();
                    window.Modiran.initiCkeck();
                    chackAllStatus($('#admin-ticket-table'));
                }
            },
            "sPaginationType": "full_numbers",
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false, "class": "width-10 p-10"},
                {"data": "title", "class": "text-right"},
                {"data": "full_name"},
                {"data": "username"},
                {"data": "category_title", "orderable": false, "class": "p-10"},
                {"data": "priority", "orderable": false, "class": "p-10"},
                {"data": "unread_admin", "orderable": false},
                {"data": "status", "orderable": false, "class": "p-10 nowrap"},
                {"data": "updated"},
                {"data": "actions", "orderable": false, "class": "p-10 nowrap"}
            ],
            "order": []
        });

        // Select checkboxes
        $('#admin-ticket-table tbody').on('ifChanged', 'input', function(event) {

            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);
            chackAllStatus($('#admin-ticket-table'));
        });

        

        $(window).on('resize', function() {
            $('#admin-ticket-table').css("width", "100%");
        });

        // Add Search input, select
        $('#admin-ticket-table tfoot th.searchable').each(function() {
            var title = $("#admin-ticket-table thead th").eq($(this).index()).text();
            $(this).html('<input type="text" placeholder="' + title + '"  style="width: 10px;">');
        });
        

        // Apply the search
        tableMain.columns().eq(0).each(function(colIdx) {
            $(':input', tableMain.column(colIdx).footer()).on('keyup change', function() {
                tableMain
                    .column(colIdx)
                    .search(this.value)
                    .draw();
            });
        });

        // Restore state
        var state = tableMain.state.loaded();
        if (state) {
            tableMain.columns().eq(0).each(function(colIdx) {
                var colSearch = state.columns[colIdx].search;
                if (colSearch.search) {
                    $(':input', tableMain.column(colIdx).footer()).val(colSearch.search);
                }
            });
        }

        $(".form-filter").on('change keyup', ':input', function() {
            let target = $(this).attr("data-target");
            let value = $(this).val();
            $('#admin-ticket-table tfoot th.'+target).find(':input').val(value).change();
        });
    });
</script>