<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$ticket->id = intval($ticket->id);
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="<?= $ticket->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $ticket->id == 0 ? 'تیکت جدید' : 'ویرایش تیکت' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <form id="form-data" role="form" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                <input type="hidden" name="id" value="<?= $ticket->id ?>">
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>
                                    شماره همراه کاربر
                                    <?php if ($ticket->id == 0) : ?>
                                        <span class="text-danger">*</span>
                                    <?php endif; ?>
                                </label>
                                <input type="text" class="form-control numeric ltr text-left" maxlength="11" name="cell_phone" value="<?= $ticket->cell_phone ?>" <?php if ($ticket->id) echo 'disabled'; ?>>
                            </div><!-- /.form-group -->
                        </div><!-- /.col -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>عنوان <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="title" value="<?= html_escape($ticket->title) ?>">
                            </div>
                        </div><!-- /.col -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>بخش <span class="text-danger">*</span></label>
                                <select class="form-control" name="category_id">
                                    <?php if ($categories) : ?>
                                        <?php foreach ($categories as $item) : ?>
                                            <option value="<?= $item->id ?>" <?php if ($item->id == $ticket->category_id) echo 'selected'; ?>><?= $item->title ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div><!-- /.col -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>فوریت <span class="text-danger">*</span></label>
                                <select class="form-control" name="priority">
                                    <option value="low" <?php if ($ticket->priority == 'low') echo 'selected'; ?>><?= translatePriority('low') ?></option>
                                    <option value="normal" <?php if ($ticket->priority == 'normal') echo 'selected'; ?>><?= translatePriority('normal') ?></option>
                                    <option value="high" <?php if ($ticket->priority == 'high') echo 'selected'; ?>><?= translatePriority('high') ?></option>
                                </select>
                            </div>
                        </div><!-- /.col -->
                        <div class="col-md-12">
                            <?php if ($ticket->id == 0) : ?>
                                <div class="form-group">
                                    <label>متن پیام <span class="text-danger">*</span></label>
                                    <textarea class="form-control" rows="6" name="text"></textarea>
                                </div>
                            <?php endif; ?>
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.form-body -->
                <hr>
                <div class="form-actions">
                    <a href="javascript: void(0)" class="btn btn-info btn-round" onclick="insert('<?= base_url("admin/tickets/save") ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')">
                        <i class="icon-check"></i>
                        ذخیره
                    </a>
                    <a href="<?= base_url("admin/tickets/index") ?>" class="btn btn-warning btn-round pull-left">
                        <i class="icon-close"></i>
                        بازگشت
                    </a>
                </div><!-- /.form-actions -->
            </form>
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->