<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<?php

//social network
function print_social_network($index, $all_social_networks, $social_network = null) {
    ?>
    <div class="row margin-t-20">
        <div class="col-md-4">
            <div class="form-group">
                <label>شبکه اجتماعی</label>
                <select name="social_network[<?= $index ?>]" class="form-control">
                    <option value="">انتخاب کنید</option>
                    <?php
                    foreach ($all_social_networks as $key => $value) {
                        $selected = '';
                        if ($social_network != null) {
                            if ($social_network->social_network == $key) {
                                $selected = 'selected';
                            }
                        }
                        ?>
                        <option value="<?= $key ?>" <?= $selected ?>><?= $value['title'] ?></option>
                        <?php
                    }
                    ?>
                </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label>عنوان</label>
                <?php
                $value = '';
                if ($social_network != null && isset($social_network->title)) {
                    $value = $social_network->title;
                }
                ?>
                <input name="title[<?= $index ?>]" type="text"  class="form-control" value="<?= $value ?>"/>

            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label>لینک</label>
                <?php
                $value = '';
                if ($social_network != null) {
                    $value = $social_network->url;
                }
                ?>
                <input name="url[<?= $index ?>]" type="text" dir="ltr" class="form-control" value="<?= $value ?>"/>

            </div>
        </div>
    </div>
    <?php
}
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-settings"></i>
                    تنظیمات
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <?php if ($this->session->flashdata('success') != false): ?>
                <div class="alert alert-success">
                    <?= $this->session->flashdata('success') ?>
                </div>
            <?php endif; ?>
            <ul class="nav nav-tabs border">
                <li class="<?= ($active_tab == 'general') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#general-tab">تنظیمات عمومی</a>
                </li>
                <li class="<?= ($active_tab == 'ui') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#ui-tab">قالب</a>
                </li>
                <li class="<?= ($active_tab == 'images') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#images-tab">عکس ها</a>
                </li>
                <li class="<?= ($active_tab == 'offline') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#offline-tab">حالت آفلاین</a>
                </li>
                <li class="<?= ($active_tab == 'contact') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#contacts-tab">تماس و تیکت</a>
                </li>
                <li class="<?= ($active_tab == 'pay') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#pay-tab">پرداخت </a>
                </li>
                <li class="<?= ($active_tab == 'sms') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#sms-tab">پیامک </a>
                </li>
                <li class="<?= ($active_tab == 'email') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#email-tab">ایمیل</a>
                </li>
                <li class="<?= ($active_tab == 'social') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#social-networks">شبکه های اجتماعی</a>
                </li>
                <li class="<?= ($active_tab == 'detail') ? 'active' : '' ?>">
                    <a data-toggle="tab" href="#detail-tab">سایر تنظیمات</a>
                </li>
            </ul>
            <div class="tab-content m-t-10">
                <div id="general-tab" class="tab-pane fade <?= ($active_tab == 'general') ? 'active in' : '' ?>">
                    <form method="post" id="form-general">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نام سایت</label>
                                    <input class="form-control" name="site_name" value="<?= $settings->site_name ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نام انگلیسی سایت (برای ارسال ایمیل استفاده می شود)</label>
                                    <input class="form-control ltr text-left" name="site_name_en" value="<?= $settings->site_name_en ?>">
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <div class="form-group">
                            <label>مسیر ادمین(اگر می خواهید پیش فرض همان admin باشد چیزی وارد نکنید و فقط از حروف انگلیسی و اعداد استفاده کنید)</label>
                            <div class="input-group curve" >
                                <input type="text" class="form-control ltr text-left iransans-en" name="admin_key" value="<?= $settings->admin_key ?>" id="txt-admin-key" placeholder="">
                                <span class="input-group-addon ltr">
                                    <span class="hidden-xs"><?=base_url()?></span><span id="fix-admin-link"><?= ($settings->admin_key) ? 'admin-' : 'admin' ?></span>
                                </span>
                                <span class="input-group-btn">
                                    <button id="btn-copy-admin-link" class="btn btn-primary" style="height:38px" type="button" ><i class="icon-docs"></i></button>
                                </span>
                            </div><!-- /.input-group -->
                        </div>
                        <div class="form-group">
                            <label>متای عنوان(حدود65 حرف)</label>
                            <input class="form-control" name="meta_title" value="<?= $settings->meta_title ?>">
                        </div>

                        <div class="form-group">
                            <label>متای توضیحات(حدود 155 حرف)</label>
                            <textarea class="form-control" name="meta_description" rows="4"><?= $settings->meta_description ?></textarea>
                        </div>

                        <div class="form-group">
                            <label>متای کلمات کلیدی(کلمات را با , از هم جدا کنید)</label>
                            <textarea class="form-control" name="meta_keywords" rows="4"><?= $settings->meta_keywords ?></textarea>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>هدیه ثبت نام(تومان)</label>
                                    <input class="form-control ltr text-left numeric separate"  name="signup_gift" value="<?= ($settings->signup_gift) ? number_format($settings->signup_gift) : '' ?>">
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>زمان خرید باکس کوپن نمایش داده شود؟</label>
                                    <select class="form-control" name="show_coupon_box">
                                        <option value="1" <?php if ($settings->show_coupon_box) echo 'selected' ?>>بله</option>
                                        <option value="0" <?php if (!$settings->show_coupon_box) echo 'selected' ?>>خیر</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>وضعیت نمایش باکس کارت هدیه</label>
                                    <select class="form-control" name="show_gift_box">
                                        <option value="" <?php if ($settings->show_gift_box == '') echo 'selected' ?>>کارت هدیه غیر فعال باشد و باکس آن نمایش داده نشود</option>
                                        <option value="buy" <?php if ($settings->show_gift_box == 'buy') echo 'selected' ?>>فقط در صفحه خرید نمایش داده شود</option>
                                        <option value="charge" <?php if ($settings->show_gift_box == 'charge') echo 'selected' ?>>فقط در صفحه شارژ کیف پول نمایش داده شود</option>
                                        <option value="both" <?php if ($settings->show_gift_box == 'both') echo 'selected' ?>>در هر دو صفحه خرید و شارژ کیف نمایش داده شود</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>بعد از خرید توسط کاربران، فاکتور برای مدیر هم ایمیل شود؟</label>
                                    <select class="form-control" name="send_admin_invoice">
                                        <option value="1" <?php if ($settings->send_admin_invoice) echo 'selected' ?>>بله</option>
                                        <option value="0" <?php if (!$settings->send_admin_invoice) echo 'selected' ?>>خیر</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <hr>
                        <div class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>نرخ دلار</label>
                                    <input class="form-control ltr text-left numeric separate"  name="dollar_rate" value="<?= number_format($settings->rate->dollar) ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>نرخ درهم</label>
                                    <input class="form-control ltr text-left numeric separate"  name="dirham_rate" value="<?= number_format($settings->rate->dirham) ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>نرخ یورو</label>
                                    <input class="form-control ltr text-left numeric separate"  name="euro_rate" value="<?= number_format($settings->rate->euro) ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>نرخ پوند</label>
                                    <input class="form-control ltr text-left numeric separate"  name="pound_rate" value="<?= number_format($settings->rate->pound) ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>نرخ لیر</label>
                                    <input class="form-control ltr text-left numeric separate"  name="lira_rate" value="<?= number_format($settings->rate->lira) ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>بعد از تبدیل ارز به تومان چقدر گرد شود؟</label>
                                    <select class="form-control"  name="round_price">
                                        <option value="down-1" <?php if($settings->round_price == 'down-1') echo 'selected'; ?>>بدون تغییر</option>
                                        <option value="up-10" <?php if($settings->round_price == 'up-10') echo 'selected'; ?>>به بالا با یک صفر 0 (مثال: 395,789 می شود 395,790)</option>
                                        <option value="up-100" <?php if($settings->round_price == 'up-100') echo 'selected'; ?>>به بالا با دو صفر 00 (مثال: 395,789 می شود 395,800)</option>
                                        <option value="up-1000" <?php if($settings->round_price == 'up-1000') echo 'selected'; ?>>به بالا با سه صفر 000 (مثال: 395,789 می شود 396,000)</option>
                                        <option value="up-10000" <?php if($settings->round_price == 'up-10000') echo 'selected'; ?>>به بالا با چهار صفر 0000 (مثال: 395,789 می شود 400,000)</option>
                                        <option value="down-10" <?php if($settings->round_price == 'down-10') echo 'selected'; ?>>به پایین با یک صفر 0 (مثال: 395,789 می شود 395,780)</option>
                                        <option value="down-100" <?php if($settings->round_price == 'down-100') echo 'selected'; ?>>به پایین با دو صفر 00 (مثال: 395,789 می شود 395,700)</option>
                                        <option value="down-1000" <?php if($settings->round_price == 'down-1000') echo 'selected'; ?>>به پایین با سه صفر 000 (مثال: 395,789 می شود 395,000)</option>
                                        <option value="down-10000" <?php if($settings->round_price == 'down-10000') echo 'selected'; ?>>به پایین با چهار صفر 0000 (مثال: 395,789 می شود 390,000)</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->

                        <?php $settings->smart_block = isset($settings->smart_block) ? json_decode($settings->smart_block) : null; ?>
                        <?php if($settings->smart_block): ?>
                            <hr>
                            <div class="form-group">
                                <label>
                                    <input type="checkbox" name="smart_block[active]" value="1" <?= $settings->smart_block->active ? 'checked' : '' ?>>
                                    بلاک هوشمند فعال باشد
                                </label>
                            </div><!-- /.form-group -->
                            <div class="form-group">
                                <label>دامین‌های غیر مجاز برای بلاک هوشمند (با کاما جدا کنید)</label>
                                <textarea class="form-control ltr text-left" name="smart_block[blacklist_domains]" rows="5"><?= implode(', ', $settings->smart_block->blacklist_domains) ?></textarea>
                            </div>
                        <?php endif ?>

                        <hr>
                        <div class="form-group">
                            <label>متن زیر دسته‌بندی‌ها در صفحه اصلی</label>
                            <textarea name="site_description" class="hide" id="content-site-description"><?= $settings->site_description ?></textarea>
                            <div id="editor-site-description"></div>
                        </div>

                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round btn-save">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="ui-tab" class="tab-pane fade <?= ($active_tab == 'ui') ? 'active in' : '' ?>">
                    <form method="post" id="form-ui">
                        <?php
                        $settings->theme = json_decode($settings->theme);
                        $settings->theme->color = (isset($settings->theme->color)) ? $settings->theme->color : 'bluegreen';
                        $settings->theme->bg_color = (isset($settings->theme->bg_color)) ? $settings->theme->bg_color : 'darkblue';
                        $settings->product_ui = json_decode($settings->product_ui);
                        ?>
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-warning text-center">
                                    <p>برای آموزش کاربرد عکس کوچک و عکس بزرگ برای دسته و محصول بر روی دکمه زیر کلیک کنید.<p>
                                    <a class="btn btn-default btn-warning btn-round" data-toggle="modal" data-target="#modal-education-ui">مشاهده آموزش</a>    
                                </div>
                            </div><!-- /.col -->
                        
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>انتخاب تم قالب</label>
                                    <select class="form-control" name="theme[allowed_to_use]">
                                        <option value="dark" <?php if($settings->theme->allowed_to_use == 'dark') echo 'selected'; ?>>فقط تیره</option>
                                        <option value="light" <?php if($settings->theme->allowed_to_use == 'light') echo 'selected'; ?>>فقط روشن</option>
                                        <option value="both" <?php if($settings->theme->allowed_to_use == 'both') echo 'selected'; ?>>هم تیره و هم روشن(به انتخاب کاربر)</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>تم پیش فرض</label>
                                    <select class="form-control" name="theme[default]" <?php if($settings->theme->allowed_to_use != 'both') echo 'disabled'; ?>>
                                        <option value="dark" <?php if($settings->theme->default == 'dark') echo 'selected'; ?>>تیره</option>
                                        <option value="light" <?php if($settings->theme->default == 'light') echo 'selected'; ?>>روشن</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->

                            <div class="col-md-12 admin-colors">
                                <input type="hidden" name="theme[color]" value="<?= $settings->theme->color ?>">
                                <input type="hidden" name="theme[bg_color]" value="<?= $settings->theme->bg_color ?>">
                                <p class=""><b>رنگ قالب:</b></p>
                                <div class="setting-theme-colors">
                                    <?php foreach($theme_colors as $color): ?>
                                        <a class="btn btn-curve btn-<?= $color ?> <?= ($color == $settings->theme->color) ? 'active' : ''; ?>" data-color="<?= $color ?>"></a>
                                    <?php endforeach; ?>
                                </div><!-- /.setting-theme-colors -->

                                <p class="m-t-20"><b>رنگ زمینه</b>(فقط در حالت تیره تاثیر دارد): </p>
                                <div class="setting-theme-bg-colors">
                                    <?php
                                        $related_bg_colors = $theme_colors_arr[$settings->theme->color];
                                    ?>
                                    <?php foreach($theme_bg_colors as $bg_color => $name): ?>
                                        <div class="box-<?= $bg_color ?> <?= in_array(str_replace('dark', '', $bg_color), $related_bg_colors) ? '' : 'hide'; ?>">
                                            <a class="btn btn-curve btn-<?= $bg_color ?>  <?= ($bg_color == $settings->theme->bg_color) ? 'active' : ''; ?>" data-color="<?= $bg_color ?>"></a>
                                            <span><?= $name ?></span>
                                        </div>
                                    <?php endforeach; ?>
                                </div><!-- /.setting-theme-bg-colors -->
                            </div><!-- /.col -->

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نحوه نمایش دسته یا محصول در <b>دسکتاپ</b></label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="product_ui[vertical_layout]" id="desktop-horizontal-layout" value="false" <?php if($settings->product_ui->vertical_layout == false) echo 'checked'; ?>>
                                        <label class="form-check-label" for="desktop-horizontal-layout">
                                            <img src="<?= base_url("assets/admin/images/product_ui/small-image-gray.svg"); ?>" width="50px">
                                            چیدمان با عکس کوچک
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="product_ui[vertical_layout]" id="desktop-vertical-layout" value="true" <?php if($settings->product_ui->vertical_layout == true) echo 'checked'; ?>>
                                        <label class="form-check-label" for="desktop-vertical-layout">
                                            <img src="<?= base_url("assets/admin/images/product_ui/large-image-gray.svg"); ?>" width="50px">
                                            چیدمان با عکس بزرگ
                                        </label>
                                    </div>
                                </div>
                            </div><!-- /.col -->

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نحوه نمایش دسته یا محصول در <b>موبایل</b></label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="product_ui[mobile_vertical_layout]" id="mobile-horizontal-layout" value="false" <?php if($settings->product_ui->mobile_vertical_layout == false) echo 'checked'; ?>>
                                        <label class="form-check-label" for="mobile-horizontal-layout">
                                            <img src="<?= base_url("assets/admin/images/product_ui/small-image-gray.svg"); ?>" width="50px">
                                            چیدمان با عکس کوچک
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="product_ui[mobile_vertical_layout]" id="mobile-vertical-layout" value="true" <?php if($settings->product_ui->mobile_vertical_layout == true) echo 'checked'; ?>>
                                        <label class="form-check-label" for="mobile-vertical-layout">
                                            <img src="<?= base_url("assets/admin/images/product_ui/large-image-gray.svg"); ?>" width="50px">
                                            چیدمان با عکس بزرگ
                                        </label>
                                    </div>
                                </div>
                            </div><!-- /.col -->

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>تعداد دسته بندی ها یا محصولات در هر ردیف در حالت <b>دسکتاپ</b></label>
                                    <select class="form-control" name="product_ui[count_per_row]" <?= ($settings->product_ui->count_per_row == 6) ? 'readonly' : '' ?>>
                                        <?php if($settings->product_ui->count_per_row == 6): ?>
                                            <option value="6" selected>6 تا در هر ردیف</option>
                                        <?php else: ?>
                                            <option value="2" <?php if($settings->product_ui->count_per_row == 2) echo 'selected'; ?>>2 تا در هر ردیف</option>
                                            <option value="3" <?php if($settings->product_ui->count_per_row == 3) echo 'selected'; ?>>3 تا در هر ردیف</option>
                                            <option value="4" <?php if($settings->product_ui->count_per_row == 4) echo 'selected'; ?>>4 تا در هر ردیف</option>
                                        <?php endif ?>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->

                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/saveUI/"); ?>', '#form-ui', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="images-tab" class="tab-pane fade <?= ($active_tab == 'images') ? 'active in' : '' ?>">
                    <form method="post" id="form-images">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <?php
                            $images = array(
                                array('key' => 'favicon', 'title' => 'favicon <small>ترجیحا 32x32 , png پیکسل</small>', 'width' => 50),
                                array('key' => 'logo', 'title' => 'لوگوی سایت <small>ترجیحا 60x60 , png پیکسل</small>', 'width' => 60),
                                array('key' => 'default_category_image', 'title' => 'تصویر پیش فرض دسته برای عکس کوچک <small>80x80 پیکسل</small> <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-ui"><i class="fa fa-question"></i></a>', 'width' => 80),
                                array('key' => 'default_category_large_image', 'title' => 'تصویر پیش فرض دسته برای عکس بزرگ <small>480x360 پیکسل</small> <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-ui"><i class="fa fa-question"></i></a>', 'width' => 100),
                                array('key' => 'login_image', 'title' => 'تصویر صفحه لاگین <small>600x600 پیکسل</small>', 'width' => 100),
                                array('key' => 'identity_inquiry_image', 'title' => 'تصویر صفحه تایید کد ملی و تاریخ تولد <small>600x600 پیکسل</small>', 'width' => 100),
                                array('key' => '404_image', 'title' => 'تصویر صفحه 404 <small>ترجیحا 330x330 , png پیکسل</small>', 'width' => 100),
                                array('key' => 'offline_image', 'title' => 'تصویر حالت آفلاین', 'width' => 150),
                                array('key' => 'profile_image', 'title' => 'تصویر پیش فرض پروفایل کاربر <small>128x128 پیکسل</small>', 'width' => 100),
                            );
                            foreach ($images as $index => $item) {
                                $key = $item['key'];
                                ?>
                                <div class="col-md-6">
                                    <div class="form-group box-image border curve p-20" style="min-height: 178px;">
                                        <label><?= $item['title'] ?></label>
                                        <?php
                                        $class_hide = '';
                                        if ($settings->$key != '' && file_exists($settings->$key)) {
                                            $image = base_url($settings->$key);
                                            $class_hide = 'hide';
                                            ?>
                                            <div class="box-old-image">
                                                <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/settings/removeImage?path="). $settings->$key; ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                                <img class="img-responsive img-thumbnail" width="<?= $item['width'] ?>" src="<?= $image ?>">
                                            </div>
                                            <?php
                                        }
                                        ?>
                                        <div class="box-new-image <?= $class_hide ?>">
                                            <input type="file" class="form-control ltr" name="<?=$key?>">
                                        </div>
                                    </div><!-- /.form-group -->
                                </div><!-- /.col -->
                                <?php if($index > 0 && ($index + 1) % 2 == 0): ?>
                                    <div class="clearfix"></div>
                                <?php endif; ?>
                                <?php
                            }
                            ?>
                        </div><!-- /.row -->
                    </form>
                    <div class="form-actions m-t-20">
                        <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/saveImages/"); ?>', '#form-images', '', '', '#msg', false, true, 'sweetalert')">
                            <i class="icon-check"></i>
                            ذخیره تنظیمات قسمت
                        </a>
                        <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                            <i class="icon-close"></i>
                            بازگشت
                        </a>
                    </div><!-- /.form-actions -->
                </div><!-- /.tab-pane -->

                <div id="offline-tab" class="tab-pane fade <?= ($active_tab == 'offline') ? 'active in' : '' ?>">
                    <form method="post" id="form-offline">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>حالت سایت</label>
                                    <select class="form-control" name="offline">
                                        <option value="0" <?php if (!$settings->offline) echo 'selected' ?>>قابل مشاهده</option>
                                        <option value="1" <?php if ($settings->offline) echo 'selected' ?>>غیرقابل مشاهده و آفلاین</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>متن حالت آفلاین</label>
                                    <textarea class="form-control" name="offline_text" rows="5"><?= $settings->offline_text ?></textarea>
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->

                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/saveOffline/"); ?>', '#form-offline', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="contacts-tab" class="tab-pane fade <?= ($active_tab == 'contact') ? 'active in' : '' ?>">
                    <?php $settings->ticket = json_decode($settings->ticket); ?>
                    <form method="post" id="form-contacts">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نشانی</label>
                                    <input class="form-control" name="address" value="<?= $settings->address ?>">
                                </div>
                            </div><!-- /.col -->

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>تلفن اول</label>
                                    <input class="form-control ltr" name="phone1" value="<?= $settings->phone1 ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>تلفن دوم</label>
                                    <input class="form-control ltr" name="phone2" value="<?= $settings->phone2 ?>">
                                </div>
                            </div><!-- /.col -->

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>ایمیل سایت</label>
                                    <input class="form-control ltr" name="info_email" value="<?= $settings->info_email ?>">
                                </div>
                            </div><!-- /.col -->

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>ایمیل مدیر (برای دریافت سریع  پیام های تماس با ما و اطلاع از خریدها)</label>
                                    <input class="form-control ltr" name="admin_email" value="<?= $settings->admin_email ?>">
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>آیا کاربر می تواند تیکت را ببندد؟</label>
                                    <select class="form-control" name="ticket[allow_close]">
                                        <option value="1" <?php if ($settings->ticket->allow_close) echo 'selected' ?>>بله</option>
                                        <option value="0" <?php if (!$settings->ticket->allow_close) echo 'selected' ?>>خیر</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>بعد از بسته شدن تیکت کاربر می تواند پیام ارسال کند؟</label>
                                    <select class="form-control" name="ticket[allow_send_after_close]">
                                        <option value="1" <?php if ($settings->ticket->allow_send_after_close) echo 'selected' ?>>بله</option>
                                        <option value="0" <?php if (!$settings->ticket->allow_send_after_close) echo 'selected' ?>>خیر</option>
                                    </select>
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-12">
                                <p>فایل‌های که کاربر می‌تواد در تیکت ارسال کند</p>
                                <div class="row">
                                    <?php foreach (['jpg', 'jpeg', 'png', 'docx', 'txt', 'pptx', 'ppt', 'pdf'] as $file_type): ?>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <label>
                                                    <input type="checkbox" name="ticket[allowed_user_files][]" value="<?= $file_type ?>" <?= in_array($file_type, $settings->ticket->allowed_user_files) ? 'checked' : '' ?>>
                                                    <?= $file_type?>
                                                </label>
                                            </div><!-- /.form-group -->
                                        </div><!-- /.col -->
                                    <?php endforeach; ?>
                                </div><!-- /.row -->
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <hr>

                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/saveContacts/"); ?>', '#form-contacts', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="social-networks" class="tab-pane fade <?= ($active_tab == 'social') ? 'active in' : '' ?>">
                    <form method="post" id="form-social-networks">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <?php
                        $index = 0;
                        if ($settings->social_networks) {
                            foreach ($settings->social_networks as $social_network) {
                                $index++;
                                print_social_network($index, $all_social_networks, $social_network);
                            }
                        }
                        $index++;

                        for (; $index <= 9; $index++) {
                            print_social_network($index, $all_social_networks);
                        }
                        ?>
                        <hr>

                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/saveSocialNetworks/"); ?>', '#form-social-networks', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/dashboard") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="pay-tab" class="tab-pane fade <?= ($active_tab == 'pay') ? 'active in' : '' ?>">
                    <form method="post" id="form-pay">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <div class="col-md-12">
                                <?php $settings->verify_when_buy = json_decode($settings->verify_when_buy); ?>
                                <div class="form-group">
                                    <div class="alert alert-warning fill m-0">
                                        <p>نکات مهم:</p>
                                        <ol>
                                            <li>در صورتی که مایل هستید گزینه 3 یا 4 را انتخاب کنید، حتما تنظیمات سرویس استعلام هویتی را تکمیل کنید تا عملیات مربوطه به درستی انجام شود.</li>
                                            <li>
                                                <p>گزینه 4 فقط برای درگاه‌های زیر عمل می‌کند و برای سایر درگاه‌ها و کارت به کارت عمل نمی‌کند.</p>
                                                <p>
                                                    <?php foreach ($gateways_check_card as $item): ?>
                                                        <span class="badge badge-inverse curve"><?= ucfirst($item->title_en) ?></span>
                                                    <?php endforeach ?>
                                                </p>
                                            </li>
                                            <?php if($active_gateways_not_check_card): ?>
                                                <li>شما نمی‌توانید گزینه 4 را فعال کنید، چون درگاه(های) زیر در وضعیت فعال هستند و در لیست درگاه‌های فوق نیستند. اگر مایل بودید که گزینه 4 را فعال کنید و از همین درگاه‌ها استفاده کنید، لطفا از طریق تیکت راستچین به ما پیام دهید تا امکان سنجی کنیم.</li>
                                                <?php foreach ($active_gateways_not_check_card as $item): ?>
                                                    <span class="badge badge-danger curve"><?= ucfirst($item->title_en) ?></span>
                                                <?php endforeach ?>
                                            <?php endif ;?>
                                            <li>تطابق شماره کارت بانکی با کد ملی  برای کارت به کارت بررسی نمی‌شود.</li>
                                        </ol>
                                    </div>
                                    <p>کاربر در چه صورتی می‌تواند خرید انجام دهد؟</p>
                                    <p>
                                        <label>
                                            <input type="radio"  name="verify_when_buy" value="" <?= (count($settings->verify_when_buy) == 0) ? 'checked' : '' ?>>
                                            گزینه 1:
                                            نیاز به تایید شماره همراه نیست.
                                        </label>
                                    </p>
                                    <p>
                                        <label>
                                            <input type="radio"  name="verify_when_buy" value="cell_phone" <?= (count($settings->verify_when_buy) == 1) ? 'checked' : '' ?>>
                                            گزینه 2:
                                            تایید <span class="text-danger">شماره همراه</span> اجباری است.
                                        </label>
                                    </p>
                                    <p>
                                        <label>
                                            <input type="radio" name="verify_when_buy" value="identity_inquiry" <?= (count($settings->verify_when_buy) == 2) ? 'checked' : '' ?>>
                                            گزینه 3:
                                            تایید <span class="text-danger">شماره همراه</span> اجباری است،
                                            و شماره همراه باید با <span class="text-danger">کد ملی</span> تطابق داشته باشد
                                            و کد ملی باید با <span class="text-danger">تاریخ تولد</span> تطابق داشته باشد.
                                        </label>
                                    </p>
                                    <p>
                                        <label>
                                            <input type="radio" name="verify_when_buy" value="bank_card" <?= (count($settings->verify_when_buy) == 3) ? 'checked' : '' ?> <?php if($active_gateways_not_check_card) echo 'disabled' ?>>
                                            گزینه 4:
                                            تایید <span class="text-danger">شماره همراه</span> اجباری است،
                                            و شماره همراه باید با <span class="text-danger">کد ملی</span> تطابق داشته باشد،
                                            و کد ملی باید با <span class="text-danger">تاریخ تولد</span> تطابق داشته باشد،
                                            و کاربر فقط با <span class="text-danger">کارت‌های بانکی</span> که با کد ملی‌اش تطابق دارد می‌تواند پرداخت کند.
                                        </label>
                                    </p>
                                </div><!--/.form-group-->
                                <hr>
                                <div class="alert alert-warning fill">
                                    <p>سرویس استعلام هویتی: </p>
                                    <p>برای تطابق شماره همراه و کد ملی  و همچنین برای تطابق کد ملی با شماره کارت بانکی در سایت زحل ثبت نام کنید و توکن خود را در باکس زیر ذخیره کنید.</p>
                                    <p>زمان ایجاد توکن از منوی توسعه‌دهندگان در سایت زحل لطفا وب‌سرویس‌های زیر را انتخاب کنید:</p>
                                    <ol>
                                        <li>تطابق موبایل و کدملی (شاهکار)</li>
                                        <li>استعلام اطلاعات هویتی</li>
                                        <li>تطابق کد ملی و شماره کارت</li>
                                    </ol>
                                    <p><a href="https://zohal.io" target="_blank">لینک سایت زحل (کلیک کنید)</a></p>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?php $settings->identity_verification = json_decode($settings->identity_verification); ?>
                                            <label>توکن سایت زحل برای استعلام هویتی کاربر و تطابق اطلاعات</label>
                                            <input type="text" class="form-control ltr text-left" name="zohal_token" value="<?= $settings->identity_verification->token ?>">
                                        </div><!-- /.form-group -->
                                    </div>
                                </div>
                                <hr>
                            </div>
                                                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>
                                        <input type="checkbox" name="active_charge_page" value="1" <?= ($settings->active_charge_page) ? 'checked' : '' ?>>
                                        صفحه شارژ کیف پول فعال باشد.
                                    </label>
                                </div><!-- /.form-group -->
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label> مدت زمان قفل بودن کارت:(مقادیر بین 2 تا 20 دقیقه قابل قبول میباشد)</label>
                                    <input type="number" class="form-control numeric" name="inaccess_minutes" value="<?= $settings->inaccess_minutes ?>">
                                </div><!-- /.form-group -->
                            </div>
                        </div><!-- /.row -->
                        
                        <div class="row">
                            <?php
                            $content = json_decode($settings->payment_alerts);
                            ?>
                            <div class="col-md-12">
                                <p>متن های تذکر </p>
                                <div class="dd nestable" >
                                    <ol class="dd-list">
                                        <?php if ($content): ?>
                                            <?php foreach ($content as $item) : ?>
                                                <?php if ($item): ?>
                                                    <li class="dd-item dd3-item">
                                                        <div class="dd-handle dd3-handle"></div>
                                                        <div class="dd3-content">
                                                            <div class="row">
                                                                <div class="col-md-1">
                                                                    <a class="btn btn-danger btn-icon btn-round remove-item btn-sm"><i class="icon-trash"></i></a>
                                                                </div><!-- /.col -->
                                                                <div class="col-md-10  col-md-offset-1">
                                                                    <input type="text" class="form-control" name="payment_alerts[]" value="<?= $item ?>">
                                                                </div><!-- /.col -->
                                                            </div><!-- /.row -->
                                                        </div>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                        <li class="dd-item dd3-item hide">
                                            <div class="dd-handle dd3-handle"></div>
                                            <div class="dd3-content">
                                                <div class="row">
                                                    <div class="col-md-1">
                                                        <a class="btn btn-danger btn-icon btn-round remove-item btn-sm"><i class="icon-trash"></i></a>
                                                    </div><!-- /.col -->
                                                    <div class="col-md-10 col-md-offset-1">
                                                        <input type="text" class="form-control" name="payment_alerts[]">
                                                    </div><!-- /.col -->
                                                </div><!-- /.row -->
                                            </div>
                                        </li>
                                    </ol>
                                </div><!-- /.nestable-season -->
                                <a href="javascript:void(0)" class="btn btn-success btn-round inc-item">جدید</a>

                            </div><!-- /.col -->

                        </div><!-- /.row -->

                        <div class="row">
                            <div class="col-md-12">
                                <hr>
                                <p>
                                    پکیج‌های شارژ کیف پول
                                    <span class="small">(در صفحه شارژ کیف پول قیمت‌ها از کم به زیاد نمایش داده می‌شود.)</span>
                                </p>
                                <?php 
                                $settings->charge_packages = json_decode($settings->charge_packages); 
                                for($i = count($settings->charge_packages); $i < 8; $i++){
                                    $settings->charge_packages[] = '';
                                }
                                ?>
                                <div class="row">
                                    <?php foreach ($settings->charge_packages as $value): ?>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <input type="text" class="form-control ltr text-left numeric separate" name="charge_packages[]" value="<?= ($value) ? number_format($value) : '' ?>" placeholder="مبلغ پکیج(تومان)">
                                            </div><!-- /.form-group -->
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <hr>
                            </div>
                        </div>

                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/savepaySettings/"); ?>', '#form-pay', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="sms-tab" class="tab-pane fade <?= ($active_tab == 'sms') ? 'active in' : '' ?>">
                    <form method="post" id="form-sms">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <?php 
                            switch ($settings->sms->active) {
                                case 'kavenegar':
                                    $token = '%token';
                                    break;
                                case 'rangine':
                                    $token = '%token%';
                                    break;
                                case 'smsir':
                                    $token = '#token#';
                                    break;
                                case 'melipayamak':
                                    $token = '{0}';
                                    break;
                                default:
                                    $token = '%token';
                                    break;
                            }
                            ?>
                            <div class="col-md-12">
                                <div class="alert alert-warning fill curve text-inverse">
                                    در صورتی که می خواهید پیامک ها برای تمامی خطوط، حتی خطوطی که پیامک های تبلیغاتی را بسته اند، ارسال شود از الگو(پترن) استفاده نمایید. 
                                    در غیر اینصورت این بخش ها را خالی گذاشته و از حالت ارسال عادی استفاده خواهد شد.
                                    <br>
                                    دقت کنید که برای استفاده از ارسال پیامک به روش الگو(پترن) ابتدا باید در پنل پیامکی خود، این الگوها را تعریف کنید و کد الگوی مورد نظر را در بخش مرتبط در فرم پایین، کپی کنید.
                                    همچنین توجه داشته باشید که تایید این الگو توسط پنل پیامکی شما انجام می شود و تا قبل از تایید آنها پیامک ها ارسال نخواهد شد.
                                </div><!-- /.alert --> 
                            </div><!-- /.col --> 
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>انتخاب پنل پیامک</label>
                                    <select class="form-control" name="sms[active]" id="slc-sms-active">
                                        <option value="">هیچکدام (غیر فعال باشد)</option>
                                        <option value="kavenegar" <?php if($settings->sms->active == 'kavenegar' ) echo 'selected'; ?>>کاوه نگار</option>
                                        <option value="rangine" <?php if($settings->sms->active == 'rangine' ) echo 'selected'; ?>>IP Panel(فراز اس‌ام‌اس، رنگینه)</option>
                                        <option value="melipayamak" <?php if($settings->sms->active == 'melipayamak' ) echo 'selected'; ?>>ملی پیامک</option>
                                        <option value="smsir" <?php if($settings->sms->active == 'smsir' ) echo 'selected'; ?>>sms.ir</option>
                                    </select>
                                </div>
                            </div><!-- /.col --> 
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>
                                        ApiKey 
                                        <span class="related-melipayamak <?php if($settings->sms->active != 'melipayamak') echo 'hide'; ?>">(ApiKey که درون کنسول هست را وارد کنید.)</span>
                                        <span class="text-danger <?php if($settings->sms->active == '') echo 'hide'; ?>">*</span>
                                    </label>
                                    <input class="form-control ltr" name="sms[api_key]" value="<?= $settings->sms->api_key ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>
                                        شماره فرستنده
                                        <span class="related-kavenegar related-smsir related-melipayamak <?php if($settings->sms->active == 'rangine') echo 'hide'; ?>">(برای ارسال عادی نیاز است)</span>
                                        <span class="text-danger related-rangine <?php if($settings->sms->active != 'rangine') echo 'hide'; ?>">*</span>
                                    </label>
                                    <input class="form-control ltr numeric" name="sms[from]" value="<?= $settings->sms->from ?>">
                                </div>
                            </div><!-- /.col -->
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>کد الگوی تایید شماره همراه (متن الگوی نمونه: "کد تایید شماره همراه شما <span class="inline-block ltr text-left"><span class="sms-token"><?= $token ?></span></span> می باشد.")</label>
                                    <input class="form-control ltr" name="sms[patterns][verify]" value="<?= $settings->sms->patterns->verify ?>" placeholder="کد الگو(پترن)">
                                </div>

                                <?php $settings->auth_call = isset($settings->auth_call) ? json_decode($settings->auth_call) : null; ?>
                                <?php if($settings->auth_call): ?>
                                    <div class="border border-info p-10 m-b-20">
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" name="auth_call[active]" value="1" <?= $settings->auth_call->active ? 'checked' : '' ?>>
                                                احراز هویت صوتی فعال باشد
                                            </label>
                                        </div><!-- /.form-group -->
                                        <div class="form-group">
                                            <label>کد الگوی احراز هویت صوتی کاوه نگار</label>
                                            <input class="form-control ltr text-left" name="auth_call[pattern]" value="<?= $settings->auth_call->pattern ?>" />
                                        </div><!-- /.form-group -->
                                    </div><!-- /.border --->
                                <?php endif ?>
                                <div class="border border-info p-10">
                                    <div class="form-group">
                                        <label>
                                            شماره همراه مدیر برای مطلع شدن از خرید های که منتظر ارسال کد هستند. (اگر شماره همراه را وارد نکنید یعنی نمی خواهید برایتان پیامک ارسال شود)
                                            <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-manual-product"><i class="fa fa-question"></i></a>
                                        </label>
                                        <input class="form-control ltr numeric" maxlength="11" name="notification_cell_phone" value="<?= $settings->notification_cell_phone ?>" placeholder="09123456789">
                                    </div>
                                    <div class="form-group">
                                        <label>کد الگوی اطلاع رسانی به ادمین برای خرید های که نیاز به تایید دارند. (متن الگوی نمونه: "یک خرید با شماره پیگیری <span class="inline-block ltr text-left"><span class="sms-token"><?= $token ?></span></span> در انتظار تایید شما می باشد.")</label>
                                        <input class="form-control ltr" name="sms[patterns][notify_sale_admin]" value="<?= $settings->sms->patterns->notify_sale_admin ?>" placeholder="کد الگو(پترن)">
                                    </div>
                                    <div class="form-group">
                                        <label>کد الگوی اطلاع رسانی به ادمین برای بررسی شارژ کیف پول با کارت به کارت. (متن الگوی نمونه: "یک تراکنش کارت به کارت با مبلغ <span class="inline-block ltr text-left"><span class="sms-token"><?= $token ?></span></span> در انتظار تایید شما می باشد.")</label>
                                        <input class="form-control ltr" name="sms[patterns][notify_card2card_admin]" value="<?= $settings->sms->patterns->notify_card2card_admin ?>" placeholder="کد الگو(پترن)">
                                    </div>
                                </div>
                                <div class="border border-info p-10 m-t-20">
                                    <div class="form-group">
                                        <label>کد الگوی اطلاع رسانی به مشتری برای تایید تراکنش کارت به کارت. (متن الگوی نمونه: "کارت به کارت با مبلغ <span class="inline-block ltr text-left"><span class="sms-token"><?= $token ?></span></span> تایید شد.")</label>
                                        <input class="form-control ltr" name="sms[patterns][card2card_accept]" value="<?= $settings->sms->patterns->card2card_accept ?>" placeholder="کد الگو(پترن)">
                                    </div>
                                    <div class="form-group">
                                        <label>کد الگوی اطلاع رسانی به مشتری برای رد کارت به کارت. (متن الگوی نمونه: "کارت به کارت با مبلغ <span class="inline-block ltr text-left"><span class="sms-token"><?= $token ?></span></span> رد شد.")</label>
                                        <input class="form-control ltr" name="sms[patterns][card2card_reject]" value="<?= $settings->sms->patterns->card2card_reject ?>" placeholder="کد الگو(پترن)">
                                    </div>
                                </div>
                                <div class="border border-info p-10 m-t-20">
                                    <div class="input-group">
                                        <div class="alert alert-warning">
                                            <p>
                                                نکته: اگر بعد از خرید و بازگشت از درگاه بانکی مایل به ارسال پیامک برای مشتری بودید و وضعیت محصول روی <strong>"با تاخیر و بعد از تایید ادمین"</strong> بود، پیامک بلافاصله ارسال نمی شود و بعد از تایید ادمین ارسال می شود.
                                                <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-manual-product"><i class="fa fa-question"></i></a>
                                            </p>
                                        </div>
                                        <label>پیامک بعد از خرید برای مشتری:</label>
                                        <p>
                                            <label>                            
                                                <input name="sms[after_buy]" type="radio" value="no" <?php if($settings->sms->after_buy == 'no') echo 'checked'; ?>>
                                                هیچ پیامکی برای مشتری ارسال نشود.
                                            </label>
                                        </p>
                                        <p>
                                            <label>                            
                                                <input name="sms[after_buy]" type="radio" value="codes" <?php if($settings->sms->after_buy == 'codes') echo 'checked'; ?>>
                                                کد(های) کارت(ها) برای مشتری پیامک شود.
                                            </label>
                                        </p>
                                        <p>
                                            <label>                            
                                                <input name="sms[after_buy]" type="radio" value="successful" <?php if($settings->sms->after_buy == 'successful') echo 'checked'; ?>>
                                                کد(های) کارت(ها) برای مشتری پیامک نشود ولی پیامک خرید موفقیت آمیز ارسال شود.
                                                <p style="margin-right: 20px;">(مثال: از خرید شما متشکریم. لینک مشاهده خرید شما: YOUR-DOMAIN/buy/123456)</p>
                                                <div class="form-group <?php if($settings->sms->after_buy != 'successful') echo 'hide'; ?>" id="pattern-buy-success" style="margin-right: 20px;">
                                                    <label>کد الگوی پیامک خرید موفق (متن الگوی نمونه: "از خرید شما متشکریم. لینک مشاهده خرید شما: <span class="inline-block ltr text-left">YOUR-DOMAIN/buy/<span class="sms-token"><?= $token ?></span></span>")</label>
                                                    <input class="form-control ltr" name="sms[patterns][successful_buy]" value="<?= $settings->sms->patterns->successful_buy ?>" placeholder="کد الگو(پترن)">
                                                </div>
                                            </label> 
                                        </p>
                                    </div><!-- /.input-group -->
                                </div>
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/saveSmsSettings/"); ?>', '#form-sms', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="email-tab" class="tab-pane fade <?= ($active_tab == 'email') ? 'active in' : '' ?>">
                    <?php 
                    $settings->email = json_decode($settings->email);
                    ?>
                    <form method="post" id="form-email">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="portlet box border shadow">
                                    <div class="portlet-heading">
                                        <div class="portlet-title">
                                            <h3 class="title">
                                                تنظیمات ارسال ایمیل
                                            </h3>
                                        </div><!-- /.portlet-title -->
                                    </div><!-- /.portlet-heading -->
                                    <div class="portlet-body">
                                        <div class="form-group">
                                            <label>کدام روش را برای انتخاب ایمیل ارسال می کنید؟</label>
                                            <select class="form-control" id="slc-email-method" name="email[method]">
                                                <option value="mail" <?php if ($settings->email->method == 'mail') echo 'selected' ?>>روش mail (ایمیل هاست)</option>
                                                <option value="smtp" <?php if ($settings->email->method == 'smtp') echo 'selected' ?>>روش SMTP</option>
                                            </select>
                                        </div>
                                        <div id="smtp-method" class="<?php if($settings->email->method != 'smtp') echo 'hide'; ?>">
                                            <div class="alert alert-warning fill">
                                                <p>برای ارسال ایمیل به روش SMTP، باید هر چهار مورد زیر با داده های صحیح تکمیل شوند.</p>
                                            </div>
                                            <div class="form-group">
                                                <label>میزبان SMTP</label>
                                                <input class="form-control ltr text-left" name="email[smtp][host]" value="<?= $settings->email->smtp->host ?>">
                                            </div>
                                            <div class="form-group">
                                                <label>نام کاربری SMTP</label>
                                                <input class="form-control ltr text-left" name="email[smtp][user]" value="<?= $settings->email->smtp->user ?>">
                                            </div>
                                            <div class="form-group">
                                                <label>رمز عبور SMTP</label>
                                                <input class="form-control ltr text-left" name="email[smtp][pass]" value="<?= $settings->email->smtp->pass ?>">
                                            </div>
                                            <div class="form-group">
                                                <label>پورت SMTP</label>
                                                <input class="form-control ltr text-left numeric" name="email[smtp][port]" value="<?= $settings->email->smtp->port ?>">
                                            </div>
                                        </div><!-- #smtp-method -->
                                        <div id="mail-method" class="<?php if($settings->email->method != 'mail') echo 'hide'; ?>">
                                            <div class="alert alert-warning fill">
                                            <p>برای ارسال ایمیل به روش mail، باید ایمیل هاست را وارد کنید.</p>
                                            </div>
                                            <div class="form-group">
                                                <label>ایمیل هاست</label>
                                                <input class="form-control ltr text-left" name="email[host_email]" value="<?= $settings->email->host_email ?>">
                                            </div>
                                        </div><!-- #mail-method -->

                                        <div class="form-actions m-t-20">
                                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?= base_url('admin/settings/saveEmailSettings'); ?>', '#form-email', '', '', '#msg', false, true, 'sweetalert')">
                                                <i class="icon-check"></i>
                                                ذخیره تنظیمات
                                            </a>
                                        </div><!-- /.form-actions -->
                                    </div><!-- /.portlet-body -->
                                </div><!-- /.portlet -->
                            </div><!-- /.col -->
                            <div class="col-md-6">
                                <div class="portlet box border shadow">
                                    <div class="portlet-heading">
                                        <div class="portlet-title">
                                            <h3 class="title">
                                                تست ارسال ایمیل
                                            </h3>
                                        </div><!-- /.portlet-title -->
                                    </div><!-- /.portlet-heading -->
                                    <div class="portlet-body">

                                        <?php if($settings->email->method == 'smtp' && $settings->email->smtp->host && $settings->email->smtp->user && $settings->email->smtp->pass && $settings->email->smtp->port): ?>
                                            <?php $completed_email_form = true; ?>
                                            <div class="alert alert-warning fill">
                                                <p>ارسال ایمیل برای شما به روش SMTP و با داده های زیر انجام می شود.</p>
                                            </div>
                                            <div class="border curve p-10">
                                                <div>
                                                    <span>میزبان SMTP</span>
                                                    <span class="pull-left ltr"><?= $settings->email->smtp->host ?></span>
                                                </div>
                                                <div>
                                                    <span>نام کاربری SMTP</span>
                                                    <span class="pull-left ltr"><?= $settings->email->smtp->user ?></span>
                                                </div>
                                                <div>
                                                    <span>رمز عبور SMTP</span>
                                                    <span class="pull-left ltr"><?= $settings->email->smtp->pass ?></span>
                                                </div>
                                                <div>
                                                    <span>پورت SMTP</span>
                                                    <span class="pull-left ltr"><?= $settings->email->smtp->port ?></span>
                                                </div>
                                            </div>
                                        <?php elseif($settings->email->method == 'mail' && $settings->email->host_email): ?>
                                            <?php $completed_email_form = true; ?>
                                            <div class="alert alert-warning fill">
                                                <p>ارسال ایمیل برای شما به روش mail و با ایمیل زیر انجام می شود.</p>
                                            </div>
                                            <div class="border curve p-10">
                                                <span>ایمیل هاست</span>
                                                <span class="pull-left ltr"><?= $settings->email->host_email ?></span>
                                            </div>
                                        <?php else: ?>
                                            <?php $completed_email_form = false; ?>
                                            <div class="alert alert-danger fill">
                                                <p>به دلیل تکمیل نکردن اطلاعات فرم <b>تنظیمات ارسال ایمیل</b> امکان ارسال ایمیل تستی فراهم نیست. لطفا ابتدا فرم <b>تنظیمات ارسال ایمیل</b> را تکمیل کنید.</p>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($completed_email_form): ?>
                                            <div class="form-group m-t-10">
                                                <label>ایمیل گیرنده</label>
                                                <input class="form-control ltr text-left" name="test[email]">
                                            </div>
                                            <div class="form-group">
                                                <label>متن ایمیل</label>
                                                <textarea class="form-control" name="test[text]" rows="3"></textarea>
                                            </div>
                                            <div class="form-actions m-t-20">
                                                <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?= base_url('admin/settings/sendTestEmail'); ?>', '#form-email', '', '', '#msg', false, true, 'sweetalert')">
                                                    <i class="icon-check"></i>
                                                    ارسال ایمیل تستی
                                                </a>
                                            </div><!-- /.form-actions -->
                                        <?php endif; ?>
                                    </div><!-- /.portlet-body -->
                                </div><!-- /.portlet -->
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                        <hr>
                        <div class="form-actions m-t-20 text-left">
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->

                <div id="detail-tab" class="tab-pane fade <?= ($active_tab == 'detail') ? 'active in' : '' ?>">
                    <form method="post" id="form-detail">
                        <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>اسکریپتی که در هدر قرار  میگیرد(Inside head tag)</label>
                                    <textarea class="form-control ltr" name="header_script" rows="6"><?= $settings->header_script ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label>اسکریپتی که در  بدنه اصلی قرار میگیرد (Inside body tag)</label>
                                    <textarea class="form-control ltr" name="body_script" rows="6"><?= $settings->body_script ?></textarea>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نماد اعتماد الکترونیکی</label>
                                    <textarea class="form-control ltr" name="enamad" rows="6"><?= $settings->enamad ?></textarea>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>نماد ساماندهی</label>
                                    <textarea class="form-control ltr" name="samandehi" rows="6"><?= $settings->samandehi ?></textarea>
                                </div>
                            </div>
                        </div><!-- /.row -->

                        <div class="form-actions m-t-20">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/settings/savedetail/"); ?>', '#form-detail', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره تنظیمات قسمت
                            </a>
                            <a href="<?= base_url("admin/home") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.tab-pane -->
            </div><!-- /.tab-content -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col -->
<script>
    $(document).ready(function () {

        //nestable
        $(".nestable").nestable({maxDepth: 1});
        var originalForm = [];
        $(".nestable").each(function () {
            originalForm.push($(this).find("li").last().clone());
        });
        console.log(originalForm);
        $(".inc-item").click(function (event) {
             $(".dd-item").removeClass("hide");
            var key = $(".inc-item").index(this);
            var oneForm = originalForm[key].clone();
            $(this).prev(".nestable").find("ol").append(oneForm);
        });

        $(document).on("click", ".remove-item", function () {
            var target = $(this).closest("li");
            $(target).remove();
        });

        // Change buy sms to success
        $("input[name='sms[after_buy]']").on('ifClicked', function(event){
            if(this.value == 'successful'){
                $("#pattern-buy-success").removeClass("hide");
            } else {
                $("#pattern-buy-success").addClass("hide");
            }
        });
        
        
        $("#slc-sms-active").on('change', function(){
            let selected = $(this).val();
            if(selected == 'rangine'){
                $("#sms-tab .form-group .text-danger").removeClass("hide");
                $("#sms-tab .sms-token").text("%token%");
            } else if(selected == 'kavenegar'){
                $("#sms-tab .form-group .text-danger").removeClass("hide");
                $("#sms-tab .sms-token").text("%token");
            } else if(selected == 'smsir'){
                $("#sms-tab .form-group .text-danger").removeClass("hide");
                $("#sms-tab .sms-token").text("#token#");
            } else if(selected == 'melipayamak'){
                $("#sms-tab .form-group .text-danger").removeClass("hide");
                $("#sms-tab .sms-token").text("{0}");
            } else {
                $("#sms-tab .form-group .text-danger").addClass("hide");
                $("#sms-tab .sms-token").text("%token");
            }
            
            $("#sms-tab [class*='related-']").addClass("hide");
            if(selected){
                $("#sms-tab .related-"+selected).removeClass("hide");
            }
        });

        $("select[name='theme[allowed_to_use]']").on('change', function(){
            let theme = $(this).val();
            if(theme == 'both'){
                $("select[name='theme[default]']").removeAttr("disabled");
            }  else {
                $("select[name='theme[default]']").val(theme).change();
                $("select[name='theme[default]']").attr("disabled", true);
            }
        });

        // Admin key
        $("#txt-admin-key").on('keyup', function(){
            let adminKey = $(this).val().trim();
            if(adminKey.length){
                $("#fix-admin-link").text('admin-');
            }  else {
                $("#fix-admin-link").text('admin');
            }
        });

        $("#btn-copy-admin-link").on("click", function() {
            let fix = baseUrl + $("#fix-admin-link").text().trim();
            let adminKey = $("#txt-admin-key").val().trim();

            var input = document.createElement('input');
            input.setAttribute('value', fix + adminKey);
            document.body.appendChild(input);
            input.select();
            document.execCommand('copy');
            document.body.removeChild(input);
           
            generateType('success', 'با موفقیت کپی شد', 'bottomLeft');
        });

        // وقتی متد ارسال ایمیل را تغییر می دهد
        $("#slc-email-method").on("click", function() {
            if($(this).val() == 'smtp'){
                $("#smtp-method").removeClass("hide");
                $("#mail-method").addClass("hide");
            } else {
                $("#mail-method").removeClass("hide");
                $("#smtp-method").addClass("hide");
            }
        });


        // Theme colors
        colors = <?= $colors_json ?>;

        // When theme color buttons is clicked
        $(".setting-theme-colors .btn").click(function(){
            if(!$(this).hasClass("active")){
                $(".setting-theme-colors .btn").removeClass("active");
                $(this).addClass("active");

                // Hide/Show background boxes according to the clicked color.
                themeColors = colors["theme-colors"];
                themeBgColors = colors["theme-bg-colors"];

                var clickedColor = $(".setting-theme-colors .btn.active").attr("data-color");
                relatedBgColors = themeColors[clickedColor];

                $("div[class^='box-']").addClass("hide");
                $(".btn-darkgray").click();
                relatedBgColors.forEach(validColor => {
                    $(".box-dark" + validColor).removeClass("hide");
                });

                $('input[name="theme[color]"]').val($(this).attr("data-color"));
                $('input[name="theme[bg_color]"]').val($(".setting-theme-bg-colors .btn.active").attr("data-color"));
            }
        });

        // When theme bg color buttons is clicked
        $(".setting-theme-bg-colors .btn").click(function(){
            if(!$(this).hasClass("active")){
                $(".setting-theme-bg-colors .btn").removeClass("active");
                $(this).addClass("active");

                $('input[name="theme[bg_color]"]').val($(this).attr("data-color"));
            }
        });

        var editorSiteDescription;
        var config = {};

        //to enable uplaod image plugin
        config.extraPlugins = 'simage';
        config.imageUploadURL = baseUrl + 'admin/media/upload_ckeditor/';
        config.dataParser = function(data) {
            return data.url;
        };
        
        config.ContentLangDirection = 'rtl';
        config.language = 'fa';
        config.font_names =
                "Tahoma;" +
                "Nazanin/Nazanin, B Nazanin, BNazanin;" +
                "Yekan/Yekan, BYekan, B Yekan, Web Yekan;" +
                "IranSans/IranSans;" +
                "Parastoo/Parastoo;" +
                "Arial/Arial, Helvetica, sans-serif;" +
                "Times New Roman/Times New Roman, Times, serif;";

        editorSiteDescription = CKEDITOR.appendTo('editor-site-description', config);
        editorSiteDescription.setData($("#content-site-description").val());

        $("#form-general .btn-save").on("click", function(){
            $("#content-site-description").val(editorSiteDescription.getData());
            insert('<?php echo base_url("admin/settings/saveGeneral/"); ?>', '#form-general', '', '', '#msg', false, true, 'sweetalert');
        });
    });

</script>
