<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

function toUL(array $array, $role_permissions, $level = 0) {
    $html = '<ol>' . PHP_EOL;
    foreach ($array as $value) {
        if ($role_permissions && in_array($value['en'], $role_permissions)) {
            $checked = 'checked';
        } else {
            $checked = '';
        }
        $html .= '<li>';
        $html .= '<div class="item">
                    <label>
                        <input type="checkbox" class="switch"  name="permission[]" value="' . $value['en'] . '" ' . $checked . '>
                        ' . $value['fa'] . '
                    </label>
                </div>';
        if (!empty($value['children'])) {
            $level++;
            $html .= toUL($value['children'], $role_permissions, $level);
            $level--;
        }
        $html .= '</li>' . PHP_EOL;
        if( $level == 0){
            $html .= '</li><hr></i>' . PHP_EOL;
        }
    }

    $html .= '</ol>' . PHP_EOL;

    return $html;
}

$role->id = intval($role->id);
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">

                    <i class="<?= $role->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $role->id == 0 ? 'نقش جدید' : 'ویرایش نقش' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12">

                    <form id="form-data" role="form" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" value="<?= $role->id ?>" name="id"/>
                        <div class="form-body">
                            <div class="col-md-12 margin-b-10">
                                <button type="button" class="btn btn-info" id="btn-select-all">
                                    <i class="fa fa-check"></i>
                                    انتخاب همه
                                </button>
                                <button type="button" class="btn btn-warning" id="btn-deselect-all">
                                    <i class="fa fa-times"></i>
                                    برداشتن انتخاب همه
                                </button>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>عنوان</label>
                                    <input type="text" class="form-control" name="title" value="<?= $role->title ?>" placeholder="عنوان">
                                </div>
                                <?php
                                $role->permissions = json_decode($role->permissions, true);
                                echo toUL($permissions, $role->permissions);
                                ?>
                            </div>
                        </div><!-- /.form-body -->
                        <div class="col-md-12">
                            <div class="form-actions">
                                <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url('admin/permissions/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')">
                                    <i class="icon-check"></i>
                                    ذخیره
                                </a>
                                <a href="<?= base_url('admin/permissions') ?>" class="btn btn-warning btn-round pull-left">
                                    <i class="icon-close"></i>
                                    بازگشت
                                </a>
                            </div><!-- /.form-actions -->
                        </div><!-- /.col -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
<script>
    $(document).ready(function() {

        // Style for Checkboxes
        $('input[type="checkbox"]:not(".switch")').iCheck({
            checkboxClass: 'icheckbox_minimal-grey',
            increaseArea: '20%' // optional
        });

        // Check and Deseselct All iChecks
        $("#btn-select-all").click(function() {
            $('input:checkbox').iCheck('check');
        });
        $("#btn-deselect-all").click(function() {
            $('input:checkbox').iCheck('uncheck');
        });
    });
    $('input').on('ifChanged', function(event) {
        if (event.target.checked) {
            //تمام فرزندان تیک بزن
            $(this).closest('li').find('input').iCheck('check');

            //تیک پدرم را بزن
            $(this).parents('ol').prev('div.item').find('input').attr("checked", true).iCheck('update');

        } else {
            //تیک تمام فرزندان رو بردار
            $(this).closest('li').find('input').iCheck('uncheck');

        }
    });
</script>
