<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$order->id = intval($order->id);
?>
<!--CSS-->
<style>
    .table-striped>tbody>tr>td:nth-child(1) {
        width: 110px;
    }
    .serial{
        overflow-wrap: break-word;
        direction: ltr;
    }
    @media (min-width: 768px){
        .serial{
            max-width: 300px;
        }
    }
</style>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-user-following"></i>
                    اطلاعات خریدار
                </h3>
            </div>
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div>
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-4">
                    همراه : <?= $user->cell_phone ?>
                </div><!-- /.col -->
                <div class="col-md-4">
                    وضعیت : 
                    <?php if($user->status == 'accept'): ?>
                        <span class="label label-success">تایید شده</span>
                    <?php else: ?>
                        <span class="label label-danger">تایید نشده</span>
                    <?php endif ?>
                </div><!-- /.col -->
                
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col -->

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-credit-card"></i>
                    اطلاعات تراکنش های پرداختی
                </h3>
            </div>
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div>
        </div>
        <div class="portlet-body">

            <div>
                وضعیت پرداخت:
                <?php if (($order->paid == '1')): ?>
                    <span class="label label-success round">
                        پرداخت شده
                    </span>
                <?php else: ?>
                    <span class="label label-warning round">
                        پرداخت نشده
                    </span>
                <?php endif ?>
            </div>
            <?php if ($transactions && ($order->paid || $order->card2card)): ?>
                <div class="table-responsive m-t-20">
                    <table class="table table-striped table-bordered">
                        <tr>
                            <th>مبلغ</th>
                            <th>تاریخ ثبت تراکنش</th>
                            <th>کد پیگیری تراکنش</th>
                            <th>نام درگاه</th>
                            <?php if($order->card2card): ?>
                                <th>وضعیت تایید مدیر</th>
                            <?php endif; ?>
                        </tr>
                        <?php foreach ($transactions as $transaction): ?>
                            <tr>
                                <td class="ltr text-center">
                                    <?php if($transaction->amount > 0): ?>
                                        <?php if($transaction->completed): ?>
                                            <span class="label label-success">+<?= number_format($transaction->amount)?></span>
                                        <?php elseif($transaction->reject): ?>
                                            <span class="label label-danger">+<?= number_format($transaction->amount)?></span>
                                        <?php else: ?>
                                            <span class="label label-warning">+<?= number_format($transaction->amount)?></span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="label label-default"><?= number_format($transaction->amount)?></span>
                                    <?php endif; ?>

                                    <?php if($transaction->amount_dollar): ?>
                                        <br><br>
                                        <div class="label label-info m-t-10">
                                            <span>
                                                <span>مبلغ دلاری:</span>
                                                <span class="iransans-en"><?= floatval($transaction->amount_dollar) ?></span>
                                            </span>
                                            <span>
                                                <span>قیمت دلار:</span>
                                                <?= $transaction->dollar_rate ? number_format($transaction->dollar_rate) : '0' ?> تومان
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span dir="ltr"><?= $transaction->created ?></span>
                                </td>
                                <td><?= $transaction->reference ?></td>
                                <td>
                                    <?php if($transaction->gateway ): ?>
                                        <?php if($transaction->gateway_image && file_exists($transaction->gateway_image)): ?>
                                            <img class="img-curve" src="<?= base_url($transaction->gateway_image)?>">
                                            <span>(<?= $transaction->gateway_title ?>)</span>
                                        <?php else: ?>
                                            <span><?= $transaction->gateway_title ?></span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span><?= getTransactionTypes($transaction->type)?></span>
                                    <?php endif; ?>
                                </td>
                                <?php if($order->card2card): ?>
                                    <td>
                                        <?php if($transaction->gateway == 'card2card'): ?>
                                            <?php if ($order->card2card == 'pending') : ?>
                                                <span class="badge badge-warning">در انتظار تایید</span>
                                            <?php elseif ($order->card2card == 'reject') : ?>
                                                <span class="badge badge-danger">در شده</span>
                                            <?php else : ?>
                                                    <span class="badge badge-success">تایید شده</span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                <?php endif ?>
                            </tr>
                        <?php endforeach ?>
                    </table>
                </div>
                <?php if ($order->card2card && $transactions[0]->gateway == 'card2card'): ?>
                    <?php 
                        $transaction = $transactions[0];
                        $transaction->detail = json_decode($transaction->detail);
                    ?>
                    <hr>
                    <div class="row">
                        <div class="col-md-6">
                            <div>اطلاعات وارد شده <b>توسط کاربر</b>:</div>
                            <div>تاریخ کارت به کارت: <b><?= $this->pdate->date('Y/m/d H:i', strtotime($transaction->detail->transfer_date)) ?></b></div>
                            <div>شماره کارت واریز کننده: <b class="inline-block"><?= wordwrap($transaction->detail->customer_card , 4 , '-' , true) ?></b></div>
                            <div>شماره پیگیری تراکنش: <b><?= $transaction->reference ?></b></div>
                            <div>توضیحات: <?= html_escape($transaction->detail->description) ?></div>
                        </div><!-- /.col -->
                        <div class="col-md-6">
                            <?php if($transaction->detail->image && file_exists($transaction->detail->image)): ?>
                                <img src="<?= base_url($transaction->detail->image) ?>" width="300" />
                            <?php endif; ?>
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                <?php endif ?>
            <?php endif ?>
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col -->


<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-basket fa-flip-horizontal"></i>
                    اطلاعات سفارش
                </h3>
            </div>
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <tbody>
                                <tr>
                                    <td>کد پیگیری</td>
                                    <td><?= $order->tracking_code ?></td>
                                </tr>
                                <tr>
                                    <td>ش. سفارش</td>
                                    <td><?= $order->id ?></td>
                                </tr>
                                <?php if($order->coupon_discount): ?>
                                    <tr>
                                        <td>تخفیف کوپن</td>
                                        <td><?= number_format($order->coupon_discount) ?> تومان</td>
                                    </tr>
                                <?php endif; ?>
                                <tr>
                                    <td>مبلغ</td>
                                    <td><?= number_format($order->price) ?> تومان</td>
                                </tr>
                                <tr>
                                    <td>زمان ثبت</td>
                                    <td><?= $order->jalali_created ?></td>
                                </tr>
                                <tr>
                                    <td>آی پی</td>
                                    <td><?= $order->ip ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <tbody>
                            <tr>
                                <tr>
                                    <td>همراه</td>
                                    <td><?= $order->cell_phone ?></td>
                                </tr>
                                <td>ایمیل</td>
                                    <td class="ltr tahoma text-right"><?= html_escape($order->email) ?></td>
                                </tr>
                                <?php foreach ($order->fields as $item): ?>
                                    <tr>
                                        <td><?= $item->title ?></td>
                                        <td><?= html_escape($item->value) ?></td>
                                    </tr>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col -->

<div class="col-md-12" id="cards-box">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">
                    <i class="icon-list fa-flip-horizontal"></i>
                    اطلاعات کارتها
                </h3>
            </div>
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div>
        </div>
        <div class="portlet-body">
            <?php
            if ($cards) {
                ?>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th class="width-10">#</th>
                                <th>عنوان</th>
                                <th>قیمت(تومان)</th>
                                <th>قیمت ارزی</th>
                                <th>نرخ لحظه ارز</th>
                                <th><?= $category_fileds->field1_title ?></th>
                                <?php if ($category_fileds->field2_title): ?>
                                    <th><?= $category_fileds->field2_title ?></th>
                                <?php endif; ?>
                                <?php if ($category_fileds->field3_title): ?>
                                    <th><?= $category_fileds->field3_title ?></th>
                                <?php endif; ?>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $c = 0;
                            foreach ($cards as $card) {
                                ?>
                                <tr>
                                    <td class="width-10"><?= ++$c ?></td>
                                    <td><?= $card->title . '(دسته: ' . $card->category_title . ')' ?></td>
                                    <td><?= number_format($card->sell_price) ?></td>
                                    <td>
                                        <?php if ($card->currency != 'tooman') : ?>
                                            <span> <?= floatval($card->currency_sell_price) ?> </span>
                                            <span> <?= translateCurrency($card->currency) ?></span>
                                        <?php endif; ?>
                                    </td>

                                    <td><?php if ($card->currency_rate != 0) echo number_format($card->currency_rate) ?></td>
                                    <td><div class="table-serial"><?= $card->code ?></div></td>
                                    <?php if ($card->code2): ?>
                                        <td><div class="table-serial"><?= $card->code2 ?></div></td>
                                    <?php endif; ?>
                                    <?php if ($card->code3): ?>
                                        <td><div class="table-serial"><?= $card->code3 ?></div></td>
                                    <?php endif; ?>
                                    <td>
                                        <?php if(in_array('cards_edit', $this->user_permissions)): ?>
                                            <a href="<?= base_url("admin/cards/edit/$card->id/?order_id=$order->id") ?>" class="btn btn-warning btn-round btn-icon"><i class="icon-pencil"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
                <?php
            } else {
                ?>
                <div class="alert alert-danger curve text-center">موردی یافت نشد</div>
                <?php
            }
            ?>
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
    
    <?php if(($order->paid || $order->card2card == 'pending') && in_array('orders_edit', $this->user_permissions)): ?>
        <div class="portlet box border shadow">
            <div class="portlet-heading">
                <div class="portlet-title">
                    <h3 class="title">
                        <i class="icon-check"></i>
                        اطلاعات وضعیت
                        <a class="btn btn-warning btn-icon btn-round btn-sm" data-toggle="modal" data-target="#modal-education-manual-product"><i class="fa fa-question"></i></a>
                    </h3>
                </div>
                <div class="buttons-box">
                    <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                        <i class="icon-arrow-up"></i>
                    </a>
                </div>
            </div>
            <div class="portlet-body">
                <form id="form-status">
                    <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" name="id" value="<?= $order->id ?>">
                    <input type="hidden" name="card2card" value="">
                    <input type="hidden" name="pending" value="<?= $order->pending ?>">
                    <div class="row">
                        <?php if($order->card2card != 'reject'): ?>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <?php if($order->card2card && $order->card2card == 'pending'): ?>
                                        <div class="form-check">
                                            <input class="form-check-input normal" type="radio" name="status" id="status-accept-done" data-card2card="accept" data-pending="0" data-allow-send="true" >
                                            <label class="form-check-label" for="status-accept-done">
                                                اطلاعات <span class="text-success">تراکنش کارت به کارت</span> را تایید می کنم، و <span class="text-success">اطلاعات کارت(ها)</span> در اختیار کاربر قرار بگیرید.
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input normal" type="radio" name="status" id="status-accept-pending" data-card2card="accept" data-pending="1" data-allow-send="true">
                                            <label class="form-check-label" for="status-accept-pending">
                                                اطلاعات <span class="text-success">تراکنش کارت به کارت</span> را تایید می کنم، اما <span class="text-danger">اطلاعات کارت(ها)</span> فعلا در اختیار کاربر قرار نگیرید.
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input normal" type="radio" name="status" id="status-reject-done" data-card2card="reject" data-pending="0" data-allow-send="true">
                                            <label class="form-check-label" for="status-reject-done">
                                                اطلاعات <span class="text-danger">تراکنش کارت به کارت</span> را رد می کنم، و کارت(های) این سفارش را آزاد می کنم.
                                            </label>
                                        </div>
                                    <?php else: ?>
                                        <div class="form-check">
                                            <input class="form-check-input normal" type="radio" name="status" id="status-done" data-card2card="" data-pending="0" data-allow-send="true" <?php if($order->pending == 0) echo 'checked'?>>
                                            <label class="form-check-label" for="status-done">
                                                اطلاعات <span class="text-success">کارت(ها)</span> در اختیار کاربر قرار بگیرید.
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input normal" type="radio" name="status" id="status-pending" data-card2card="" data-pending="1" data-allow-send="false" <?php if($order->pending == 1) echo 'checked'?>>
                                            <label class="form-check-label" for="status-pending">
                                                اطلاعات <span class="text-danger">کارت(ها)</span> فعلا در اختیار کاربر قرار نگیرید و در وضعیت انتظار باشد.
                                            </label>
                                        </div>
                                    <?php endif; ?>
                                </div><!-- /.form-group -->
                            </div><!-- /.col -->

                            <?php if($order->card2card && $order->card2card == 'pending' && in_array('tickets_add', $this->user_permissions)): ?>
                                <div class="col-md-12 m-b-20 ticket-box hide">
                                    <div class="border border-info curve p-10">
                                        <div class="form-group m-0">
                                            <label>
                                                <input type="checkbox" name="ticket[send]" value="1" checked>
                                                برای کاربر تیکت ارسال شود
                                            </label>
                                        </div><!--/.form-group-->
                                        <div class="row ticket-inputs">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>عنوان <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="ticket[title]" value="پیرو رد تراکنش سفارش شماره <?= $order->tracking_code?>">
                                                </div>
                                            </div><!-- /.col -->
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>بخش <span class="text-danger">*</span></label>
                                                    <select class="form-control" name="ticket[category_id]">
                                                        <?php if ($ticket_categories) : ?>
                                                            <?php foreach ($ticket_categories as $item) : ?>
                                                                <option value="<?= $item->id ?>"><?= $item->title ?></option>
                                                            <?php endforeach; ?>
                                                        <?php endif; ?>
                                                    </select>
                                                </div>
                                            </div><!-- /.col -->
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>فوریت <span class="text-danger">*</span></label>
                                                    <select class="form-control" name="ticket[priority]">
                                                        <option value="low"><?= translatePriority('low') ?></option>
                                                        <option value="normal"><?= translatePriority('normal') ?></option>
                                                        <option value="high"><?= translatePriority('high') ?></option>
                                                    </select>
                                                </div>
                                            </div><!-- /.col -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>متن پیام <span class="text-danger">*</span></label>
                                                    <textarea class="form-control" rows="6" name="ticket[text]"><?= "با سلام\r\nسفارش شما به دلیل صحیح نبودن اطلاعات کارت به کارت ثبت شده توسط شما، رد شد.\r\nدر صورت اعتراض نسبت با این موضوع، پیام و مستندات خود را در همین تیکت ارسال کنید.\r\nبا احترام" ?></textarea>
                                                </div>
                                            </div><!-- /.col -->
                                        </div>
                                    </div>
                                </div><!-- /.col -->
                            <?php endif; ?>

                            <div class="col-md-12">
                                <div class="form-actions">
                                    <a href="javascript: void(0)"  class="btn btn-success btn-round btn-save">
                                        <i class="icon-check"></i>
                                        ذخیره
                                    </a>
                                    <?php $disabled = ($order->pending) ? 'disabled' : ''; ?>
                                    <a href="javascript: void(0)"  class="btn btn-info btn-round btn-save btn-send <?= $disabled ?>" <?= $disabled ?>>
                                        <i class="icon-envelope"></i>
                                        <span>ذخیره و ارسال پیامک و ایمیل</span>
                                    </a>
                                </div><!-- /.form-actions -->
                            </div><!-- /.col -->
                        <?php else: ?>
                            <div class="col-md-12 text-center">
                                <div class="alert alert-danger">تراکنش کارت به کارت این سفارش رد شده است.</div>
                                <?php if($order->user_id): ?>
                                    <a href="<?= base_url("admin/tickets/index/$order->user_id") ?>" class="btn btn-info">مشاهده تیکت های این کاربر</a>
                                <?php endif; ?>
                            </div>
                            
                        <?php endif; ?>
                    </div><!-- /.row -->

                </form>
            </div><!-- /.portlet-body -->
        </div><!-- /.portlet -->
    <?php endif; ?>
</div><!-- /.col -->

<div class="col-md-12">
    <div class="portlet box border shadow m-t-20">
        <div class="form-actions text-left">
            <a href="<?= ($user_id) ?  base_url("admin/orders/index/$user_id") :  base_url("admin/orders") ?>" class="btn btn-warning btn-round">
                <i class="icon-close"></i>
                بازگشت
            </a>
        </div><!-- /.form-actions -->
    </div><!-- /.portlet -->
</div><!-- /.col -->



<!--END CONTENT-->
<script>
    $(document).ready(function () {
        <?php if ($not_reading_order == 0): ?>
            $(".not-reading-order").addClass("hidden");
        <?php else: ?>
            $(".not-reading-order").html("<?= $not_reading_order ?>");
            $(".not-reading-order").removeClass("hidden");
        <?php endif ?>

        $(document).on("change", "input[name='status']", function (event) {
            target = $(this);

            if(target.attr("data-allow-send") == 'true'){
                $(".btn-save.btn-send").removeClass("disabled").removeAttr("disabled");
            } else{
                $(".btn-save.btn-send").addClass("disabled").attr("disabled", true);
            }

            if(target.attr("data-card2card") == 'reject'){
                $(".btn-save.btn-send span").text("ذخیره و ارسال پیامک رد کارت به کارت");
            } else if(target.attr("data-card2card") == 'accept' && target.attr("data-pending") == '1'){
                $(".btn-save.btn-send span").text("ذخیره و ارسال پیامک تایید کارت به کارت");
            } else {
                $(".btn-save.btn-send span").text("ذخیره و ارسال پیامک و ایمیل");
            }

            $("input[name='card2card']").val(target.attr("data-card2card"));
            $("input[name='pending']").val(target.attr("data-pending"));

            if($(".ticket-box").length){
                if(target.attr("data-card2card") == 'reject'){
                    $(".ticket-box").removeClass("hide");
                } else {
                    $(".ticket-box").addClass("hide");
                }
            }
        });


        function save(sendInfo){
            sendInfo = (sendInfo) ? 1 : 0;
            insert('<?= base_url('admin/orders/saveStatus/'); ?>' + sendInfo, '#form-status', '', '', '#msg', false, true, 'sweetalert')
        }

        $(".btn-save").on("click", function() {
            let card2card = $("input[name='status']:checked").attr("data-card2card");
            let sendInfo = $(this).hasClass("btn-send") ? true : false;

            if($("input[name='status']:checked").length == 0){
                swal('', 'هیچ گزینه ای را انتخاب نکرده اید!', 'error');
                return; 
            }

            if(card2card == 'accept' || card2card == 'reject'){

                if(card2card == 'accept'){
                    text = "آیا اطمینان دارید که اطلاعات کارت به کارت را <b>تایید</b> می کنید.";
                    btnTitle = "بله، تایید می کنم";
                } else {
                    text = "آیا اطمینان دارید که اطلاعات کارت به کارت را <b>رد</b> می کنید.";
                    btnTitle = "بله، رد می کنم";
                }
                var target = $(this).closest(".box-image");
                swal({
                    title: "این عملیات برگشت پذیر نیست!",
                    html: text,
                    type: "error",
                    showCancelButton: true,
                    confirmButtonColor: "#f44336",
                    confirmButtonText: btnTitle,
                    cancelButtonText: "انصراف",
                    cancelButtonColor: '#55b559',
                    closeOnConfirm: false,
                    closeOnCancel: true //false
                }).then(function() {
                    //confirm
                    save(sendInfo);
                }, function(dismiss) {
                    //cancel
                });
            } else {
                save(sendInfo);
            }
            
        });

        $(document).on("ifChanged", "input[name='ticket[send]']", function (event) {
            if(event.target.checked){
                $(".ticket-inputs").removeClass("hide");
            }else{
                $(".ticket-inputs").addClass("hide");
            }
        });
    });
</script>
