<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$gateway->id = intval($gateway->id);
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">                                        
                    <i class="<?= $gateway->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $gateway->id == 0 ? 'درگاه جدید' : 'ویرایش درگاه' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <form id="form-data" role="form" method="POST">
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" name="id" value="<?= $gateway->id ?>">
                        <div class="form-body">
                            <div class="row">
                                <div class="hide col-md-6">
                                    <div class="form-group">
                                        <label>عنوان En</label>
                                        <input type="text" class="form-control" value="<?= $gateway->title_en ?>" readonly>
                                    </div>
                                </div><!-- /.col -->
                                <?php if($gateway->title_en != 'card2card'): ?>
                                    <div class="col-md-12 m-b-10">
                                        <div class="input-group">
                                            <input type="text" id="txt-link" class="form-control ltr" value="<?= base_url("pay/verify/$gateway->title_en")?>" readonly>
                                            <span class="input-group-btn">
                                                <button id="btn-copy-link" class="btn btn-primary" type="button" ><i class="icon-docs"></i> کپی لینک Callback</button>
                                            </span>
                                        </div><!-- ./input-group -->
                                    </div><!-- ./col -->
                                <?php endif ?>
                                <div class="col-md-6">                                
                                    <div class="form-group">
                                        <label>عنوان فارسی</label>
                                        <input class="form-control" name="title_fa" value="<?= $gateway->title_fa ?>" >
                                    </div>
                                </div><!-- /.col -->
                                <div class="col-md-6">                                
                                    <div class="form-group box-image">
                                        <label>تصویر <span>(50x50)</span> پیکسل</label>
                                        <?php
                                        $class_hide = '';
                                        if ($gateway->image != '' && file_exists($gateway->image)) {
                                            $image = base_url() . $gateway->image;
                                            $class_hide = 'hide';
                                            ?>
                                            <div class="box-old-image">
                                                <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/gateways/removeImage/$gateway->id"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                                <img class="img-responsive img-thumbnail" src="<?= $image ?>">
                                            </div>
                                            <?php
                                        }
                                        ?>
                                        <div class="box-new-image <?= $class_hide ?>">
                                            <input type="file" class="form-control ltr" name="image">
                                        </div>
                                    </div>
                                </div><!-- /.col -->
                                
                                <div class="col-md-6 hide">                                
                                    <div class="form-group">
                                        <label>سندباکس</label>
                                        <select class="form-control" name="sandbox">
                                            <option value="1" <?php if($gateway->sandbox) echo 'selected' ?>>بله</option>
                                            <option value="0" <?php if(!$gateway->sandbox) echo 'selected' ?>>خیر</option>
                                        </select>
                                    </div>
                                </div><!-- /.col -->
                                <?php if($gateway->title_en != 'card2card'): ?>
                                    <div class="col-md-12">                                
                                        <div class="form-group">
                                            <label>توکن / کلید / پین / ترمینال / API KEY</label>
                                            <input class="form-control ltr" name="token" value="<?= $gateway->token ?>">
                                        </div>
                                    </div><!-- /.col -->
                                <?php endif; ?>
                                <?php if(in_array($gateway->title_en, ['mellat', 'saman'])): ?>
                                    <div class="col-md-12">                                
                                        <div class="form-group">
                                            <label>Username</label>
                                            <input class="form-control ltr" name="username" value="<?= $gateway->username ?>">
                                        </div>
                                    </div><!-- /.col -->
                                <?php endif; ?>
                                <?php if(in_array($gateway->title_en, ['mellat', 'saman', 'jibit'])): ?>
                                    <div class="col-md-12">                                
                                        <div class="form-group">
                                            <label>Password / API Secret</label>
                                            <input class="form-control ltr" name="password" value="<?= $gateway->password ?>">
                                        </div>
                                    </div><!-- /.col -->
                                <?php endif; ?>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>ترتیب نمایش</label>
                                        <input  type="number" name="ordering" value="<?= $gateway->ordering ?>" class="form-control numeric">
                                    </div>
                                </div><!-- /.col -->
                                <?php if(0): ?>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>وضعیت انتشار</label>
                                            <select   class="form-control" name="publish" >
                                                <option value="1" <?php if ($gateway->publish == '1') echo 'selected'; ?>>انتشار</option>
                                                <option value="0" <?php if ($gateway->publish == '0') echo 'selected'; ?>>عدم انتشار</option>
                                            </select>
                                        </div>
                                    </div><!-- /.col -->
                                <?php endif ?>
                                <?php if($gateway->title_en == 'card2card'): ?>
                                    <div class="col-md-12">
                                        <div class="form-group m-b-20">
                                            <label>متن توضیحات برای مودال دریافت اطلاعات کارت به کارت</label>
                                            <div class="alert alert-warning">
                                                <p class="text-inverse">شما می توانید برای نمایش مبلغ به تومان از عبارت <strong>{{amountToman}}</strong> و برای نمایش مبلغ به ریال از عبارت <strong>{{amountRial}}</strong> در متن خود استفاده کنید.</p>
                                            </div>
                                            <textarea name="card2card_alert" class="hide" id="content"><?= $card2card_alert ?></textarea>
                                            <div id="editor"></div>
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->
                                <?php endif; ?>
                            </div><!-- /.row -->

                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round btn-save">
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url('admin/gateways') ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->

                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
<script>
    $(document).ready(function(){
        $("#btn-copy-link").on("click", function() {
            var textBox = document.getElementById("txt-link");
            textBox.select();
            document.execCommand("copy");
            generateType('success', 'با موفقیت کپی شد', 'bottomLeft');
        });

        <?php if($gateway->title_en == 'card2card'): ?>
            var editor;
            var config = {};

            function createPersianEditor(config) {
                editor = CKEDITOR.appendTo('editor', config);
                editor.setData($("#content").val());
            }

            //to enable uplaod image plugin
            config.extraPlugins = 'simage';
            config.imageUploadURL = baseUrl + 'admin/media/upload_ckeditor/';
            config.dataParser = function(data) {
                return data.url;
            };
            
            config.ContentLangDirection = 'rtl';
            config.language = 'fa';
            config.font_names =
                    "Tahoma;" +
                    "Nazanin/Nazanin, B Nazanin, BNazanin;" +
                    "Yekan/Yekan, BYekan, B Yekan, Web Yekan;" +
                    "IranSans/IranSans;" +
                    "Parastoo/Parastoo;" +
                    "Arial/Arial, Helvetica, sans-serif;" +
                    "Times New Roman/Times New Roman, Times, serif;";
            createPersianEditor(config);
        <?php endif; ?>


        $(".btn-save").click(function(e) {
            if($("#content").length){
                $("#content").val(editor.getData());
            }
            insert('<?php echo base_url('admin/gateways/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')
        });

    });
</script>