<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<div class="col-md-12">
    <div class="row">
        <div class="col-md-12">
            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger">
                    <?= $this->session->flashdata('error') ?>
                </div>
            <?php endif; ?>
            <?php if ($this->session->flashdata('update_successfull')): ?>
                <div class="alert alert-success">
                    <p>تبریک! نسخه کارتا با موفقیت بروز شد.(نسخه <?= $this->session->flashdata('update_successfull') ?>)</p>
                </div>
            <?php endif; ?>

            <?php if(isset($warning)): ?>
                <div class="alert alert-danger">
                    <?= $warning ?>
                </div>
            <?php endif; ?>
        </div><!-- /.col -->
        <?php if (in_array('users', $user_permissions)): ?>
            <div class="col-md-3 col-xs-6 xxs-full-width">
                <div class="stat-box bg-darkblue shadow">
                    <a href="<?= base_url('admin/users') ?>">
                        <div class="stat">
                            <div class="counter-down" data-value="<?= $users_count ?>"></div>
                            <div class="h3">مدیر</div>
                        </div><!-- /.stat -->
                        <div class="visual">
                            <i class="icon-people"></i>
                        </div><!-- /.visual -->
                    </a>
                </div><!-- /.stat-box -->
            </div><!-- /.col-md-3 -->
        <?php endif; ?>
        <?php if (in_array('products', $user_permissions)): ?>
            <div class="col-md-3 col-xs-6 xxs-full-width">
                <div class="stat-box bg-blue shadow">
                    <a href="<?= base_url('admin/products') ?>">
                        <div class="stat">
                            <div class="counter-down" data-value="<?= $products_count ?>"></div>
                            <div class="h3">محصول</div>
                        </div><!-- /.stat -->
                        <div class="visual">
                            <i class="icon-present"></i>
                        </div><!-- /.visual -->
                    </a>
                </div><!-- /.stat-box -->
            </div><!-- /.col-md-3 -->
        <?php endif; ?>
        <?php if (in_array('orders', $user_permissions)): ?>
            <div class="col-md-3 col-xs-6 xxs-full-width">
                <div class="stat-box bg-orange shadow">
                    <a href="<?= base_url('admin/orders') ?>">
                        <div class="stat">
                            <div class="counter-down" data-value="<?= $orders_count ?>"></div>
                            <div class="h3">سفارش ثبت شده</div>
                        </div><!-- /.stat -->
                        <div class="visual">
                            <i class="icon-diamond"></i>
                        </div><!-- /.visual -->
                    </a>
                </div><!-- /.stat-box -->
            </div><!-- /.col-md-3 -->
            <div class="col-md-3 col-xs-6 xxs-full-width">
                <div class="stat-box bg-red shadow">
                    <a href="<?= base_url('admin/orders') ?>">
                        <div class="stat">
                            <div class="counter-down" data-value="<?= $not_reading_order ?>"></div>
                            <div class="h3">سفارش دیده نشده</div>
                        </div><!-- /.stat -->
                        <div class="visual">
                            <i class="icon-basket"></i>
                        </div><!-- /.visual -->
                    </a>
                </div><!-- /.stat-box -->
            </div><!-- /.col-md-3 -->
        <?php endif; ?>
    </div><!-- /.row -->
    <?php if (in_array('orders', $user_permissions)): ?>
        <div class="row">
            <div class="col-md-12 m-t-10">
                <div class="portlet box border shadow">
                    <div class="portlet-heading">
                        <div class="portlet-title">
                            <h3 class="title">
                                <i class="icon-graph"></i>
                                فروش روزانه
                            </h3>
                        </div><!-- /.portlet-title -->
                        <div class="buttons-box">
                            <a class="btn btn-sm btn-default btn-round btn-fullscreen" rel="tooltip" title="تمام صفحه" href="#">
                                <i class="icon-size-fullscreen"></i>
                            </a>
                            <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                                <i class="icon-arrow-up"></i>
                            </a>
                        </div><!-- /.buttons-box -->
                    </div><!-- /.portlet-heading -->
                    <div class="portlet-body">
                        <div class="row">
                            <div class="col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2">
                                <canvas id="daily-chart"></canvas>
                            </div>
                        </div>
                    </div><!-- /.portlet-body -->
                </div><!-- /.portlet -->
            </div><!-- /.col -->
            <div class="col-md-12 m-t-10">
                <div class="portlet box border shadow">
                    <div class="portlet-heading">
                        <div class="portlet-title">
                            <h3 class="title">
                                <i class="icon-graph"></i>
                                فروش ماهانه
                            </h3>
                        </div><!-- /.portlet-title -->
                        <div class="buttons-box">
                            <a class="btn btn-sm btn-default btn-round btn-fullscreen" rel="tooltip" title="تمام صفحه" href="#">
                                <i class="icon-size-fullscreen"></i>
                            </a>
                            <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                                <i class="icon-arrow-up"></i>
                            </a>
                        </div><!-- /.buttons-box -->
                    </div><!-- /.portlet-heading -->
                    <div class="portlet-body">
                        <div class="row">
                            <div class="col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2">
                                <canvas id="monthly-chart"></canvas>
                            </div>
                        </div>
                    </div><!-- /.portlet-body -->
                </div><!-- /.portlet -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    <?php endif; ?>
</div><!-- /.col-md-12 -->
<script>
    $(document).ready(function () {
        if($(".counter-down").length){
            $(".counter-down").incrementalCounter({digits: "auto"});
        }

        <?php if (in_array('orders', $user_permissions)): ?>
            Chart.defaults.global.defaultFontFamily = "<?= (isset($font->admin) && $font->admin) ? $font->admin : 'IranSansFa' ?>";
            var ctx = document.getElementById("daily-chart").getContext("2d");
            var dailyChartData = {
                labels: [
                    <?php foreach($daily_stats as $stat){echo '"' . substr($stat->date_formatted, 5) . '",';} ?>
                ],
                datasets: [{
                    label: "تعداد سفارشات",
                    type: "line",
                    fill: false,
                    backgroundColor: "rgba(20, 185, 214, 0.8)",
                    yAxisID: "y-axis-1",
                    data: [
                        <?php foreach($daily_stats as $stat){echo $stat->count.',';} ?>
                    ]
                }, {
                    label: "میزان فروش(تومان)",
                    type: "bar",
                    backgroundColor: "rgb(94, 218, 57)",
                    yAxisID: "y-axis-2",
                    data: [
                        <?php foreach($daily_stats as $stat){echo $stat->total.',';} ?>
                    ]
                }]
            };
            new Chart(ctx, {
                type: "bar",
                data: dailyChartData,
                options: {
                    tooltips: {
                        callbacks: {
                            label: function(tooltipItem, data) {
                                return numberFormat(tooltipItem.yLabel);
                            }
                        }
                    },
                    scales: {
                        yAxes: [
                            {
                                type: "linear",
                                display: true,
                                position: "left",
                                id: "y-axis-1",
                                ticks: {
                                    beginAtZero: true,
                                    callback: function(value, index, values) {
                                        return (Math.floor(value) === value) ? numberFormat(value) : '';
                                    }
                                }
                            },
                            {
                                type: "linear",
                                display: true,
                                position: "right",
                                id: "y-axis-2",
                                ticks: {
                                    beginAtZero: true,
                                    precision:0,
                                    callback: function(value, index, values) {
                                        return (Math.floor(value) === value) ? numberFormat(value) : '';
                                    }
                                }
                            },
                        ]
                    }
                }
            });

            var ctx = document.getElementById("monthly-chart").getContext("2d");
            var monthlyChartData = {
                labels: [
                    <?php foreach($monthly_stats as $stat){echo '"' . $stat->date_formatted . '",';} ?>
                ],
                datasets: [{
                    label: "تعداد سفارشات",
                    type: "line",
                    fill: false,
                    backgroundColor: "rgba(20, 185, 214, 0.8)",
                    yAxisID: "y-axis-3",
                    data: [
                        <?php foreach($monthly_stats as $stat){echo $stat->count.',';} ?>
                    ]
                }, {
                    label: "میزان فروش(تومان)",
                    type: "bar",
                    backgroundColor: "rgb(94, 218, 57)",
                    yAxisID: "y-axis-4",
                    data: [
                        <?php foreach($monthly_stats as $stat){echo $stat->total.',';} ?>
                    ]
                }]
            };
            new Chart(ctx, {
                type: "bar",
                data: monthlyChartData,
                options: {
                    tooltips: {
                        callbacks: {
                            label: function(tooltipItem, data) {
                                return numberFormat(tooltipItem.yLabel);
                            }
                        }
                    },
                    scales: {
                        yAxes: [
                            {
                                type: "linear",
                                display: true,
                                position: "left",
                                id: "y-axis-3",
                                ticks: {
                                    beginAtZero: true,
                                    precision:0,
                                    callback: function(value, index, values) {
                                        return (Math.floor(value) === value) ? numberFormat(value) : '';
                                    },
                                }
                            },
                            {
                                type: "linear",
                                display: true,
                                position: "right",
                                id: "y-axis-4",
                                ticks: {
                                    beginAtZero: true,
                                    precision:0,
                                    callback: function(value, index, values) {
                                        return (Math.floor(value) === value) ? numberFormat(value) : '';
                                    }
                                }
                            }
                        ]
                    }
                }
            });
        <?php endif; ?>
    });
</script>
