<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>
<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">   
                    <i class="icon-people"></i>
                    کاربران/ مشتریان
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col col-md-12">
                    <?php if (in_array('customers_add', $user_permissions)) : ?>
                        <a href="<?= base_url('admin/customers/edit') ?>"  class="btn btn-primary has-tooltip btn-round btn-icon" title="جدید">
                            <i class="icon-plus"></i>
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('customers_edit', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/customers/changeStatus/accept'); ?>', '#frm-main', '<?php echo base_url('/admin/customers/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="تایید">
                            <i class="icon-check"></i>                       
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/customers/changeStatus'); ?>', '#frm-main', '<?php echo base_url('/admin/customers/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="عدم تایید">
                            <i class="icon-close"></i>                       
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/customers/unblock'); ?>', '#frm-main', '<?php echo base_url('/admin/customers/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-success has-tooltip btn-round btn-icon" title="بازیابی">
                            <i class="icon-lock-open"></i>                       
                        </a>
                        <a href="javascript:void(0);"  onclick="insert('<?php echo base_url('admin/customers/block'); ?>', '#frm-main', '<?php echo base_url('/admin/customers/view'); ?>', '#res', '#msg', false, true, 'noty')" class="btn btn-danger has-tooltip btn-round btn-icon" title="بلاک کردن">
                            <i class="icon-lock"></i>                       
                        </a>
                    <?php endif; ?>
                    <?php if (in_array('customers_delete', $user_permissions)) : ?>
                        <a href="javascript:void(0);"  onclick="deleteRow('<?php echo base_url('admin/customers/delete'); ?>', '#frm-main', '<?php echo base_url('/admin/customers/view'); ?>', '#res', 'delete', 'post')" class="btn btn-danger has-tooltip btn-round btn-icon" title="حذف">
                            <i class="icon-trash"></i>                       
                        </a>
                    <?php endif; ?>
                </div><!-- col -->
            </div><!-- row -->
            <div class="m-t-10">
                <div id="lbl-ids"></div>
                <form method="post" id="frm-main">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    <input type="hidden" id="txt-ids" name="list_ids">
                </form>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="customer-table">
                    <thead>
                        <tr>
                            <th><input type="checkbox" class="check-all"></th>
                            <th>#</th>
                            <th>نام</th>
                            <th>نام خانوادگی</th>
                            <th>همراه</th>
                            <th>ایمیل</th>
                            <th>کد ملی</th>
                            <th>وضعیت <span  title="وضعیت تایید توسط ادمین" class="has-tooltip"><i class="icon-info"></i></span></th>
                            <td>عملیات</td>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div><!-- /.table-responsive -->
            <div class="alert alert-info">
                <p>مدیر گرامی، وضعیت کاربر توسط شما تعیین می‌شود و ارتباطی با تایید شماره همراه کاربر با پیامک ندارد و مجزا است.</p>
            </div>
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function () {
        var selectedMain = [];
        var tableMain = $('#customer-table').DataTable({
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "pageLength": 25,
            "order": [],
            "columns": [
                {"data": "checkbox", "orderable": false, "class": "width-10 p-10"},
                {"data": "row", "orderable": false , "class": "width-10"},
                {"data": "first_name"},
                {"data": "last_name"},
                {"data": "cell_phone"},
                {"data": "email"},
                {"data": "national_code"},
                {"data": "status"},
                {"data": "actions", "orderable": false}
            ],
            "ajax": {
                "url": "<?php echo base_url('admin/customers/ajax_list') ?>",
                "type": "POST",
                data: function (d) {
                    d.<?= $this->security->get_csrf_token_name() ?> = $("input[name='" + csrfTokenName + "']").val();
                },
                dataSrc: function (json) {
                    if (json.csrf !== undefined)
                        $("input[name='" + csrfTokenName + "']").val(json.csrf);
                    return json.data;
                },
                "complete": function (settings, json) {
                    $(".has-tooltip").tooltip();
                    window.Modiran.initiCkeck();
                    chackAllStatus($('#customer-table'));
                }
            },
            "rowCallback": function(row, data) {
                if ($.inArray(data.id, selectedMain) !== -1) {
                    $(row).addClass('selected');
                    $(row).find("input").attr('checked', true);
                }
            },
            "sPaginationType": "full_numbers",
        });

        // Resize event
        $(window).on('resize', function () {
            $('#customer-table').css("width", "100%");
        });

        // Select checkboxes
        $('#customer-table tbody').on('ifChanged', 'input', function (event) {

            var id = event.target.value;
            //var isChecked = event.target.checked;
            var index = $.inArray(id, selectedMain);
            if (index === -1) {
                selectedMain.push(id);
                $(this).closest("tr").addClass('selected');
            } else {
                selectedMain.splice(index, 1);
                $(this).closest("tr").removeClass('selected');
            }

            if (selectedMain.length == 0) {
                $("#lbl-ids").html("");
            } else {
                $("#lbl-ids").html(selectedMain.length + "مورد انتخاب شده است.");
            }

            $("#txt-ids").val(selectedMain);

            chackAllStatus($('#customer-table'));
        });
    });
</script>
