<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
?>

<!-- BEGIN SIDEBAR -->
<div id="sidebar">
    <div class="sidebar-top">
        <div class="user-box">
            <a href="#">
                <?php
                if (!empty($user_login->image) && file_exists($user_login->image)) {
                    $src = base_url($user_login->image);
                } else {
                    $src = base_url('assets/admin/images/user/avatar128.png');
                }
                ?>
                <img src="<?= $src ?>" alt="عکس پروفایل" class="img-circle img-responsive">
            </a>
            <div class="user-details">
                <h4><?= $user_login->first_name ?></h4>
                <p class="role"><?= $user_login->last_name ?></p>
                <div class="dropdown user-login hide">
                    <button class="btn btn-xs btn-status dropdown-toggle btn-round" type="button" data-toggle="dropdown" data-hover="dropdown">
                        <i class="fa fa-circle text-success"></i>
                        <span>دردسترس</span>
                    </button>
                    <ul class="dropdown-menu dropdown-status">
                        <li>
                            <a href="#" class="busy">
                                <i class="fa fa-circle text-success"></i>
                                <span>دردسترس</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" class="busy">
                                <i class="fa fa-circle text-danger"></i>
                                <span>مشغول</span>
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="fa fa-circle text-gray"></i>
                                <span>مخفی</span>
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="fa fa-circle text-warning"></i>
                                <span>سایر</span>
                            </a>
                        </li>
                    </ul>
                </div><!-- /dropdown -->
            </div><!-- /.user-details -->
        </div><!-- /.user-box -->
    </div><!-- /.sidebar-top -->
    <div class="side-menu-container">
        <ul class="metismenu" id="side-menu">

            <li>
                <a href="<?= base_url('admin') ?>" class="<?php if ($this->uri->segment(2) == 'dashboard') echo 'current'; ?>">
                    <i class="icon-home"></i>
                    <span>پیشخوان</span>
                </a>
            </li>
            <?php if ($user_permissions && (in_array('users', $user_permissions) || in_array('permissions', $user_permissions))): ?>
                <li class="<?php if ($this->uri->segment(2) == 'users' || $this->uri->segment(2) == 'permissions') echo 'open active conditional-bg'; ?>">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="icon-user"></i>
                        <span>مدیریت مدیران</span>
                    </a>
                    <ul>
                        <?php if (in_array('users', $user_permissions)): ?>
                            <li>
                                <a href="<?= base_url('admin/users') ?>" class="<?php if ($this->uri->segment(2) == 'users') echo 'current'; ?>">
                                    <i class="icon-user"></i>
                                    <span>مدیران</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (in_array('permissions', $user_permissions)): ?>
                            <li>
                                <a href="<?= base_url('admin/permissions') ?>" class="<?php if ($this->uri->segment(2) == 'permissions') echo 'current'; ?>">
                                    <i class="icon-shield"></i>
                                    <span>سطوح دسترسی</span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>
            <?php if (in_array('customers', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/customers') ?>" class="<?php if ($this->uri->segment(2) == 'customers') echo 'current'; ?>">
                        <i class="icon-people"></i>
                        <span>کاربران سایت</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('orders', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/orders') ?>" class="<?php if ($this->uri->segment(2) == 'orders') echo 'current'; ?>">
                        <i class="icon-basket-loaded fa-flip-horizontal"></i>
                        <span>سفارشات</span>
                        <span class="badge badge-primary pull-left orders-count <?= $not_reading_order ? '' : 'hidden' ?>" ><?= $not_reading_order ?></span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('tickets', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/tickets') ?>" class="<?php if ($this->uri->segment(2) == 'tickets') echo 'current'; ?>">
                        <i class="icon-cursor"></i>
                        <span>تیکت ها</span>
                        <span class="badge badge-warning pull-left <?php if(!$number_of_message) echo 'hidden'; ?>"><?= $number_of_message ?></span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('transactions', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/transactions') ?>" class="<?php if ($this->uri->segment(2) == 'transactions') echo 'current'; ?>">
                        <i class="icon-wallet"></i>
                        <span>تراکنش ها</span>
                        <span class="badge badge-danger pull-left <?php if(!$number_of_transaction) echo 'hidden'; ?>"><?= $number_of_transaction ?></span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('product_categories', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/tree_categories/index/product') ?>" class="<?php if ($this->uri->segment(2) == 'tree_categories' && $this->uri->segment(4) == 'product') echo 'current'; ?>">
                        <i class="icon-organization"></i>
                        <span>دسته بندی محصولات</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('products', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/products') ?>" class="<?php if ($this->uri->segment(2) == 'products') echo 'current'; ?>">
                        <i class="icon-layers"></i>
                        <span>محصولات</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('cards', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/cards') ?>" class="<?php if ($this->uri->segment(2) == 'cards') echo 'current'; ?>">
                        <i class="icon-credit-card"></i>
                        <span>کارت ها</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('notices', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/notices') ?>" class="<?php if ($this->uri->segment(2) == 'notices') echo 'current'; ?>">
                        <i class="icon-bell"></i>
                        <span>اطلاعیه‌ها</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('coupons', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/coupons') ?>" class="<?php if ($this->uri->segment(2) == 'coupons') echo 'current'; ?>">
                        <i class="icon-present"></i>
                        <span>کوپن تخفیف</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('gifts', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/gifts') ?>" class="<?php if ($this->uri->segment(2) == 'gifts') echo 'current'; ?>">
                        <i class="icon-diamond"></i>
                        <span>کارت هدیه</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('gateways', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/gateways') ?>" class="<?php if ($this->uri->segment(2) == 'gateways') echo 'current'; ?>">
                        <i class="icon-paypal"></i>
                        <span>مدیریت درگاه ها</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('contacts', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/contacts') ?>" class="<?php if ($this->uri->segment(2) == 'contacts') echo 'current'; ?>">
                        <i class="icon-call-in fa-flip-horizontal"></i>
                        <span>تماس با ما</span>
                        <span class="badge badge-primary pull-left contact-count <?= !$new_contact ? 'hidden' : '' ?>" ><?= $new_contact ?></span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('sliders', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/sliders') ?>" class="<?php if ($this->uri->segment(2) == 'sliders') echo 'current'; ?>">
                        <i class="icon-picture"></i>
                        <span>مدیریت اسلایدر</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('pages', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/pages') ?>" class="<?php if ($this->uri->segment(2) == 'pages') echo 'current'; ?>">
                        <i class="icon-doc"></i>
                        <span>مدیریت صفحات</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('faqs', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/faqs') ?>" class="<?php if ($this->uri->segment(2) == 'faqs') echo 'current'; ?>">
                        <i class="icon-question"></i>
                        <span>سوالات متداول</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('menus', $user_permissions)): ?>
                <li class="<?php if ($this->uri->segment(2) == 'menus') echo 'open active conditional-bg'; ?>">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="icon-list fa-flip-horizontal"></i>
                        <span>مدیریت منوها</span>
                    </a>
                    <ul>
                        <?php
                        foreach ($menu_types as $menu_type) {
                            ?>
                            <li>
                                <a href="<?= base_url('admin/menus/type/') . $menu_type->id ?>" class="<?php if ($this->uri->segment(4) == $menu_type->id) echo 'current'; ?>">
                                    <i class="icon-menu"></i>
                                    <span><?= $menu_type->title ?></span>
                                </a>
                            </li>
                            <?php
                        }
                        ?>
                    </ul>
                </li>
            <?php endif; ?>
            <?php if ($access_to_smart_block): ?>
                <li>
                    <a href="<?= base_url('admin/blocks') ?>" class="<?php if ($this->uri->segment(2) == 'blocks') echo 'current'; ?>">
                        <i class="icon-lock"></i>
                        <span>گزارش بلاک هوشمند</span>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (in_array('settings', $user_permissions)): ?>
                <li>
                    <a href="<?= base_url('admin/settings') ?>" class="<?php if ($this->uri->segment(2) == 'settings') echo 'current'; ?>">
                        <i class="icon-settings"></i>
                        <span>تنظیمات</span>
                    </a>
                </li>
            <?php endif; ?>

        </ul><!-- /#side-menu -->
    </div><!-- /.side-menu-container -->
</div><!-- /#sidebar -->
<!-- END SIDEBAR -->
