<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$category->id = intval($category->id);
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">                                        
                    <i class="<?= $category->id == 0 ? 'icon-plus' : 'icon-note' ?>"></i>
                    <?= $category->id == 0 ? 'دسته جدید' : 'ویرایش دسته' ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-6 col-md-offset-3 col-sm-8 col-sm-offset-2 border shadow col-xs-10 col-xs-offset-1 p-b-30">
                    <p class="text-center m-t-40 m-b-40">
                        <i class="icon-organization border border-primary img-circle text-primary font-xxxlg p-20"></i>
                    </p>
                    <hr>
                    <form id="form-data" role="form" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                        <input type="hidden" name="id" value="<?= $category->id ?>"> 
                        <input type="hidden" value="<?= $category->type ?>" name="type">
                        <div class="form-body">
                            <div class="form-group box-image<?= ($category->type == 'video') ? '' : ' hide'; ?>">
                                <label>تصویر <span>(400x300)</span> پیکسل</label>
                                <?php
                                $class_hide = '';
                                if ($category->image != '' && file_exists($category->image)) {
                                    $image = base_url() . $category->image;
                                    $class_hide = 'hide';
                                    ?>
                                    <div class="box-old-image">
                                        <a href="javascript:void(0);" class="btn-danger remove-image" data-url="<?= base_url("admin/categories/removeImage/$category->type/$category->id"); ?>" data-toggle="tooltip" title="حذف تصویر"><i class="icon-trash"></i></a>
                                        <img class="img-responsive img-thumbnail" src="<?= $image ?>">
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="box-new-image <?= $class_hide ?>">
                                    <input type="file" class="form-control ltr" name="image">
                                </div>
                            </div>

                            <div class="form-group">
                                <label>عنوان</label>
                                <input type="text" class="form-control" name="title" value="<?= $category->title_fa ?>">
                            </div>
                            <div class="form-group">
                                <label>وضعیت انتشار</label>
                                <select   class="form-control" name="publish" >
                                    <option value="1" <?php if ($category->publish == '1') echo 'selected'; ?>>انتشار</option>
                                    <option value="0" <?php if ($category->publish == '0') echo 'selected'; ?>>عدم انتشار</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>ترتیب نمایش<span class="text-danger">*</span></label>
                                <input type="number" class="form-control numeric" name="ordering" value="<?= $category->ordering ?>">
                            </div><!-- /.form-group -->
                        </div><!-- /.form-body -->
                        <div class="form-actions">
                            <a href="javascript: void(0)"  class="btn btn-info btn-round" onclick="insert('<?php echo base_url("admin/categories/save/" . $category->type); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert')">
                                <i class="icon-check"></i>
                                ذخیره
                            </a>
                            <a href="<?= base_url("admin/categories/index/$category->type") ?>" class="btn btn-warning btn-round pull-left">
                                <i class="icon-close"></i>
                                بازگشت
                            </a>
                        </div><!-- /.form-actions -->
                    </form>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->
