<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

$card->id = intval($card->id);
if ($card->sold) {
    $action = 'مشاهده اطلاعات کارت خریداری شده';
    $icon = 'credit-card';
} else {
    if ($card->id) {
        $action = 'ویرایش کارت';
        $icon = 'note';
    } else {
        $action = 'کارت جدید';
        $icon = 'plus';
    }
}
?>

<div class="col-md-12">
    <div class="portlet box border shadow">
        <div class="portlet-heading">
            <div class="portlet-title">
                <h3 class="title">                                        
                    <i class="icon-<?= $icon ?>"></i>
                    <?= $action ?>
                </h3>
            </div><!-- /.portlet-title -->
            <div class="buttons-box">
                <a class="btn btn-sm btn-default btn-round btn-collapse" rel="tooltip" title="کوچک کردن" href="#">
                    <i class="icon-arrow-up"></i>
                </a>
            </div><!-- /.buttons-box -->
        </div><!-- /.portlet-heading -->
        <div class="portlet-body">
            <div class="row">
                <div class="col-md-12 p-b-30">
                    <?php
                    if ($products_count) {
                        ?>
                        <form id="form-data" role="form" method="POST">
                            <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                            <input type="hidden" value="<?= $card->id ?>" name="id">
                            <input type="hidden" value="<?= $order_id ?>" name="order_id">

                            <div class="form-body">
                                <div class="row">   
                                    <div class="col-sm-6">                                
                                        <div class="form-group">
                                            <label>انتخاب دسته محصول <span class="text-danger">*</span></label>
                                            <select class="form-control select2" id="category_id" data-placeholder="انتخاب دسته" <?= ($card->sold)?'disabled':'' ?>>
                                                <option value=""></option> 
                                                <?php
                                                if ($categories) {
                                                    foreach ($categories as $category) {
                                                        $selected = '';
                                                        if (isset($category_id) && $category_id == $category->id) {
                                                            $selected = ' selected';
                                                            $field1 = $category->field1_title;
                                                            $field2 = $category->field2_title;
                                                            $field3 = $category->field3_title;
                                                        }
                                                        ?>

                                                        <option value="<?= $category->id ?>" data-feild1="<?= $category->field1_title ?>" data-feild2="<?= $category->field2_title ?>"  data-feild3="<?= $category->field3_title ?>"   <?= $selected ?>  ><?= $category->title_fa ?></option>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->
                                    <div class="col-sm-6">                                
                                        <div class="form-group">
                                            <label>محصول <span class="text-danger">*</span></label>
                                            <select  class="form-control select2" name="product_id" data-placeholder="انتخاب محصول" <?= ($card->sold)?'disabled':'' ?>>
                                                <?php
                                                if (isset($products) && $products) {
                                                    foreach ($products as $product) {
                                                        $selected = ($card->product_id == $product->id) ? ' selected' : '';
                                                        ?>
                                                        <option value="<?= $product->id ?>" <?= $selected ?>><?= $product->title ?></option>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->

                                    <div class="col-sm-12" id="field1"  <?= ((isset($field1) && $field1 != null) ? '' : 'style="display:none"' ) ?>>                                
                                        <div class="form-group">
                                            <label><?= ((isset($field1) && $field1 != null) ? $field1 : '') ?><span></span><small class="text-danger">  (بیشتر از  3 کاراکتر)</small></label>
                                            <input type="text" class="form-control ltr" name="code" value="<?= $card->code ?>">
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->

                                    <div class="col-sm-12" id="field2" <?= ((isset($field2) && $field2 != null) ? '' : 'style="display:none"' ) ?>>                                
                                        <div class="form-group">
                                            <label><?= ((isset($field2) && $field2 != null) ? $field2 : '') ?><span></span><small class="text-danger"> (بیشتر از  3 کاراکتر)</small></label>
                                            <input type="text" class="form-control ltr" name="code2" value="<?= $card->code2 ?>">
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->

                                    <div class="col-sm-12" id="field3" <?= ((isset($field3) && $field3 != null) ? '' : 'style="display:none"' ) ?>>                                
                                        <div class="form-group">
                                            <label><?= ((isset($field3) && $field3 != null) ? $field3 : '') ?><span></span><small class="text-danger"> (بیشتر از  3 کاراکتر)</small></label>
                                            <input type="text" class="form-control ltr" name="code3" value="<?= $card->code3 ?>">
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->
                                    
                                    <div class="col-sm-12">
                                        <div class="form-group box-image">
                                            <label>فایل <span class="font-sm">(بعد از خرید کارت در اختیار مشتری قرار می گیرد.)</span></label>
                                            <?php
                                            $class_hide = '';
                                            if ($card->file != '' && file_exists($card->file)) {
                                                $file = base_url() . $card->file;
                                                $class_hide = 'hide';
                                            ?>
                                                <div class="box-old-image">
                                                    <a href="javascript:void(0);" class="btn-danger remove-image" data-type="file" data-url="<?= base_url("admin/cards/removeFile/$card->id"); ?>" data-type="file" data-toggle="tooltip" title="حذف فایل"><i class="icon-trash"></i></a>
                                                    <div class="alert alert-info">
                                                        <p dir="ltr">
                                                            <?= $file ?>
                                                            <button class="btn btn-success" type="button" onclick="window.location.href='<?= base_url('admin/cards/download/'.$card->id) ?>'">
                                                                دانلود
                                                            </button>
                                                        </p>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                            <div class="box-new-image <?= $class_hide ?>">
                                                <input type="file" class="form-control ltr" name="file">
                                            </div>
                                        </div>
                                    </div><!-- /.col -->
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label>سایر اطلاعاتی که می‌خواهید با کاربر نمایش دهید</label>
                                            <textarea class="form-control summernote" name="information"><?= htmlspecialchars($card->information) ?></textarea>
                                        </div>
                                    </div><!-- /.col -->

                                    <div class="clearfix"></div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>وضعیت انتشار</label>
                                            <select  class="form-control" name="publish" <?= ($card->sold)?'disabled':'' ?>>
                                                <option value="1" <?php if ($card->publish == 1) echo 'selected'; ?> >انتشار</option>
                                                <option value="0" <?php if ($card->publish == 0) echo 'selected'; ?>>عدم انتشار</option>
                                            </select>
                                        </div><!-- /.form-group -->
                                    </div><!-- /.col -->
                                </div><!-- /.row -->
                            </div><!-- /.form-body -->
                            <div class="form-actions">
                                <a class="btn btn-info btn-round btn-save">
                                    <i class="icon-check"></i>
                                    ذخیره
                                </a>
                                <?php if ($card->sold): ?>
                                    <a class="btn btn-success btn-round" href="<?= base_url('admin/orders/detail/'.$card->order_id) ?>">
                                        <i class="icon-info"></i>
                                        مشاهده فاکتور
                                    </a>
                                <?php endif; ?>
                                    
                                <a href="<?= ($order_id) ? base_url("admin/orders/detail/$order_id#cards-box") :  base_url('admin/cards') ?>" class="btn btn-warning btn-round pull-left">
                                    <i class="icon-close"></i>
                                    بازگشت
                                </a>
                            </div><!-- /.form-actions -->
                        </form>
                        <?php
                    } else {
                        ?>
                        <div class="alert alert-info b-t-20">
                            تا کنون هیچ محصولی ثبت نشده است، بنابراین امکان تعریف کارت وجود ندارد. برای تعریف محصول از دکمه زیر استفاده کنید.
                        </div>
                        <a class="btn btn-info btn-round" href="<?= base_url() . 'admin/products/edit/' ?>">افزودن محصول</a>
                        <?php
                    }
                    ?>

                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.portlet-body -->
    </div><!-- /.portlet -->
</div><!-- /.col-md-12 -->

<script>
    $(document).ready(function () {
        $(".select2").select2({rtl: true})

        $(".btn-save").click(function (e) {
            e.preventDefault();
            insert('<?php echo base_url('admin/cards/save'); ?>', '#form-data', '', '', '#msg', false, true, 'sweetalert');
        });

        $("#category_id").change(function () {

            var id = this.value;
            var titleField1 = $(this).find(':selected').attr('data-feild1');
            var titleField2 = $(this).find(':selected').attr('data-feild2');
            var titleField3 = $(this).find(':selected').attr('data-feild3');

            if (titleField1 !== '') {
                $('#field1').show();
                $("#field1 label span").html(titleField1);
            } else
                $('#field1').hide();

            if (titleField2 !== '') {
                $('#field2').show();
                $("#field2 label span").html(titleField2);
            } else
                $('#field2').hide();

            if (titleField3 !== '') {
                $('#field3').show();
                $("#field3 label span").html(titleField3);
            } else
                $('#field3').hide();

            $.ajax({
                url: "<?php echo base_url('admin/cards/getProducts/'); ?>" + id,
                type: "GET",
                success: function (data) {
                    $("select[name='product_id']").html(data);
                },

            });
        });

        $(".summernote").summernote({
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                // ['fontname', ['fontname']],
                ['color', ['color']],
                // ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']],
                // ['table', ['table']],
                // ['insert', ['link', 'picture', 'hr']],
                ['insert', ['link', 'hr']],
                ['view', ['fullscreen', 'codeview']],
                ['help', ['help']]
            ],
        });
    });
</script>
