<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Users_m extends MY_Model {

    public $_table_name = 'users';
    public $_order_by = 'id desc';
    public $_primary_key = 'id';
    public $_timestamps = true;

    // Begin users list ajax
    public $_table_ajax = 'users';
    var $column_order = array(null, null, 'first_name', 'last_name', 'username', 'email', 'national_code', 'status', null); //set column field database for datatable orderable
    var $column_search = array('first_name', 'last_name', 'username', 'email', 'national_code'); //set column field database for datatable searchable
    var $columns_search = array(); //set column field database for datatable searchable
    var $filter = array('type' => 'customer', 'deleted' => '0'); // default filter
    var $order = array('id' => 'desc'); // default order
    // End users list ajax

    public function hash($string) {
        return hash('sha512', $string . config_item('encryption_key'));
    }

    public function getNew() {
        $user = new stdClass();
        $user->id = 0;
        $user->first_name = '';
        $user->last_name = '';
        $user->username = '';
        $user->store_name = '';
        $user->email = '';
        $user->type = '';
        $user->cell_phone = '';
        $user->iran_code = '';
        $user->image = '';
        $user->role_id = 0;
        $user->activation = '';
        $user->commission = '';
        $user->province_id = '';
        $user->city_id = '';
        $user->address = '';
        $user->postal_code = '';
        $user->customer_type = '';
        $user->iban = '';
        $user->card = '';
        $user->block = '';
        $user->national_code = '';
        $user->status = '';
        $user->matched_fields = '';
        $user->birth_date = '';
        $user->father_name = '';
        $user->auth_call = '';
        return $user;
    }

    public function login($username) {

        $user = $this->get_by('', array(
            'username' => $username,
            'activation' => 1,
            'deleted' => 0
                ), TRUE);

        return $user;
    }

    // Get all user permissions
    public function userAllPermission() {
        $user_id = $this->user_login->id;
        $this->db->select('roles.permissions');
        $this->db->from('users');
        $this->db->join('roles', 'roles.id=users.role_id');
        $this->db->where('users.id', $user_id);
        $query = $this->db->get();
        return $query->row();
    }

    public function getCredit($user_id){
        $this->db->select("SUM(amount) AS credit");
        $this->db->from('transactions');
        $this->db->where('user_id', $user_id);
        $this->db->where('completed', 1);
        return $this->db->get()->row()->credit * 1;
    }
}
