<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Transactions_m extends MY_Model {

    public $_table_name = 'transactions';
    public $_order_by = 'id DESC';
    public $_primary_key = 'id';
    public $_timestamps = true;
    public $_filter=array();


    //BEGIN transaction list ajax
    public $_table_ajax = 'transactions_view';
    var $column_order = array(null, 'tracking_code', 'cell_phone', 'amount', 'type', 'gateway' , 'created', null); //set column field database for datatable orderable
    var $column_search  = array('tracking_code', 'cell_phone', 'amount', 'reference'); //set column field database for datatable searchable
    var $columns_search = array('tracking_code', 'cell_phone', 'amount', 'reference', 'type', 'gateway', 'created'); //set column field database for datatable searchable
    var $filter = array(); // default filter
    var $order = array('id' => 'DESC'); // default order
    //END transaction list ajax

    public function getNew() {
        $transaction = new stdClass();

        $transaction->id = '0';
        $transaction->user_id = '';
        $transaction->amount = '';
        $transaction->description = '';
        $transaction->detail = '';
        $transaction->gateway = '';

        return $transaction;
    }

    //لیست تراکنش ها یک کاربر
    function getUserTransactions($user_id, $offset, $limit, $get_count = false){
        $prefix = $this->db->dbprefix;

        $where = "transactions.user_id = '$user_id' AND (transactions.completed = 1 OR transactions.gateway ='card2card')";
        if($get_count){
            $this->db->select("COUNT({$prefix}transactions.id) AS number");
            $this->db->from('transactions');
            $this->db->where($where);
        }else{
            $this->db->select('transactions.*');
            $this->db->select('orders.tracking_code');
            $this->db->from('transactions');
            $this->db->join('users', "transactions.user_id = users.id AND $where");
            $this->db->join('orders', "transactions.order_id = orders.id", 'left');
            $this->db->limit($limit, $offset);
            $this->db->order_by('transactions.id DESC');
        }

        $query = $this->db->get();

        if($get_count){
            return $query->row()->number;
        }else{
            return $query->result();
        }
    }

    // $transaction => وقتی این وجود داشت یعنی برگشت از درگاه بوده
    public function payOrderWithWallet($order_id, $user_login = null, $transaction = null, $card2card_info = null){
        $prefix = $this->db->dbprefix;
        $new_credit = null;

        $this->db->trans_begin();

        // قفل‌گذاری روی سفارش
        $order = $this->db->query(
            "SELECT * FROM {$prefix}orders 
            WHERE id = ? AND paid = 0
            FOR UPDATE",
            [$order_id]
        )->row();

        if (!$order) {
            $this->db->trans_rollback();
            return (object)['success' => false, 'error' => 'سفارش یافت نشد.'];
        }

        if ($transaction && ($transaction->order_id != $order->id || ($user_login && $transaction->user_id != $user_login->id))) {
            $this->db->trans_rollback();
            return (object)['success' => false, 'error' => 'تراکنش معتبر نیست.'];
        }

        $transaction_amount = $order->price * 1;

        if($transaction_amount > 0){
            
            // Get current credit
            if($user_login && $order->user_id == $user_login->id){
                // قفل‌گذاری روی موجودی کیف پول
                $credit_row = $this->db->query(
                    "SELECT SUM(amount) AS credit 
                    FROM {$prefix}transactions 
                    WHERE user_id = ? AND completed = 1 
                    FOR UPDATE",
                    [$order->user_id]
                )->row();
    
                $credit = $credit_row ? $credit_row->credit * 1 : 0;
            } elseif($transaction){
                $credit = $transaction->amount;
            } else {
                $credit = 0;
            }

            if($card2card_info){
                if($transaction_amount != $card2card_info->use_wallet_amount + $card2card_info->amount){
                    $this->db->trans_rollback();
                    return (object)['success' => false, 'error' => 'مبلغ کارت به کارت صحیحی نیست.'];
                }

                //کارت به کارت هست پس ممکن است بخشی از کیف پول باشد
                $transaction_amount = $card2card_info->use_wallet_amount;
            }

            if($transaction_amount){
                if ($credit < $transaction_amount) {
                    $this->db->trans_rollback();
                    return (object)['success' => false, 'not_enough_credit' => true, 'error' => 'موجودی شما برای پرداخت  فاکتور کافی نبود.'];
                }
        
                // ثبت تراکنش منفی
                $this->db->insert("{$prefix}transactions", [
                    'user_id'   => $order->user_id,
                    'order_id'  => $order->id,
                    'type'      => 'order_payment',
                    'amount'    => $transaction_amount * -1,
                    'completed' => 1,
                    'created'   => date('Y-m-d H:i:s'),
                ]);
            }
            
            if($card2card_info && $card2card_info->amount){
                // ثبت اطلاعات کارت به کارت
                $this->db->insert("{$prefix}transactions", [
                    'user_id' => $order->user_id,
                    'order_id' => $order->id,
                    'amount' => $card2card_info->amount,
                    'gateway' => 'card2card',
                    'type' => 'credit_increase',
                    'completed' => 0,
                    'reference' => $card2card_info->reference,
                    'detail' => $card2card_info->detail,
                    'created'   => date('Y-m-d H:i:s'),
                ]);
            }


            if($user_login){
                $new_credit = $credit - $transaction_amount;
            }
        }

        if(!$card2card_info){
            // علامت‌گذاری سفارش به عنوان پرداخت شده
            $this->db->where('id', $order->id)->update("{$prefix}orders", ['paid' => 1]);
        }

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return (object)['success' => false, 'error' => 'خطای سیستمی در پرداخت سفارش.'];
        }

        $this->db->trans_commit();

        if($new_credit !== null){
            return (object)['success' => true, 'new_credit' => $new_credit];
        }

        return (object)['success' => true];
    }

}
