<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settings_m extends MY_Model {

        public $_table_name = 'settings';
        public $_order_by = 'ordering asc';
        public $_primary_key = 'key';
        public $_timestamps = false;
        public $_primary_filter = 'strval';
        
        
        public function getSettings($keys = null) {
                
            $this->db->from('settings');
            if ($keys != NULL)
                $this->db->where_in('key',$keys);
            
            $settings = $this->db->get()->result();
            if($settings){
                foreach ($settings as $key => $setting) {
                    $settings[$setting->key] = $setting->value;
                    unset($settings[$key]);
                }
                foreach ($keys as $key) {
                    if(!isset($settings[$key])){
                        $settings[$key] = '';
                    }
                }
                $settings = json_decode(json_encode($settings));
            }
            return $settings;
        }

        public function getSingle($key){
            $this->db->select('value');
            $this->db->from('settings');
            $this->db->where('key', $key);
            $row = $this->db->get()->row();
            return ($row) ? $row->value : '';
        }

}