<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_auth_calls_table extends CI_Migration {

    public function up()
    {
       
        $this->dbforge->add_field(array(
            'id' => array(
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => TRUE,
                'auto_increment' => TRUE
            ),
            'user_id' => array(
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => TRUE,
            ),
            'code' => array(
                'type'       => 'INT',
                'constraint' => 6,
            ),
            'used' => array(
                'type'       => 'TINYINT',
                'constraint' => 1,
                'default'    => 0,
            ),
            'created' => array(
                'type' => 'DATETIME',
            ),
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('auth_calls');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}auth_calls ADD INDEX idx_user_used_created (user_id, used, created);");
    }

    public function down()
    {
        $this->dbforge->drop_table('auth_calls');
    }
}