<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_blocks_table extends CI_Migration
{
    public function up()
    {
        $this->dbforge->add_field([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => TRUE,
                'auto_increment' => TRUE,
            ],
            'user_id' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
            'origin_user_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => TRUE,
                'null'       => TRUE,
                'comment'    => 'کاربری که مسبب اصلی بوده'
            ],
            'email' => [
                'type'       => 'VARCHAR',
                'constraint' => 191,
                'null'       => TRUE,
            ],
            'source' => [
                'type'       => 'VARCHAR',
                'constraint' => 31,
                'comment'    => 'order | profile | admin | user',
            ],
            'ip' => [
                'type'       => 'VARCHAR',
                'constraint' => 45,
                'null'       => TRUE,
            ],
            'created' => [
                'type' => 'DATETIME',
            ],
        ]);

        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('blocks', TRUE);
    }

    public function down()
    {
        $this->dbforge->drop_table('blocks', TRUE);
    }
}
