<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_dollar_to_transactions_table extends CI_Migration
{

    public function up()
    {
        $prefix = $this->db->dbprefix;

        // Apply to table
        if (!$this->db->field_exists('dollar_rate', 'transactions')){
            $fields = [
                'amount_dollar' => [
                    'type'  => 'DECIMAL(11,3)',
                    'after' => 'amount',
                    'null'  => TRUE,
                ],
                'dollar_rate' => [
                    'type'  => 'INT',
                    'after' => 'amount_dollar',
                    'null'  => TRUE,
                ],
            ];
            $this->dbforge->add_column('transactions', $fields);
        }

        // Aplly to view
        $this->db->query("DROP VIEW IF EXISTS `{$prefix}transactions_view`");
        $this->db->query("
            CREATE VIEW `{$prefix}transactions_view` AS 
            SELECT {$prefix}transactions.id AS id,{$prefix}transactions.order_id AS order_id,{$prefix}transactions.gateway AS gateway,{$prefix}transactions.type AS type,{$prefix}transactions.amount AS amount,{$prefix}transactions.reference AS reference,{$prefix}transactions.created AS created,{$prefix}transactions.completed AS completed,{$prefix}transactions.reject AS reject, {$prefix}transactions.amount_dollar, {$prefix}transactions.dollar_rate,{$prefix}users.cell_phone AS cell_phone,{$prefix}orders.tracking_code AS tracking_code 
            FROM {$prefix}transactions 
            JOIN {$prefix}users ON ({$prefix}transactions.user_id = {$prefix}users.id) and ({$prefix}transactions.completed = 1 OR {$prefix}transactions.gateway = 'card2card')
            LEFT JOIN {$prefix}orders ON {$prefix}transactions.order_id = {$prefix}orders.id
        ");
    }

    public function down()
    {
        $prefix = $this->db->dbprefix;

        // Aplly to view
        $this->db->query("DROP VIEW IF EXISTS `{$prefix}transactions_view`");
        $this->db->query("
            CREATE VIEW `{$prefix}transactions_view` AS 
            SELECT {$prefix}transactions.id AS id,{$prefix}transactions.order_id AS order_id,{$prefix}transactions.gateway AS gateway,{$prefix}transactions.type AS type,{$prefix}transactions.amount AS amount,{$prefix}transactions.reference AS reference,{$prefix}transactions.created AS created,{$prefix}transactions.completed AS completed,{$prefix}transactions.reject AS reject,{$prefix}users.cell_phone AS cell_phone,{$prefix}orders.tracking_code AS tracking_code 
            FROM {$prefix}transactions 
            JOIN {$prefix}users on ({$prefix}transactions.user_id = {$prefix}users.id) AND ({$prefix}transactions.completed = 1 OR {$prefix}transactions.gateway = 'card2card') 
            LEFT JOIN {$prefix}orders on {$prefix}transactions.order_id = {$prefix}orders.id
        ");

        // Apply to table
        if ($this->db->field_exists('amount_dollar', 'transactions')){
            $this->dbforge->drop_column('transactions', 'amount_dollar');
        }
        if ($this->db->field_exists('dollar_rate', 'transactions')){
            $this->dbforge->drop_column('transactions', 'dollar_rate');
        }
    }
}