<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Insert_to_slider_items extends CI_Migration
{

    public function up()
    {
        $this->load->model('sliders_m');
        $this->load->model('slider_items_m');
        $this->load->model('pages_m');

        $sliders = $this->sliders_m->get_by('id');
        if($sliders){
            // Pages
            $pages = $this->pages_m->get_by('id');

            $data_insert = [];

            foreach ($sliders as $slide) {
                // Statics
                foreach (['home_page', 'contact_us', 'faqs'] as $page) {
                    $data_insert[] = [
                        'slider_id' => $slide->id,
                        'type' => $page,
                        'item_id' => 0,
                    ];
                }

                // Pages
                if($pages){
                    foreach ($pages as $page) {
                        $data_insert[] = [
                            'slider_id' => $slide->id,
                            'type' => 'page',
                            'item_id' => $page->id,
                        ];
                    }
                }
                
            }

            $this->slider_items_m->insert_batch($data_insert);
        }
    }

    public function down()
    {
        $this->db->truncate('slider_items');
    }
}
