<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_fields_to_categories extends CI_Migration
{

    public function up()
    {
        if (!$this->db->field_exists('fields', 'categories')){
            $fields = [
                'fields' => [
                    'type' => 'JSON',
                    'after' => 'large_image',
                    'default' => '',
                    'comment' => 'فیلد های ثبت سفارش',
                ],
            ];
            $this->dbforge->add_column('categories', $fields);

            // به دست آوردن وضعیت ایمیل از قبل
            $this->load->model('settings_m');
            $process_checkbox = $this->settings_m->getSingle('process_checkbox');
            $required = ($process_checkbox == 'email' || $process_checkbox == 'email&cellphone') ? 1 : 0;

            // اضافه کردن ایمیل برای دسته بندی  محصولات
            $this->load->model('categories_m');
            $fields = json_encode([
                (object)['statics_key' => 'email', 'title' => 'ایمیل', 'use' => 1, 'required' => $required, 'ltr' => 1, 'ordering' => '1' ],
            ]);
            $this->categories_m->update_by(['fields' => $fields], ['type' => 'product', 'deleted' => 0]);
        }
    }

    public function down()
    {
        if ($this->db->field_exists('fields', 'categories')){
            $this->dbforge->drop_column('categories', 'fields');
        }
    }
}
