<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_slug_field_to_products extends CI_Migration
{

    public function up()
    {
        if (!$this->db->field_exists('slug', 'products')){
            $fields = array(
                'slug' => array(
                    'type' => 'VARCHAR',
                    'constraint' => 127,
                    'after' => 'title',
                    'default' => '',
                ),
            );
            $this->dbforge->add_column('products', $fields);
            $this->db->query("ALTER TABLE {$this->db->dbprefix}products ADD INDEX(slug);");
        }
    }

    public function down()
    {
        if ($this->db->field_exists('slug', 'products')){
            $this->db->query("ALTER TABLE {$this->db->dbprefix}products DROP INDEX slug;");
            $this->dbforge->drop_column('products', 'slug');
        }
    }
}
