<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Insert_to_transactions_new_from_tranasctions_old extends CI_Migration
{

    public function up()
    {
        $this->load->model('transactions_m');
        $transactions = $this->transactions_m->get_by(null, null, false, 'id ASC');
        if($transactions){
            // به دست آوردن آیدی سفارش های که کارت به کارت بوده اند و رد شده اند
            $reject_card2card_order_ids = [];
            $this->load->model('orders_m');
            $orders = $this->orders_m->get_by('id', ['card2card' => 'reject']);
            if($orders){
                foreach ($orders as $order) {
                    $reject_card2card_order_ids[] = $order->id;
                }
            }

            $data = [];
            foreach ($transactions as $item) {
                $detail = $item->description;
                if($item->gateway == 'card2card'){
                    $detail = json_decode($item->card2card);
                    $detail->description = $item->description;
                    $detail = json_encode($detail, JSON_UNESCAPED_UNICODE);
                }

                $data[] = [
                    'order_id' => $item->order_id,
                    'amount' => $item->amount,
                    'type' => 'credit_increase',
                    'completed' => $item->completed,
                    'reject' => ($item->gateway == 'card2card' && in_array($item->order_id, $reject_card2card_order_ids)) ? 1 : 0,
                    'gateway' => $item->gateway,
                    'reference' => $item->reference,
                    'authority' => $item->authority,
                    'description' => '',
                    'detail' => $detail,
                    'created' => $item->created,
                ];
                
                // تراکنش منفی
                if($item->completed){
                    $data[] = [
                        'order_id' => $item->order_id,
                        'amount' => $item->amount * -1,
                        'type' => 'order_payment',
                        'completed' => 1,
                        'reject' => 0,
                        'gateway' => '',
                        'reference' => '',
                        'authority' => '',
                        'description' => '',
                        'detail' => '',
                        'created' => $item->created,
                    ];
                }
            }

            $this->transactions_m->_table_name = 'transactions_new';

            $this->db->trans_start();
            foreach (array_chunk($data, 100) as $sub_data) {
                $this->transactions_m->insert_batch($sub_data);
            }
            $this->db->trans_complete();
        }
    }

    public function down()
    {
        $this->db->truncate('transactions_new');
    }
}
