<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Insert_and_update_data_related_permissions extends CI_Migration
{

    public function up()
    {
        $this->load->model('permissions_m');
        $ordering = 1;
        $this->permissions_m->insert_batch([
            ['en' => 'permissions', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'سطوح دسترسی'],
            ['en' => 'permissions_add', 'parent' => 'permissions', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'permissions_edit', 'parent' => 'permissions', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'permissions_delete', 'parent' => 'permissions', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'users', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'مدیران'],
            ['en' => 'users_add', 'parent' => 'users', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'users_edit', 'parent' => 'users', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'users_delete', 'parent' => 'users', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'customers', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'کاربران سایت'],
            ['en' => 'customers_add', 'parent' => 'customers', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'customers_edit', 'parent' => 'customers', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'customers_delete', 'parent' => 'customers', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'orders', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'سفارشات'],
            ['en' => 'orders_delete', 'parent' => 'orders', 'ordering' => 1, 'fa' => 'حذف'],
            ['en' => 'orders_edit', 'parent' => 'orders', 'ordering' => 2, 'fa' => 'ویرایش وضعیت'],
            ['en' => 'orders_email', 'parent' => 'orders', 'ordering' => 3, 'fa' => 'دانلود ایمیل‌ها'],
            ['en' => 'orders_phone', 'parent' => 'orders', 'ordering' => 4, 'fa' => 'دانلود شماره همراه‌ها'],

            ['en' => 'tickets', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'پشتیبانی'],
            ['en' => 'tickets_add', 'parent' => 'tickets', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'tickets_edit', 'parent' => 'tickets', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'tickets_delete', 'parent' => 'tickets', 'ordering' => 3, 'fa' => 'حذف'],
            ['en' => 'messages', 'parent' => 'tickets', 'ordering' => 4, 'fa' => 'پیام ها'],
            ['en' => 'messages_add', 'parent' => 'messages', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'messages_edit', 'parent' => 'messages', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'messages_delete', 'parent' => 'messages', 'ordering' => 3, 'fa' => 'حذف'],
            ['en' => 'ticket_categories', 'parent' => 'tickets', 'ordering' => 5, 'fa' => 'دسته بندی'],
            ['en' => 'ticket_categories_add', 'parent' => 'ticket_categories', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'ticket_categories_edit', 'parent' => 'ticket_categories', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'ticket_categories_delete', 'parent' => 'ticket_categories', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'transactions', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'تراکنش ها'],

            ['en' => 'products', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'محصولات'],
            ['en' => 'products_add', 'parent' => 'products', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'products_edit', 'parent' => 'products', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'products_delete', 'parent' => 'products', 'ordering' => 3, 'fa' => 'حذف'],
            ['en' => 'product_categories', 'parent' => 'products', 'ordering' => 4, 'fa' => 'دسته بندی'],
            ['en' => 'product_categories_add', 'parent' => 'product_categories', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'product_categories_edit', 'parent' => 'product_categories', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'product_categories_delete', 'parent' => 'product_categories', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'cards', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'کارت ها'],
            ['en' => 'cards_add', 'parent' => 'cards', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'cards_edit', 'parent' => 'cards', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'cards_delete', 'parent' => 'cards', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'coupons', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'کوپن تخفیف'],
            ['en' => 'coupons_add', 'parent' => 'coupons', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'coupons_edit', 'parent' => 'coupons', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'coupons_delete', 'parent' => 'coupons', 'ordering' => 3, 'fa' => 'حذف'],
            
            ['en' => 'gateways', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'درگاه ها'],
            ['en' => 'gateways_edit', 'parent' => 'gateways', 'ordering' => 1, 'fa' => 'ویرایش'],

            ['en' => 'contacts', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'تماس با ما'],
            ['en' => 'contacts_edit', 'parent' => 'contacts', 'ordering' => 1, 'fa' => 'ویرایش(پاسخ)'],
            ['en' => 'contacts_delete', 'parent' => 'contacts', 'ordering' => 2, 'fa' => 'حذف'],
            ['en' => 'contact_categories', 'parent' => 'contacts', 'ordering' => 3, 'fa' => 'موضوعات'],
            ['en' => 'contact_categories_add', 'parent' => 'contact_categories', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'contact_categories_edit', 'parent' => 'contact_categories', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'contact_categories_delete', 'parent' => 'contact_categories', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'sliders', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'اسلایدر'],
            ['en' => 'sliders_add', 'parent' => 'sliders', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'sliders_edit', 'parent' => 'sliders', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'sliders_delete', 'parent' => 'sliders', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'pages', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'مدیریت صفحات'],
            ['en' => 'pages_add', 'parent' => 'pages', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'pages_edit', 'parent' => 'pages', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'pages_delete', 'parent' => 'pages', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'faqs', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'سوالات متداول'],
            ['en' => 'faqs_add', 'parent' => 'faqs', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'faqs_edit', 'parent' => 'faqs', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'faqs_delete', 'parent' => 'faqs', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'menus', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'مدیریت منو'],
            ['en' => 'menus_add', 'parent' => 'menus', 'ordering' => 1, 'fa' => 'جدید'],
            ['en' => 'menus_edit', 'parent' => 'menus', 'ordering' => 2, 'fa' => 'ویرایش'],
            ['en' => 'menus_delete', 'parent' => 'menus', 'ordering' => 3, 'fa' => 'حذف'],

            ['en' => 'settings', 'parent' => '', 'ordering' => $ordering++, 'fa' => 'تنظیمات'],
        ]);

        // Create Role
        $this->load->model('roles_m');
        $permission = $this->permissions_m->get_by('en', ['publish' => 1]);
        $permission_items = array_map(function($item){
            return $item->en;
        }, $permission);
        $role_id = $this->roles_m->save([
            'title' => 'مدیر کل',
            'default' => 0,
            'for_user' => 'admin',
            'permissions' => json_encode($permission_items),
        ]);
        $this->roles_m->save([
            'title' => 'منشی',
            'default' => 1,
            'for_user' => 'admin',
            'permissions' => json_encode([]),
        ]);

        // Relation user with role
        $this->load->model('users_m');
        $this->users_m->update_by(['role_id' => $role_id], ['type' => 'admin']);

    }

    public function down()
    {
        // Truncate permissions
        $this->db->truncate('permissions');

        // Truncate roles
        $this->db->truncate('roles');

        // Cancel relation user with role
        $this->load->model('users_m');
        $this->users_m->update_by(['role_id' => 0], ['type' => 'admin']);

    }
}
