<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_roles extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'title' => array(
                'type' => 'VARCHAR',
                'constraint' => 127,
            ),
            'default' => array(
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ),
            'permissions' => array(
                'type' => 'TEXT',
                'default' => '',
            ),
            'for_user' => array(
                'type' => 'VARCHAR',
                'constraint' => 32,
                'default' => 'admin'
            ),
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('roles');
    }

    public function down()
    {
        $this->dbforge->drop_table('roles');
    }
}
