<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_currency_field_to_order_cards extends CI_Migration
{

    public function up()
    {
        $fields = array(
            'currency_sell_price' => array(
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'after' => 'price',
            ),
            'currency_rate' => array(
                'type' => 'INT',
                'constraint' => '11',
                'after' => 'currency_sell_price',
            ),
            'currency' => array(
                'type' => 'VARCHAR',
                'constraint' => '15',
                'after' => 'currency_rate',
            ),
        );
        $this->dbforge->add_column('order_cards', $fields);
    }

    public function down()
    {
        $this->dbforge->drop_column('order_cards', 'currency_sell_price');
        $this->dbforge->drop_column('order_cards', 'currency_rate');
        $this->dbforge->drop_column('order_cards', 'currency');
    }
}
