<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Add_login_cookies extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'BIGINT',
                'constraint' => 20,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'user_session' => array(
                'type' => 'VARCHAR',
                'constraint' => 128,
            ),
            'username' => array(
                'type' => 'VARCHAR',
                'constraint' => 128,
            ),
            'token' => array(
                'type' => 'VARCHAR',
                'constraint' => 128,
            ),
            'updated' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
            'created' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
            ),
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('login_cookies');

        $this->db->query("ALTER TABLE {$this->db->dbprefix}login_cookies ADD INDEX(user_session);");
        $this->db->query("ALTER TABLE {$this->db->dbprefix}login_cookies ADD INDEX(username);");
    }

    public function down()
    {
        $this->dbforge->drop_table('login_cookies');
    }
}
