<?php
/**
 * @author Rayanik.com
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Zohal
{
    private $error_message;
    private $matched;
    private $response_data;

    public function getErrorMessage()
    {
        return $this->error_message;
    }

    public function isMatched()
    {
        return $this->matched;
    }

    public function getData(){
        return $this->response_data;
    }

    private function getError($response){
        
        if(isset($response->message)){
            return $response->message;
        }

        if(isset($response->response_body->message) && $response->response_body->message){
            return $response->response_body->message;
        }

        if (isset($response->result)) {
            switch ($response->result) {
                case '4':
                    $error_message = 'توکن غیر فعال شده است.';
                    break;
                case '5':
                    $error_message = 'سرویس استعلام در دسترس نمی‌باشد.';
                    break;
                case '6':
                    $error_message = 'فراخوانی وب‌سرویس با پارامتر‌های ورودی صحیح نمی‌باشد.';
                    break;
                default:
                    $error_message = "کد خطا: $response->result";
            }
            return $error_message;
        }

        

        return 'خطا در استعلام';
    }

    private function log($method, $response){
        $time = date('Y-m-d H:i:s');
        $text = "time:$time, method:$method, response:$response \n";
        writeFile($text, 'zohal');
        return true;
    }

    public function shahkar($token, $mobile, $national_code){
        try{

            $post_data = json_encode([
                'mobile' => $mobile,
                'national_code' => $national_code,
            ]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://service.zohal.io/api/v0/services/inquiry/shahkar');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

            $headers = array();
            $headers[] = "Authorization: Bearer $token";;
            $headers[] = 'Content-Type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $response  = curl_exec($ch);
            if (curl_errno($ch)) {
                $this->error_message = curl_error($ch);
                return false;
            }
            curl_close($ch);

            // $this->log('shahkar', $response);

            $response = json_decode($response);

            if (
                isset($response->result) &&
                $response->result == 1 && 
                isset($response->response_body->data->matched)
            ) {
                if($response->response_body->data->matched === true){
                    $this->matched = true;
                    $this->response_data = $response->response_body->data;
                    return true;
                } else {
                    $this->matched = false;
                    $this->error_message = 'کد ملی با شماره همراه تطابق ندارد.';
                }
            } else {
                $this->error_message = $this->getError($response);
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }

    public function nationalIdentityInquiry($token, $national_code, $birth_date){
        try{
            $post_data = json_encode([
                'national_code' => $national_code,
                'birth_date' => $birth_date,
            ]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://service.zohal.io/api/v0/services/inquiry/national_identity_inquiry');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

            $headers = array();
            $headers[] = "Authorization: Bearer $token";;
            $headers[] = 'Content-Type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $response  = curl_exec($ch);
            if (curl_errno($ch)) {
                $this->error_message = curl_error($ch);
                return false;
            }
            curl_close($ch);

            // $this->log('national_identity_inquiry', $response);

            $response = json_decode($response);
            if (
                isset($response->result) &&
                $response->result == 1 && 
                isset($response->response_body->data->matched)
            ) {
                if($response->response_body->data->matched === true){
                    if($response->response_body->data->alive == true){
                        $this->matched = true;
                        $this->response_data = $response->response_body->data;
                        return true;
                    } else {
                        $this->matched = false;
                        $this->error_message = 'این کد ملی در قید حیات نیست.';
                    }
                } else {
                    $this->matched = false;
                    $this->error_message = 'تاریخ تولد با کد ملی مطابقت نداشت.';
                }
            } else {
                $this->error_message = $this->getError($response);
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }

    public function checkCardWithNationalCode($token, $national_code, $birth_date, $card_number){
        try{

            $post_data = json_encode([
                'national_code' => $national_code,
                'birth_date' => $birth_date,
                'card_number' => $card_number,
            ]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://service.zohal.io/api/v0/services/inquiry/check_card_with_national_code');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

            $headers = array();
            $headers[] = "Authorization: Bearer $token";;
            $headers[] = 'Content-Type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $response  = curl_exec($ch);
            if (curl_errno($ch)) {
                $this->error_message = curl_error($ch);
                return false;
            }
            curl_close($ch);

            // $this->log('check_card_with_national_code', $response);

            $response = json_decode($response);

            if (
                isset($response->result) &&
                $response->result == 1 && 
                isset($response->response_body->data->matched)
            ) {
                if($response->response_body->data->matched === true){
                    $this->matched = true;
                    $this->response_data = $response->response_body->data;
                    return true;
                } else {
                    $this->matched = false;
                    $this->error_message = 'کد ملی با شماره کارت بانکی تطابق ندارد.';
                }
            } else {
                $this->error_message = $this->getError($response);
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }
}