<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
 * CodeIgniter Vandar gateway library
 *
 * @author              Rayanik.com
 * https://vandarpay.github.io/docs/ipg/
 */

class Vandar{
    private $authority;
    private $errorMessage;
    private $url;
    private $paid_amount;
    private $transId;
    
    function send($api_key, $amount, $callback_url, $factor_number = '', $cell_phone = '') {
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://ipg.vandar.io/api/v3/send');
            curl_setopt($ch, CURLOPT_POSTFIELDS, "api_key=$api_key&amount=$amount&callback_url=$callback_url&factorNumber=$factor_number&mobile_number=$cell_phone");
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            curl_close($ch);
            
            $result=  json_decode($result);
            
            if ($result->status == 1) {
                $this->authority = $result->token;
                $this->url = "https://ipg.vandar.io/v3/" . $result->token;
                return true;
            } else {
                $this->errorMessage = $result->errors;
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }

    function check($api_key, $token) {
        try{
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://vandar.io/api/ipg/2step/transaction');
            curl_setopt($ch, CURLOPT_POSTFIELDS, "api_key=$api_key&token=$token");
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            curl_close($ch);
            
            $result=  json_decode($result);
            if ($result->status == 1) {
                return $result->amount;
            } else {
                $this->errorMessage = $result->errors;
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }

    function verify($api_key, $token) {
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://ipg.vandar.io/api/v3/verify');
            curl_setopt($ch, CURLOPT_POSTFIELDS, "api_key=$api_key&token=$token");
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            curl_close($ch);
            
            $result=  json_decode($result);
            if ($result->status == 1) {
                $this->paid_amount = $result->amount;
                $this->transId = $result->transId;
                return true;
            } else {
                $this->errorMessage = $result->errors;
                return $result;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }
    
    public function get_authority(){
        return $this->authority;
    }
    
    public function redirect(){
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }
        redirect($this->url);
    }
    
    public function get_error()
    {
        return $this->errorMessage;
    }
    
    public function get_paid_amount()
    {
        return $this->paid_amount;
    }
    public function get_trans_id()
    {
        return $this->transId;
    }
}