<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Smsir {

    private $err;

    public function send_by_token($api_key, $from, $to, $template_id, $token1='', $token2='',$token3='') {
        $params = ['token' => strval($token1)];
        if($token2)  $params['token2'] = strval($token2);
        if($token3)  $params['token3'] = strval($token3);

        // $time = date('Y-m-d H:i:s');
        // $json_pattern_values = json_encode($params, JSON_UNESCAPED_UNICODE);
        // $text = "time:$time, to:$to, patternCode:$patternCode, json_pattern_values:$json_pattern_values \n";
        // writeFile($text, 'sms');
        // return true;

        try {

            $data_params = [];
            foreach ($params as $key => $value){
                $data_params[] = [
                    'name' => $key,
                    'value' => $value
                ];
            }
            $data = array(
                'mobile' => $to,
                'templateId' => $template_id,
                'parameters' => $data_params
            );
            
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Accept: text/plain',
                    "x-api-key: {$api_key}"
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);

            $response = json_decode($response);
            if (isset($response->status)) {
                if ($response->status === 1) {
                    return true;
                } else {
                    // $response->message
                    $this->err =  'کد خطا: ' . $response->status;
                    return false;
                }
            } else {
                $this->err = '';
                return false;
            }

        } catch (\Throwable $th) {
            $this->err = 'کد خطا: ' . $th->getCode();
            return false;
        }
    }

    public function send($api_key, $from, $to, $message) {
        
        // $time = date('Y-m-d H:i:s');
        // $text = "time:$time, to:$to, message:$message \n";
        // writeFile($text, 'sms');
        // return true;

        try {

            $data = array(
                'lineNumber' => $from,
                'messageText' => $message,
                'mobiles' => [$to],
                'sendDateTime' => null
            );

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.sms.ir/v1/send/bulk',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>json_encode($data),
                CURLOPT_HTTPHEADER => array(
                    "x-api-key: {$api_key}",
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);

            $response = json_decode($response);
            if (isset($response->status)) {
                if ($response->status === 1) {
                    return true;
                } else {
                    // $response->message
                    $this->err =  'کد خطا: ' . $response->status;
                    return false;
                }
            } else {
                $this->err = '';
                return false;
            }

    
        } catch (\Throwable $th) {
            $this->err = 'کد خطا: ' . $th->getCode();
            return false;
        }
    }


    public function get_error()
    {
        return strval($this->err);
    }
}