<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
 * CodeIgniter Vandar gateway library
 *
 * @author              Rayanik.com
 * https://www.sepehrpay.com/wp-content/uploads/2021/02/SepehrPay-Gateway-Manual-3.0.0-Token.pdf
 */


class Saderat{
    private $authority;
    private $errorMessage;
    private $url;
    private $paid_amount;
    private $apiKey;

    function send($api_key, $amount, $callback_url, $factor_number = '', $cell_phone = '') {
        try {
            $this->apiKey=$api_key;

            $params ='terminalID='.$api_key.'&Amount='.$amount.'&callbackURL='.$callback_url.'&invoiceID='.$factor_number;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://sepehr.shaparak.ir:8081/V1/PeymentApi/GetToken');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            if($result) {
                $result=json_decode($result);
                if ($result->Status == "0") {
                    $this->authority = $result->Accesstoken;
                    $this->url = "https://sepehr.shaparak.ir:8080";
                    return true;
                } else {
                    $this->errorMessage = (isset($result->message)) ? $result->message : '';
                    return false;
                }
            }else{
                $this->errorMessage = "خطا در اتضال به درگاه";
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }


    function verify($api_key, $digitalreceipt) {
        try {
            $ch = curl_init();
            $params ='digitalreceipt='.$digitalreceipt.'&Tid='.$api_key;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://sepehr.shaparak.ir:8081/V1/PeymentApi/Advice');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $res = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($res,true);
            if ($result['Status'] == 'Ok') {
                return true;
            } else {
                $this->errorMessage = (isset($result["Message"])) ? $result["Message"] : '';
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }
    
    public function get_authority(){
        return $this->authority;
    }
    
    public function redirect(){
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }
        $token=$this->authority;
        echo '<form id="paymentUTLfrm" action="https://sepehr.shaparak.ir:8080" method="POST">
					<input type="hidden" id="TerminalID" name="TerminalID" value="'.$this->apiKey.'">
					<input type="hidden" id="token" name="token" value="'.$token.'">
					<input type="hidden" id="getMethod" name="getMethod" value="0">
					</form><script>
					function submitmabna() {
					document.getElementById("paymentUTLfrm").submit();
					}
					window.onload=submitmabna; </script>';
    }
    
    public function get_error()
    {
        return $this->errorMessage;
    }
    
    // public function get_paid_amount()
    // {
    //     return $this->paid_amount;
    // }
}