<?php
/**
 * @author Rayanik.com
 * PayPing.IR PHP 
 * Docs : https://payping.io/help/fa/prdakht-sadh-drgah-prdakht-aintrnti/
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Payping
{
    private $error;
    private $trans_code;
    private $paid_amount;
    private $paid_data;

    public function get_error()
    {
        return $this->error;
    }

    public function get_trans_code()
    {
        return $this->trans_code;
    }

    public function get_paid_amount()
    {
        return $this->paid_amount;
    }

    public function get_data(){
        return $this->paid_data;
    }
    
	public function redirect()
	{
        header('Location: https://api.payping.ir/v3/pay/start/'.$this->trans_code);
        exit;
	}

	public function request($TokenCode, $amount, $returnUrl, $clientRefId, $payerIdentity = '', $desc = '')
	{   
        $data = array(
            'amount'        => $amount * 1,
            'returnUrl'     => $returnUrl, // callback url
            'payerIdentity' => $payerIdentity, // cell phone or email
            'payerName'     => '',
            'description'   => $desc,
            'clientRefId'   => strval($clientRefId), // transaction_id
            'nationalCode'  => '',
        );

        try{
            $curl = curl_init();
            curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.payping.ir/v3/pay",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 45,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => json_encode($data),
                    CURLOPT_HTTPHEADER => array(
                        "accept: application/json",
                        "authorization: Bearer " . $TokenCode,
                        "cache-control: no-cache",
                        "content-type: application/json"
                    ),
                )
            );
            $response = curl_exec( $curl );
            $header = curl_getinfo( $curl );
            $err = curl_error( $curl );
            curl_close( $curl );
            
            if( $err ){
                $this->error = 'در اتصال به درگاه مشکلی پیش آمد. ';
                $this->error .= 'کد خطا: CURL#' . $err;
            }else{
                if(isset($header['http_code'])){
                    if($header['http_code'] == 200 ){
                        $response = json_decode( $response, true);
                        if (json_last_error() === JSON_ERROR_NONE && isset($response['paymentCode'])) {
                            $this->trans_code = $response['paymentCode'];
                            return true;
                        }else{
                            $this->error = 'خطا: عدم وجود کد ارجاع';
                        }
                    }else{
                        $this->error = $this->code_error($header['http_code'], $response);
                    }
                }
            }
        } catch (\Throwable $th) {
            // $th->getCode()
        }

        return false;
	}

	public function verify($TokenCode, $paymentRefId)
	{   
        $data = array(
            'paymentRefId'  => $paymentRefId
        );

        try{
            
            $curl = curl_init();
            curl_setopt_array( $curl, array(
                CURLOPT_URL => "https://api.payping.ir/v3/pay/verify",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 45,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => array(
                    "accept: application/json",
                    "authorization: Bearer " . $TokenCode,
                    "cache-control: no-cache",
                    "content-type: application/json",
                ),
            ) );
            $response = curl_exec( $curl );
            $err = curl_error( $curl );
            $header = curl_getinfo( $curl );
            curl_close( $curl );

            if($err){
                $this->error = 'خطا در ارتباط به پی‌پینگ :شرح خطا' . $err;
            }else{
                if(isset($header['http_code'])){
                    if($header['http_code'] == 200){
                        $response = json_decode( $response, true );
                        $amount = 0;

                        // برای آن‌های که کارمزد سمت کاربر هست
                        if(isset($response['merchants'][0]['amount'])){
                            $amount = $response['merchants'][0]['amount'];
                        }

                        // برای آن‌های که کارمزد سمت سایت هست
                        else if(isset($response['amount'])){
                            $amount = $response['amount'];
                        }

                        if( 
                            json_last_error() === JSON_ERROR_NONE && 
                            $amount && 
                            isset($response['cardNumber']) 
                            // && isset($response['cardHashPan'])
                        ){
                            $this->paid_amount = $amount;
                            $this->paid_data = json_encode($response);
                            return true;
                        }else{
                            $this->error = 'متاسفانه سامانه قادر به دریافت کد پیگیری نمی‌باشد!';
                        }
                    }else{
                        $this->error = $this->code_error($header['http_code'], $response);
                    }
                }
            }    
        } catch (\Throwable $th) {
            // $th->getCode()
        }
        return false;
	}

    public function code_error($http_code, $response){
        $response = json_decode($response);
        $error_code = (json_last_error() === JSON_ERROR_NONE && isset($response->metaData->code)) ? $response->metaData->code : $http_code;
        $error_code = intval($error_code);

        $error_array = array(
            200 => 'عملیات با موفقیت انجام شد',
            400 => 'مشکلی در ارسال درخواست وجود دارد',
            500 => 'مشکلی در سرور رخ داده است',
            503 => 'سرور در حال حاضر قادر به پاسخگویی نمی‌باشد',
            401 => 'عدم دسترسی',
            403 => 'دسترسی غیر مجاز',
            404 => 'آیتم درخواستی مورد نظر موجود نمی‌باشد',

            101 => "داده های ارسالی نامعتبر است",
            102 => "درگاه پرداخت فعال برای پذیرنده یافت نشد",
            103 => "توکن احراز هویت پذیرنده تایید نشده است",
            104 => "مبلغ برای مشتری آزمایشی معتبر نیست (حالت سندباکس، توکن احراز هویت تست دارای محدودیت در مبالغ پرداخت می‌باشد)",
            105 => "آدرس بازگشت پذیرنده معتبر نمی‌باشد",
            106 => "خطای داخلی سرویس رخ داده است",
            107 => "براساس داده‌های ارسالی قوانین مورد انتظار رعایت نشده است",
            108 => "خطای داخلی سرور رخ داده است",
            109 => "پرداخت در حال بررسی است",
            110 => "پرداخت قبلا انجام شده است",
            
            111 => "حساب کاربری پذیرنده مسدود می‌باشد",
            112 => "سقف تراکنش حساب کاربری تایید نشده به اتمام رسیده است",
            113 => "شماره تلفن همراه معتبر نمی‌باشد",
            114 => "خطای  درگاه بانکی رخ داده است",
            115 => "اطلاعات ارسالی از بانک تکراری می‌باشد",
            116 => "حساب‌های کاربری در تسهیم معتبر نمی‌باشد",
            117 => "شماره شبا تکراری در تسهیم وجود دارد",
            118 => "حساب‌های کاربری در تسهیم معتبر نمی‌باشند",

            121 => "تایید تراکنش نیازمند پرداخت موفق می‌باشد",
            122 => "داده‌های ارسالی نامعتبر است. پرداخت یافت نشد",
            123 => "تراکنش قبلا تایید شده است",
            124 => "تراکنش با این نسخه از سیستم سازگار نیست",
            127 => "خطایی در انجام عملیات در درگاه داده شده است",                                                                                                                                                                                                                               
        );

        if (array_key_exists($error_code, $error_array)) {
            return $error_array[$error_code];
        } else {
            return "خطا : $error_code";
        }
    }
}