<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
 * CodeIgniter Parsian getway library
 *
 * @author              Rayanik (http://rayanik.com)
 * @package             Parsian
 */



class Parsian
{
    private $url;
    private $ERR;
    private $token;
    private $RRN;
    private $cardNumberMasked;

    public function request($pin, $amount, $transaction_id, $site_call_back_url, $order_id = 0)
    {
        try {
            ini_set ( "soap.wsdl_cache_enabled", "0" );
            $wsdl_url = "https://pec.shaparak.ir/NewIPGServices/Sale/SaleService.asmx?WSDL";
            $client = new SoapClient ( $wsdl_url );

            $params = array (
                "LoginAccount" => $pin,
                "Amount" => $amount,
                "OrderId" => $transaction_id,
                "CallBackUrl" => $site_call_back_url 
            );

            $result = $client->SalePaymentRequest (array("requestData" => $params));

            if ($result->SalePaymentRequestResult->Token && $result->SalePaymentRequestResult->Status === 0) {;
                $this->token = $result->SalePaymentRequestResult->Token;
                $this->url = 'https://pec.shaparak.ir/NewIPG/?Token='.$result->SalePaymentRequestResult->Token;
                return true;
            }
            elseif ( $result->SalePaymentRequestResult->Status  != '0') {
                    $err_msg = "(<strong> کد خطا : " . $result->SalePaymentRequestResult->Status . "</strong>) " .
                    $result->SalePaymentRequestResult->Message ;
                    $this->ERR = $err_msg;
                    return false;
            }
            else{
                $this->ERR = "پاسخی از سمت بانک ارسال نشد.";
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode();
            return false;
        }
    }

    public function redirect()
    {
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }
        redirect($this->url);
    }

    public function getError()
    {
        return $this->ERR;
    }

    public function getToken()
    {
        return $this->token;
    }

    public function verify($pin, $token)
    {   
        try {
            $wsdl_url = "https://pec.shaparak.ir/NewIPGServices/Confirm/ConfirmService.asmx?WSDL";
            $client = new SoapClient ( $wsdl_url );
            $params = array (
                "LoginAccount" => $pin,
                "Token" => $token 
            );

            $result = $client->ConfirmPayment (array("requestData" => $params));
            if($result->ConfirmPaymentResult->Status === 0 && $result->ConfirmPaymentResult->RRN > 0){
                $this->RRN = $result->ConfirmPaymentResult->RRN;
                //$this->cardNumberMasked = $result->ConfirmPaymentResult->cardNumberMasked;
                return true;
            }
            if ($result->ConfirmPaymentResult->Status != '0') {
                $err_msg = "(<strong> کد خطا : " . $result->ConfirmPaymentResult->Status . "</strong>) " .
                $result->ConfirmPaymentResult->Message ;
                
                $this->ERR = $err_msg;
                return false;
            }else{
                $this->ERR = "پاسخی از سمت بانک ارسال نشد.";
                return false;
            }
        } catch (\Throwable $th) {
            // $th->getCode();
            return false;
        }
    }

    public function getRRN()
    {
        return $this->RRN;
    }
    public function cardNumberMasked()
    {
        return $this->cardNumberMasked;
    }
}
