<?php
/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Melipayamak {
    private $err;

    public function send_by_token($api, $from, $to, $body_id, $token1='', $token2='', $token3='') {
        $body_id = intval($body_id);

        $args =[];
        $args[] = trim(strval($token1));
        if($token2)  $args[] = trim(strval($token2));
        if($token3)  $args[] = trim(strval($token3));

        // $time = date('Y-m-d H:i:s');
        // $json_args = json_encode($args, JSON_UNESCAPED_UNICODE);
        // $text = "time:$time, to:$to, body_id:$body_id, json_args:$json_args \n";
        // writeFile($text, 'sms');
        // return true;

        
        try{
            $url = "https://console.melipayamak.com/api/send/shared/$api";
            $data = array('bodyId' => $body_id, 'to' => $to, 'args' => $args); //['arg1', 'arg2']
            $data_string = json_encode($data);
            
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($data_string)
                )
            );

            $response = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response);
            // dd($response);

            if(isset($response->recId)){
                return true;
            } else if(isset($response->status)){
                $this->err = "($response->status)";
            } else {
                $this->err = '';
            }
            return false;

        } catch (\Throwable $th) {
            $this->err = 'کد خطا: ' . $th->getCode();
            return false;
        }
    }

    public function send($api, $from, $to, $text) {
        // $time = date('Y-m-d H:i:s');
        // $text = "time:$time, to:$to, text:$text \n";
        // writeFile($text, 'sms');
        // return true;
        
        try {
            $url = "https://console.melipayamak.com/api/send/simple/$api";
            $data = array('from' => $from, 'to' => $to, 'text' => $text);
            $data_string = json_encode($data);


            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($data_string)
                )
            );

            $response = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response);
            // dd($response);

            if(isset($response->recId)){
                return true;
            } else if(isset($response->status)){
                $this->err = "($response->status)";
            } else {
                $this->err = '';
            }
            return false;


        } catch (\Throwable $th) {
            $this->err = 'کد خطا: ' . $th->getCode();
            return false;
        }
    }

    public function get_error()
    {
        return strval($this->err);
    }

}
