<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Frontend_general {

    // Generate captcha image
    function create_captcha() {
        $vals = array(
            //'word'          => 'Random word',
            'img_path' => './captcha/',
            'img_url' => base_url('/captcha/'),
            'font_path' => './captcha/font/texb.ttf',
            'img_width' => '150',
            'img_height' => '34',
            'expiration' => 1800,
            'word_length' => 4,
            'font_size' => 20,
//            'img_id' => 'Imageid',
            'pool' => '0123456789',
            // White background and border, black text and red grid
            'colors' => array(
                'background' => array(255, 255, 255),
                'border' => array(255, 255, 255),
                'text' => array(1, 1, 1),
                'grid' => array(200, 200, 200)
            )
        );

        $CI = & get_instance();
        $CI->load->helper('captcha');
        $cap = create_captcha($vals);
        if ($cap) {
            $captcha_image = $cap['image'];
            $CI->session->set_userdata('captcha', $cap['word']);
        } else {
            $captcha_image = false;
            $CI->session->unset_userdata('captcha');
        }

        return $captcha_image;
    }

    // Send email
    public function sendEmail($to = NULL, $message = NULL, $user_name = NULL, $subject = NULL, $site_name_fa = null, $site_name_en = null, $site_logo = null, $cc = NULL, $bcc = NULL) {
        try {

            $CI = & get_instance();
            $CI->load->library('email');
            $CI->load->model('settings_m');

            
            $email_settings = $CI->settings_m->getSingle('email');
            $email_settings = json_decode($email_settings);
            if(
                $email_settings->method == 'smtp' &&
                $email_settings->smtp->host &&
                $email_settings->smtp->user &&
                $email_settings->smtp->pass &&
                $email_settings->smtp->port
            ){
                
                $CI->email->initialize([
                    'protocol' => 'smtp',
                    'smtp_host' => $email_settings->smtp->host,
                    'smtp_user' => $email_settings->smtp->user,
                    'smtp_pass' => $email_settings->smtp->pass,
                    'smtp_port' => $email_settings->smtp->port,
                    'charset' => 'utf-8',
                    'wordwrap' => TRUE,
                    'encoding' => 'base64',
                    'crlf' => "\r\n",
                ]);
                $CI->email->set_newline("\r\n");
                $from = $email_settings->smtp->user;
                
            } 
            elseif($email_settings->method == 'mail' && $email_settings->host_email) {
                $CI->email->initialize([
                    'charset' => 'utf-8',
                    'wordwrap' => TRUE
                ]);
                $CI->email->set_newline("\r\n");
                $from = $email_settings->host_email;
            } 
            else {
                return false;
            }

            $CI->email->set_mailtype('html');
            $CI->email->from($from, $site_name_en);
            $CI->email->to($to);
            $CI->email->subject($subject);
            if ($cc) {
                $CI->email->cc($cc);
            }
            if ($bcc) {
                $CI->email->bcc($bcc);
            }
    
            $arguments = array(
                'site_logo' => $site_logo,
                'site_name_fa' => $site_name_fa,
                'user_name' => $user_name,
                'body' => $message,
            );
            $html =  $CI->load->view('_layout_email', $arguments, true);
    
            
    
            //die($html);
            $CI->email->message($html);
            $result = $CI->email->send();
    
            // $text = "$html \n";
            // $text .= "-------------------------------------------------------------------- \n";
            // writeFile($text, 'email');
    
            return $result;
        } catch (\Throwable $th) {
            return false;
        }
    }


}
