<?php

/**
 * @author Rayanik.com
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Frontend_Controller extends MY_Controller {

    public $product_categories;
    public $user_login = FALSE;
    protected $captcha_limit = 10;
    public $login_name_session = 'karta_user_customer';
    public $login_name_cookie = 'karta_login_cookie';
    public $verify_code_cooldown = 180; // زمان ارسال کد تایید برای شماره همراه به ثانیه

    function __construct() {
        parent::__construct();

        date_default_timezone_set('Asia/Tehran');

        $this->load->database();
        $this->load->helper('genaral_helper');
        $this->load->helper('cookie');
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->library('frontend_general');
        $this->load->model('categories_m');
        $this->load->model('users_m');
        $this->load->library('user_agent');

        //get data in settings
        $this->load->model('settings_m');
        $fields = array(
            'inaccess_minutes',
            'logo',
            'favicon',
            'meta_title',
            'meta_description',
            'meta_keywords',
            //'site_summary',
            'social_networks',
            'default_category_image',
            'default_category_large_image',
            'address',
            'phone1',
            'phone2',
            'info_email',
            'admin_email',
            'offline',
            'site_name',
            'site_name_en',
            'enamad',
            'samandehi',
            'body_script',
            'header_script',
            'process_checkbox',
            'kavenegar_checkbox',
            'payment_alerts',
            'show_coupon_box',
            'show_gift_box',
            'send_admin_invoice',
            'rate',
            'round_price',
            'verify_when_buy',
            'product_ui',
            'theme',
            'version',
            'card2card_alert',
            'about',
            'buy_steps',
            'notice',
            'font',
        );
        $settings = $this->settings_m->getSettings($fields);
        $settings->social_networks = json_decode($settings->social_networks);
        $settings->rate = json_decode($settings->rate);
        $settings->theme = json_decode($settings->theme);
        $settings->product_ui = json_decode($settings->product_ui);
        $settings->verify_when_buy = json_decode($settings->verify_when_buy);
        $settings->buy_steps = json_decode($settings->buy_steps);
        $settings->notice = json_decode($settings->notice);
        $settings->font = json_decode($settings->font);

        $this->settings = $this->data['settings'] = $settings;

        if ($this->settings->offline == '1')
            redirect('offline');

        // چک میکنیم که کاربر لاگین هست یا خیر
        $this->data['user_login'] = FALSE;
        $user_login = $this->checkLogin();
        if ($user_login) {
            $this->data['user_login'] = $user_login;
            $this->user_login = $user_login;

            // تعداد پیام های تیکت خوانده نشده
            $this->load->model('tickets_m');
            $this->data['number_of_message'] = $this->tickets_m->getUnreadMessagesByUser($this->user_login->id);
        }

        //meta
        $this->data['meta_title'] = $this->settings->meta_title;
        $this->data['meta_description'] = $this->settings->meta_description;
        $this->data['meta_keywords'] = $this->settings->meta_keywords;
        $this->data['meta_image'] = base_url($this->settings->logo);

        // Theme
        if($settings->theme->allowed_to_use == 'both'){
            $user_theme = get_cookie('karta_theme');
            if($user_theme){
                $theme_mode = ($user_theme == 'light') ? 'light' : 'dark';
            } else {
                $theme_mode = $settings->theme->default;
            }
        } else {
            $theme_mode = $settings->theme->allowed_to_use;
        }
        $theme = (object)[
            'mode' => $theme_mode,
            'color' => (isset($settings->theme->color)) ? $settings->theme->color : 'bluegreen',
            'bg_color' => (isset($settings->theme->bg_color)) ? $settings->theme->bg_color : 'darkblue',
        ];
        $this->data['theme'] = $theme;

        // Is mobile
        $this->load->library('user_agent');
        $this->is_mobile = ($this->agent->is_mobile()) ? true : false;
        $this->data['is_mobile'] = $this->is_mobile;

        // Get notices
        $this->load->model('notices_m');
        $this->notices = $this->data['notices'] = $this->notices_m->getCurrentNotices();

        // درگاه‌های بر پایه دلار و کریپتو
        $this->data['dollar_gateways'] = ['oxapay', 'mixpay'];

        //به دست آوردن منوها
        $this->load->model('menu_types_m');
        $menu_types = $this->menu_types_m->get();
        if ($menu_types) {
            //به دست آوردن منوی اصلی سایت
            $menu_type_id = 0;
            foreach ($menu_types as $key => $menu_type) {
                if ($menu_type->type == 'top_menu') {
                    $menu_type_id = $menu_type->id;
                    unset($menu_types[$key]);
                    break;
                }
            }
            if ($menu_type_id != 0) {
                $this->data['menu'] = $this->getMenu($menu_type_id);
            }

            //ستون اول فوتر
            $menu_type_id = 0;
            foreach ($menu_types as $key => $menu_type) {
                if ($menu_type->type == 'first_column_footer') {
                    $menu_type_id = $menu_type->id;
                    unset($menu_types[$key]);
                    break;
                }
            }
            if ($menu_type_id != 0) {
                $this->load->model('menus_m');
                $this->data['first_column_footer'] = $this->menus_m->get_by("id, title, url, type", array('menu_type_id' => $menu_type_id, 'publish' => '1'), false, 'ordering asc');
            }

            //session
            //$this->session->set_userdata('count', 1);
        }
    }

    //به دست آوردن کل منوی مود نظر به صورت درختی
    public function getMenu($menu_type_id) {

        //===================menu=======================
        $refs = array();
        $list = array();

        $this->load->model('menus_m');
        $menus = $this->menus_m->get_by(null, array('menu_type_id' => $menu_type_id, 'publish' => '1'));

        foreach ($menus as $menu) {
            $ref = & $refs[$menu->id];

            $ref['id'] = $menu->id;
            $ref['title'] = $menu->title;
            $ref['url'] = $menu->url;
            $ref['type'] = $menu->type;

            if ($menu->parent == 0) {
                $list[$menu->id] = & $ref;
            } else {
                $refs[$menu->parent]['children'][$menu->id] = & $ref;
            }
        }
        return $list;
    }

    // Check coupon
    public function checkCoupon($code, $email, $cell_phone) {
        $email = '';

        $this->load->model('coupons_m');
        $this->load->model('orders_m');

        $result = new stdClass();
        $result->condition = FALSE;
        $result->message = 'کد تخفیف وارد شده صحیح نیست.';

        $now = date('Y-m-d');
        $where = array(
            'code' => $code,
            'deleted' => 0,
            'publish' => 1,
            'start_date <=' => $now,
        );
        $coupon = $this->coupons_m->get_by(NULL, $where, TRUE);
        if (!$coupon) {
            $result->message = 'کد تخفیف وارد شده صحیح نیست.';
            return $result;
        }

        //چک می کنیم که کاربر قبلا از این کد استفاده نکرده باشد
        $where = array(
            'coupon_id' => $coupon->id,
            'paid' => 1
        );
        if($email && $cell_phone){
            $where["(cell_phone = '$cell_phone' OR email = '$email')"] = null;
        }elseif($email){
            $where['email'] = $email;
        }else{
            $where['cell_phone'] = $cell_phone;
        }
        $order = $this->orders_m->get_by('id', $where);
        if ($order) {
            $result->message = 'کاربر گرامی شما قبلا از این کد استفاده کرده اید.';
            return $result;
        }

        //چک می کنیم منقضی نشده باشد
        if ($coupon->end_date < $now) {
            $result->message = 'کوپن مورد نظر منقضی شده است.';
            return $result;
        }

        //محصولاتی که می توانند از این کوپن استفاده کنند
        $product_ids = array();
        $product_titles = array();
        $coupon_products = $this->coupons_m->getProducts($coupon->id);
        if($coupon_products){
            $coupon_products = json_decode(json_encode($coupon_products), true);
            $product_ids = array_map('intval', array_column($coupon_products, 'id'));
            $product_titles = array_column($coupon_products, 'title');
        }
        $coupon->product_ids = $product_ids;
        $coupon->product_titles = $product_titles;

        //به دست آوردن تعداد استفاده شده این کوپن
        $where = array(
            'coupon_id' => $coupon->id,
            'paid' => 1
        );
        $number_used = $this->orders_m->get_by('count(id) AS number', $where, true)->number;
        if ($number_used >= $coupon->count) {
            $result->message = 'ظرفیت استفاده از این کوپن پر شده است.';
            return $result;
        }

        $result->condition = TRUE;
        $result->message = '<p>کد تخفیف وارد شده صحیح است.</p>';
        if($coupon->minimum > 0 && $coupon->product_titles){
            $result->message .= '<p>شرایط استفاده:</p>';
            if($coupon->minimum){
                $result->message .= '<p>حداقل مبلغ خرید باید <span>'.number_format($coupon->minimum).'</span> تومان باشد.</p>';
            }
            if($coupon->product_titles){
                if(count($coupon->product_titles) == 1){
                    $result->message .= '<p>این کوپن فقط برای <span>'.$coupon->product_titles[0].'</span> قابل استفاده است.</p>';
                }else{
                    $result->message .='<p>محصولاتی که می توانند از این کوپن استفاده کنند عبارتند از:</p>';
                    $result->message .= '<p>' . implode('</p> <p>', $coupon->product_titles) . '</p>';
                }
            }

        }

        $result->coupon = $coupon;

        return $result;
    }

    //check login
    function checkLogin() {
        /* ------------------- */
        // $this->session->set_userdata($this->login_name_session,51);
        // $this->session->unset_userdata($this->login_name_session);
        /* ------------------- */

        $user_in_session = $this->session->userdata($this->login_name_session);
        $user_in_cookie = get_cookie($this->login_name_cookie);
        $user = null;
        $fields = "id, username, first_name, last_name, email, cell_phone, image, national_code, status, matched_fields, birth_date, auth_call";

        //ابتدا از سشن می خوانیم
        if($user_in_session){
            $where = array(
                'id' => intval($user_in_session),
                'block' => 0,
                'deleted' => 0,
                'activation' => 1,
                'type' => 'customer'
            );
            $user = $this->users_m->get_by($fields, $where, TRUE);
            if(!$user){
                $this->session->unset_userdata($this->login_name_session);
            }
        }
        //اگر سشن وجود نداشت از کوکی می خوانیم
        else if($user_in_cookie){
            $find = FALSE;
            $user_in_cookie = explode('|', $user_in_cookie);
            if (count($user_in_cookie) == 3) {
                $this->load->model('login_cookies_m');
                $user_session = $user_in_cookie[0];
                $md5_username = $user_in_cookie[1];
                $token = $user_in_cookie[2];

                $where = array(
                    'user_session' => $user_session,
                    'md5(username)' => $md5_username,
                    'token' => $token,
                );
                $login_cookie = $this->login_cookies_m->get_by('id, username', $where, TRUE);

                if ($login_cookie) {
                    $where = array(
                        'username' => $login_cookie->username,
                        'block' => 0,
                        'deleted' => 0,
                        'activation' => 1,
                        'type' => 'customer'
                    );
                    $user = $this->users_m->get_by($fields, $where, TRUE);
                    if ($user) {
                        if (hash('sha512', $user->id . $user->username) == $user_session) {
                            $find = TRUE;
                            // سشن را ایجاد می کنیم
                            $this->session->set_userdata($this->login_name_session, $user->id);

                            //حال کوکی را به روز می کنیم
                            $token = hash('sha512', uniqid(rand(), TRUE));
                            $data = array(
                                'token' => $token,
                                'updated' => date('Y-m-d H:i:s'),
                            );
                            if ($this->login_cookies_m->save($data, $login_cookie->id)) {
                                $value = $user_session . '|' . md5($user->username). '|' . $token;;
                                // 1 months -> 1*30 days
                                set_cookie($this->login_name_cookie, $value, 3600 * 24 * 30);
                            }
                        }
                    }
                }
            }
            if ($find == FALSE) {
                //این کوکی اعتبار ندارد
                delete_cookie($this->login_name_cookie);
                $user = NULL;
            }
        }

        if($user){
            $user->credit = $this->users_m->getCredit($user->id);

            //*******************************//
            // $user->national_code = 2301269663;
            // $user->matched_fields = json_encode(['national_code']);
            //*******************************//

            $user->matched_fields = ($user->matched_fields) ? json_decode($user->matched_fields) :  [];
        }
        return $user;
    }


    public function sendVerifyCode($cell_phone){
        $this->load->model('verifications_m');

        // بررسی آخرین ارسال در چند دقیقه گذشته
        $last_time = date('Y-m-d H:i:s', strtotime("-{$this->verify_code_cooldown} seconds"));
        $recent_request = $this->verifications_m->get_by('id', [
            'cell_phone' => $cell_phone,
            'created >' => $last_time,
            'used' => 0
        ], true);

        if ($recent_request) {
            $message = 'کاربر گرامی دقایقی پیش یک کد فعال سازی به این شماره ارسال گردید.';
            $this->session->set_flashdata('frontend_success', $message);
        } else {
            $code = mt_rand(10000, 99999);

            // Send sms
            $settings = $this->settings_m->getSettings(['sms', 'site_name']);
            $settings->sms = json_decode($settings->sms);
            if($settings->sms->active && $settings->sms->api_key && $settings->sms->api_key){
                $this->load->library($settings->sms->active, null, 'sms');
                if($settings->sms->patterns->verify){
                    $sms_status = $this->sms->send_by_token($settings->sms->api_key, $settings->sms->from, $cell_phone, $settings->sms->patterns->verify, $code);
                } else {
                    $message = "کد تایید شماره همراه شما: $code";
                    $message .= "\n" . $settings->site_name;
                    $sms_status = $this->sms->send($settings->sms->api_key, $settings->sms->from, $cell_phone, $message);
                }
                if ($sms_status) {
                    $data = array(
                        'cell_phone' => $cell_phone,
                        'code' => $code,
                    );
                    $this->verifications_m->save($data);
                    
                    $message = 'کد فعال سازی برای شما پیامک شد';
                    $this->session->set_flashdata('frontend_success', $message);
                } else {
                    $message = 'متاسفانه در ارسال پیامک مشکلی رخ داده است. از قسمت تماس با ما جهت رفع مشکل استفاده نمایید.' . $this->sms->get_error();
                    $this->session->set_flashdata('frontend_error', $message);
                }
            } else {
                $message = 'کاربر گرامی در ارسال پیامک مشکلی رخ داده است. از قسمت تماس با ما جهت رفع مشکل استفاده نمایید.';
                $this->session->set_flashdata('frontend_error', $message);
            }
        }

        $this->session->set_userdata('verify_cellphone', $cell_phone);
        
    }

    public function gateways($page = ''){
        // Gateways
        $this->load->model('gateways_m');
        $where = array('publish'=>1, 'deleted'=>0);
        $gateways = $this->gateways_m->get_by('title_en, title_fa, is_default, image, dollar_base', $where, false, 'ordering, title_fa');
        
        // Card2card & default gateway
        $card2card = null;
        $default_gateway = '';
        if($gateways){
            foreach ($gateways as $key => $gateway) {
                if($gateway->title_en === 'card2card'){
                    $card2card = $gateway;
                    unset($gateways[$key]);
                }
                
                if($gateway->is_default){
                    $default_gateway = $gateway->title_en;
                }
            }

            // Reindex
            $gateways = array_values($gateways);
        }

        if(!$default_gateway){
            if($gateways){
                $default_gateway = $gateways[0]->title_en;
            } elseif($card2card){
                $default_gateway = $card2card->title_en;
            }
        }
        
        if($card2card){
            // CSS & JS
            array_push($this->data['css'], 'assets/plugins/persian-datepicker/css/persian-datepicker.css?1');
            array_push($this->data['css'], 'assets/plugins/clockpicker/dist-new/jquery-clockpicker.min.css');

            array_push($this->data['js'], 'assets/plugins/persian-date/persian-date.js?1');
            array_push($this->data['js'], 'assets/plugins/persian-datepicker/js/persian-datepicker.js?1');
            array_push($this->data['js'], 'assets/plugins/clockpicker/dist-new/bootstrap-clockpicker-diracleo.js');
            array_push($this->data['js'], 'assets/plugins/moment/dist/moment.min.js');

            $this->data['show_modal_card2card'] = true;

        }

        if($gateways && $this->user_login && in_array('bank_card', $this->settings->verify_when_buy)){
            $this->load->model('bank_cards_m');
            $this->data['bank_cards'] = $this->bank_cards_m->get_by('id, card_number', [
                'user_id' => $this->user_login->id,
                'deleted' => 0
            ], false, 'priority DESC');

            $this->data['show_modal_bank_card'] = true;
        }

        $this->data['gateways'] = $gateways;
        $this->data['card2card'] = $card2card;
        $this->data['default_gateway'] = $default_gateway;
        if($page){
            $this->data['page'] = $page;
        }

        $this->data['html_gateways'] = $this->load->view('gateways', $this->data, true);
    }

    public function uploadImageTransaction($name = NULL) {
        $result = new stdClass();
        $result->condition = FALSE;
        if ($name) {

            $this->load->library('upload');

            $output_dir = 'media/transfers/';
            if (!file_exists($output_dir)) {
                mkdir($output_dir, 0755, true);
            }
            $file_extension = pathinfo($_FILES[$name]['name'], PATHINFO_EXTENSION);
            $fileName = date('Ymd-His') . '-' . random_str(10) . '-' . random_str(10). '.' . $file_extension;
            $config['upload_path'] = $output_dir;
            $config['file_name'] = $fileName;
            $config['allowed_types'] = 'gif|jpg|jpeg|png';
            $config['max_size'] = 1024; //(in kilobyte) 1 MB = 1024 KB


            $this->upload->initialize($config);

            if (!$this->upload->do_upload($name)) {
                $result->error = array('error' => $this->upload->display_errors());
            } else {
                $result->condition = TRUE;
                $result->file_name = $fileName;
                $result->file_path = $output_dir . $fileName;
            }
        }
        return $result;
    }

    public function checkActiveAuthCall(){
        $auth_call_setting = json_decode($this->settings_m->getSingle('auth_call'));
        if($auth_call_setting == null){
            // تنظیمات این ماژول وجود ندارد.
            return false;
        }

        if(!$auth_call_setting->active){
            // احراز هویت صوتی غیر فعال است.
            return false;
        }

        return true;
    }
}
