<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Categories {
    public $types=array('product');
        
    
    //پارامتر
    //list:از نوع آرایه است که چند بعدی است
    //خروجی
    //آرایه یک بعدی که تعداد محصواتی که آن دسته هست همراه با اطاعات عمومی دسته بر میگرداند
    public function getCategoryWithProductCount($list) {
//
//        $category =array();
//        if(count($list)){
//            foreach ($list as $value) {
//                
//                $count =intval($value['product_count']);
//                $category_id=$value['id'];
//                $category_title=$value['title'];
//                $category_icon=$value['icon'];
//                $category[$category_id]=array(
//                    'id'=>$category_id,
//                    'title'=>$category_title,
//                    'icon'=>$category_icon,
//                    'product_count'=>$count,
//                );
//                if (!empty($value['children'])) {
//                    $count += $this->productCountInCategory($value['children']);
//                }
//                $category[$category_id]['product_count']=$count;
//            }
//        }
//        return $category;
    }
    
    
    //به دست آوردن تعداد محصولات در یک دسته
    function productCountInCategory(array $list) {
        $count=0;
        foreach ($list as $value) {
            $count +=intval($value['product_count']);
            if (!empty($value['children'])) {
                $count += $this->productCountInCategory($value['children']);
            }
        }
        return $count;
    }
    //================================BEGIN===========================
    function getDirectChildren(array $array, $parent_id){
        $children = array();
        foreach ($array as $key => $value) {
            if ($key == $parent_id) {
                if (!empty($value['children'])) {
                    $children=  array_merge($children, $value['children']);
                }
            } else {
                if (!empty($value['children'])) {
                    $children=  array_merge($children,$this->getDirectChildren($value['children'], $parent_id));
                }
            }
        }
        
        return $children;
    }
    
    //================================BEGIN===========================
    
    
    //به دست آوردن دسته بندی به صورت درختی
    public function getTree($categories) {
        
        $refs = array();
        $list = array();
        
        foreach ($categories as $category) {
            $ref = & $refs[$category->id];

            $ref['parent_id'] = $category->parent_id;
            $ref['ordering'] = $category->ordering;
            $ref['title_fa'] = $category->title_fa;
            $ref['title_en'] = $category->title_en;
            $ref['id'] = $category->id;
            $ref['publish'] = $category->publish;

            if ($category->parent_id == 0) {
                $list[$category->id] = & $ref;
            } else {
                $refs[$category->parent_id]['children'][$category->id] = & $ref;
            }
        }
        return $list;
    }
    
    //به دست آوردن فرزند به صورت درختی
    public function getChildrenTree($array, $parent_id) {
        $data=array();
        foreach ($array as $key => $value) {
            if ($key == $parent_id) {
                if (!empty($value['children'])) {
                    
                    $data[$value['id']]=array(
                        'parent_id'=>0,
                        'ordering'=>0,
                        'title_fa'=>$value['title_fa'],
                        'title_en'=>$value['title_en'],
                        'id'=>$value['id'],
                        'publish'=>$value['publish'],
                        'children'=>$value['children'] 
                    );
                }else{
                    $data[$value['id']]=$value;
                }
            } else {
                if (!empty($value['children'])) {
                    array_push($data,$this->getChildrenTree($value['children'], $parent_id));
                }
            }
        }
        return $data;
    }
    
    //================================BEGIN===========================
    //به دست آوردن فرزندان
    function childrenFind(array $array, $parent_id ) {
        
        
        $children = '';
        foreach ($array as $key => $value) {
            if ($key == $parent_id) {

                if (!empty($value['children'])) {
                    $result = $this->childrenList($value['children']);
                    $children .= trim($result, ',');
                }
            } else {
                if (!empty($value['children'])) {
                    $children.=$this->childrenFind($value['children'], $parent_id);
                }
            }
        }
        return $children;
    }

    //آی دی فرزندان را برمیگردانیم
    function childrenList(array $array) {
        $ids = "";
        foreach ($array as $value) {
            $ids .= $value['id'] . ',';
            if (!empty($value['children'])) {
                $ids .= $this->childrenList($value['children']);
            }
        }
        return $ids;
    }
    //================================END===========================
    //=========================BEGIN================================
    //با دو تابع زیر فرزندان دسته بندی را بر میکردانیم که آن فرزند رنگ مورد نظر را نداشته باشد
    function childrenFindWithColor(array $array, $parent_id ,$color_id) {
        
        $children = '';
        foreach ($array as $key => $value) {
            if ($key == $parent_id) {

                if (!empty($value['children'])) {
                    $result = $this->childrenListWithColor($value['children'],$color_id);
                    $children .= trim($result, ',');
                }
            } else {
                if (!empty($value['children'])) {
                    $children.=$this->childrenFind($value['children'], $parent_id,$color_id);
                }
            }
        }
        return $children;
    }

//آی دی فرزندان را برمیگردانیم
    function childrenListWithColor(array $array,$color_id) {
        $ids = "";
        foreach ($array as $value) {
            $colors=array();
            if(isset($value['colors_id'])){
                $colors=  explode(',', $value['colors_id']);
            }
            if(!in_array($color_id, $colors)){
                $ids .= $value['id'] . ',';
                if (!empty($value['children'])) {
                    $ids .= $this->childrenListWithColor($value['children'],$color_id);
                }
            }
        }
        return $ids;
    }
    //================================END===========================
    
    //یافتن پدران در دسته بندی درختی
    function getParents($id=null,$full=FALSE,$self=FALSE){
//        ************************************************************************************************
//        * if($full==false) فقط آی دی پدران دسته را برمی گرداند
//        * 8,10,20 مثال خط فوق
//        *if($full==true) خروجی آن آرایه هست که علاوه بر آی دی پدران عنوان آن ها را نیز بر می گرداند 
//        ************************************************************************************************
        $CI = & get_instance();
        $CI->load->model('categories_m');
        $id=intval($id);
        $parents=array();
        $category=$CI->categories_m->get_by('parent_id,title_fa, title_en,id',array('id'=>$id),true);
        if($category){
            if($self){
                if($full){
                    $parents[]=(object) array(
                    'title_fa'=>$category->title_fa,
                    'title_en'=>$category->title_en,
                    'id'=>$category->id
                        );
                }else{
                    //فقط لیست آی دی ها
                    $parents[]=$category->id;

                }
            }
            while($category->parent_id!=0){
                $id=$category->parent_id;
                $category=$CI->categories_m->get_by('parent_id, title_fa, title_en, id', array('id'=>$id), true);
                if($category){
                    
                    if($full){
                        $parents[]=(object) array(
                        'title_fa'=>$category->title_fa,
                        'title_en'=>$category->title_en,
                        'id'=>$category->id
                            );
                    }else{
                        //فقط لیست آی دی ها
                        $parents[]=$category->id;
                    }
                }else{
                    break;
                }
            }
        }
        
        if(count($parents)){
            if($full){

                $parents= array_reverse($parents);
                return $parents;
            }else{
                //فقط لیست آی دی ها
                return $parents;
            }
        }else{
            return NULL;
        }
    }
}