<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
 * CodeIgniter Bitpay gateway library
 *
 * @author              Rayanik Co. (https://www.rayanik.com)
 * @license             GNU Public License 1.0
 * @package             Bitpay
 */

class Bitpay {

    private $authority;
    private $errorCode;
    private $errorMessage;
    private $url;
    
    function request($api, $amount, $factorId = 0, $redirect ='', $email = '', $name = '', $desc = '') {
        try{

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://bitpay.ir/payment/gateway-send');
            curl_setopt($ch, CURLOPT_POSTFIELDS, "api=$api&amount=$amount&factorId=$factorId&redirect=$redirect&email=$email&description=$desc");
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            curl_close($ch);
        
            $transId = intval($result);
            if ($transId>0){
                $this->authority = $transId;
                $this->url = 'https://bitpay.ir/payment/gateway-'.$transId;
                
                return true;
            } else {
                $this->errorCode = $transId;
                $this->errorMessage = 'خطا در اتصال به درگاه پرداخت، کد خطا: ' . $this->errorCode;

                return false;
            }
        }catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
    }

    function verify($api, $authority, $refid) {
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://bitpay.ir/payment/gateway-result-second');
            curl_setopt($ch, CURLOPT_POSTFIELDS, "api=$api&id_get=$authority&trans_id=$refid");
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            $result = curl_exec($ch);
            curl_close($ch);
            
            if ($result == 1) {
                return $result;
            } else {
                $this->errorCode = $result;
                $this->errorMessage = 'خطا در تایید تراکنش';

                return false;
            }
        }catch (\Throwable $th) {
            // $th->getCode()
            return false;
        }
        
    }
    
    public function redirect()
    {
        $CI = &get_instance();
        if (!function_exists('redirect')) {
            $CI->load->helper('url');
        }
        redirect($this->url);
    }
    
    public function get_error()
    {
        return $this->errorMessage;
    }

    public function get_authority()
    {
        return $this->authority;
    }
}