<?php
/**
* @author Rayanik.com
*/
function create_slug($string) {
    $string = str_replace(' ', '-', $string);
    $string = str_replace('،', '', $string); 
    // return preg_replace('/،,[;()*.\'\""]/',  '', $string); // Removes wrong chars.
    $string = preg_replace('/[,;()*.\'"]/', '', $string); // Removes wrong chars.

    return $string;
}

function card_encrypt($plaintext){
    # --- ENCRYPTION ---
    $key = config_item('crypt_key');

    // Remove the base64 encoding from our key
    $encryption_key = base64_decode($key);
    // Generate an initialization vector
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
    // Encrypt the data using AES 256 encryption in CBC mode using our encryption key and initialization vector.
    $encrypted = openssl_encrypt($plaintext, 'aes-256-cbc', $encryption_key, 0, $iv);
    // The $iv is just as important as the key for decrypting, so save it with our encrypted data using a unique separator (::)
    return base64_encode($encrypted . '::' . $iv);
}

function card_decrypt($data_base64){
    # --- DECRYPTION ---
    $key = config_item('crypt_key');

    // Remove the base64 encoding from our key
    $encryption_key = base64_decode($key);
    // To decrypt, split the encrypted data from our IV - our unique separator used was "::"
    list($encrypted_data, $iv) = explode('::', base64_decode($data_base64), 2);
    return openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);

}

function dd($data = NULL) {
    var_dump($data);
    die();
}

function random_str($n) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $n; $i++) { 
        $index = rand(0, strlen($characters) - 1);
        $randomString .= $characters[$index];
    }
    return $randomString;
}

function isLocalhost() {
    $whitelist = array('127.0.0.1', '::1');
    return in_array($_SERVER['REMOTE_ADDR'], $whitelist);
}


function writeFile($text, $name = '') {
    //$myfile = fopen("media/$name.txt", "w") or die("Unable to open file!");
    try{
        $myfile = fopen("media/$name.txt", "a");
        fwrite($myfile, $text);
        fclose($myfile); 
    } catch (Exception $ex) {
        
    }

}

function currency_to_tooman($price, $rate, $round_type){
    if(!$price) return 0;

    $price = $price * $rate;
    $price = floor($price / 1) * 1;
    [$type, $rounder] = explode('-', $round_type);
    $rounder = intval($rounder);

    if($rounder == 1){
        return $price;
    }

    if($type == "up"){
        return ceil($price / $rounder) * $rounder;
    }else{
        if($price >= $rounder){
            return floor($price / $rounder) * $rounder;
        }else{
            // اگر عدد گرد کردن بزرگتر از عدد قیمت بود 
            return $price;
        }
    }
}

// رند کردن به بالا تا سه رقم اعشار برای پرداخت های دلاری و کرپتو 
// 2.1233, 3 => 2.124
// 2.1238, 3 => 2.124
// 2.1230, 3 => 2.123
// 2.1, 3    => 2.100
// 2, 3      => 2.000
function ceilWithPrecision($number, $precision = 0) {
    $factor = pow(10, $precision);
    return ceil($number * $factor) / $factor;
}

function translateCurrency($currency){
    switch ($currency) {
        case 'tooman':
            $title = 'تومان';
            break;
        case 'dollar':
            $title = 'دلار';
            break;
        case 'dirham':
            $title = 'درهم';
            break;
        case 'euro':
            $title = 'یورو';
            break;
        case 'pound':
            $title = 'پوند';
            break;
        case 'lira':
            $title = 'لیر';
            break;
        default:
            $title = '';
            break;
    }
    return $title;
}

function translatePriority($priority){
    switch ($priority) {
        case 'low':
            $title =  'کم';
            break;
        case 'normal':
            $title =  'عادی';
            break;
        case 'high':
            $title =  'زیاد';
            break;
        
        default:
            $title = '';
            break;
    }
    return $title;
}

function getTransactionTypes($type = null){
    $types = [
        'charge' => 'شارژ کیف پول',
        'credit_increase' => 'افزایش موجودی', // زمانی که کاربر می خواهد یک سفارش را از طریق کارت به کارت یا درگاه، پرداخت کند
        'order_payment' => 'پرداخت سفارش',
        'manual' => 'توسط مدیر',
        'signup' => 'هدیه ثبت نام',
        'refund' => 'بازگشت',
        'gift_card' => 'کارت هدیه',
    ];

    if($type){
        return (isset($types[$type])) ? $types[$type] : '';
    }

    $obj_types = [];
    foreach ($types as $type => $title) {
        $obj_types[] = (object)[
            'type' => $type,
            'title' => $title,
        ];
    }

    return $obj_types;
}

function getProductSlug($slug, $id){
    if($slug){
        return base_url("product/". urlencode($slug));
    } 
    
    if($id){
        return base_url("product/$id");
    } 

    return '';
}

// لیست فیلد های استاتیک که می خواهیم در دسته قرار دهیم تا مدیر از بین آن ها انتخاب کند
function staticsFields($static_key = null){
    // هیچ وقت از لیست زیر چیزی نباید حذف شود
    // اگر هم مجبور شدیم که چیزی را حذف کنیم باید شبیه به حذف منطقی عمل کنیم
    $list = [
        'full_name' =>     (object)['title' => 'نام و نام خانوادگی', 'class' => '',           'icon' => 'fa fa-user-circle-o',  'ltr' => 0],
        'national_code' => (object)['title' => 'کد ملی',             'class' => 'numeric',    'icon' => 'fa fa-address-card-o', 'ltr' => 1],
        'email' =>         (object)['title' => 'ایمیل',              'class' => 'en-numbers', 'icon' => 'fa fa-envelope-o',     'ltr' => 1],
        'description' =>   (object)['title' => 'توضیحات',            'class' => '',           'icon' => 'fa fa-file-text-o',    'ltr' => 0],
    ];
    
    if($static_key){
        return isset($list[$static_key]) ? $list[$static_key] : (object)['title' =>  '', 'icon' => '',  'ltr' => 0];
    }

    return $list;
}

// این تابع لیست فیلد های که قبلا ادمین برای دسته تعیین کرده را مرتب می کند و داده‌های مثل عنوان برای استایم هم اضافه می کند
function categoryFields($category_fields, $user_login = null){
    $fields = [];
    if($category_fields){
        $category_fields = json_decode($category_fields, true);
        foreach ($category_fields as $field) {
            if($field['use']){
                $statics_key = $field['statics_key'];

                $statics_options = ($statics_key) ? staticsFields($statics_key) : null;
                if($statics_key == 'full_name'){
                    $field['ltr'] =  $statics_options->ltr;
                    $field['icon'] = $statics_options->icon;
                    $field['class'] = $statics_options->class;
                    $field['col'] = 'col-12 col-lg-6';
                    $field['validation'] = ($field['required']) ? 'required' : '';

                    // First name
                    $statics_key = 'first_name';
                    $field['statics_key'] =  $statics_key;
                    $field['title'] =  'نام';
                    $field['value'] = ($user_login) ? $user_login->first_name : '';
                    $field['name'] = $statics_key;
                    $fields[] = $field;

                    // Last name
                    $statics_key = 'last_name';
                    $field['statics_key'] =  $statics_key;
                    $field['title'] = 'نام خانوادگی';
                    $field['value'] = ($user_login) ? $user_login->last_name : '';
                    $field['name'] = $statics_key;
                    $fields[] = $field;

                } else {

                    if($statics_key){
                        $field['title'] =  $statics_options->title;
                        $field['ltr'] =  $statics_options->ltr;
                        $field['icon'] =  $statics_options->icon;
                        $field['class'] = $statics_options->class;
                    } else {
                        $field['icon'] =  'fa fa-pencil-square-o';
                        $field['class'] = '';
                    }
                    
                    $field['validation'] = ($field['required']) ? 'required' : '';
                    if($statics_key == 'national_code'){
                        $value = ($user_login) ? $user_login->national_code : '';
                        if($user_login && in_array('national_code', $user_login->matched_fields)){
                            // قبلا استعلام گرفته شده و با شماره همراه تطابق داشته
                            $field['disabled'] = true;
                            $field['required'] = 1;
                            $field['validation'] = '';
                        } else {
                            // شاهکار فعال نیست برای اجباری بودن یا نبودن تصمیم با ادمین است
                            $field['validation'] .= '|callback_validNationalCode';
                        }
                    } elseif($statics_key == 'email'){
                        $value = ($user_login) ? $user_login->email : '';
                        $field['validation'] .= '|valid_email';
                    } else {
                        $value = '';
                    }
                    $field['validation'] = trim($field['validation'], '|');
                    
                    $field['value'] = $value;
                    $ordering = $field['ordering'];
                    $field['name'] = ($statics_key) ? $statics_key : "fields[$ordering]";
                    $field['col'] = 'col-12';

                    $fields[] = $field;
                }

            }
        }
    }
    
    if($fields){
        usort($fields, fn($a, $b) => $a['ordering'] <=> $b['ordering']);
    }

    return json_decode(json_encode($fields));
}

// این تابع فیلد های یک سفارش را مرتب می کند و عنوان های متناسب برای استاتیک ها را نیز اضافه می کند
function orderFields($order_fields){
    $order_fields = ($order_fields) ? json_decode($order_fields) : [];
    $fields = [];
    if($order_fields){
        $statics_fields = staticsFields();

        // Statics
        foreach ($statics_fields as $key => $item) {
            if($key == 'full_name'){
                // First name
                if(isset($order_fields->first_name)){
                    $fields[] = [
                        'title' => 'نام',
                        'value' => $order_fields->first_name->value,
                        'ltr' => $item->ltr,
                        'ordering' => $order_fields->first_name->ordering,
                    ];
                }

                // Last name
                if(isset($order_fields->last_name)){
                    $fields[] = [
                        'title' => 'نام خانوادگی',
                        'value' => $order_fields->last_name->value,
                        'ltr' => $item->ltr,
                        'ordering' => $order_fields->last_name->ordering,
                    ];
                }
            } else if(isset($order_fields->$key)){
                $fields[] = [
                    'title' => $item->title,
                    'value' => $order_fields->$key->value,
                    'ltr' => $item->ltr,
                    'ordering' => $order_fields->$key->ordering,
                ];
            }
        }

        // Dynamic
        if(isset($order_fields->dynamic)){
            foreach ($order_fields->dynamic as $item) {
                $fields[] = (array)$item;
            }

        }
    }

    if($fields){
        usort($fields, fn($a, $b) => $a['ordering'] <=> $b['ordering']);
    }

    return json_decode(json_encode($fields));
}

function checkNationalCode($code){
    if (empty($code)) {
        return TRUE;
    }
    if (!preg_match('/^[0-9]{10}$/', $code))
        return false;
    for ($i = 0; $i < 10; $i++)
        if (preg_match('/^' . $i . '{10}$/', $code))
            return false;
    for ($i = 0, $sum = 0; $i < 9; $i++)
        $sum+=((10 - $i) * intval(substr($code, $i, 1)));
    $ret = $sum % 11;
    $parity = intval(substr($code, 9, 1));
    if (($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity))
        return true;
    return false;
}


function accessToBuy($user_login, $settings){
    $res_access = (object)[
        'condition' => false,
        'redirect' => '',
        'error' => ''
    ];

    if(!$user_login && in_array('cell_phone', $settings->verify_when_buy)){
        $res_access->error = 'no_login';
        $res_access->redirect = 'login';
        return $res_access;
    }

    if(
        $user_login && 
        in_array('identity_inquiry', $settings->verify_when_buy) && 
        (!in_array('national_code', $user_login->matched_fields) || !in_array('birth_date', $user_login->matched_fields))
    ){
        $res_access->error = !in_array('national_code', $user_login->matched_fields) ? 'no_national_code' : 'no_birth_date';
        $res_access->redirect = 'identity-inquiry';
        return $res_access;
    }

    $res_access->condition = true;

    return $res_access;
}

// شماره کارت بانکی را 4 رقم 4 رقم جدا میکنه
function bankCardFormat($str) {
    if(strlen($str) !== 16) {
        return "";
    }
    return implode('-', str_split($str, 4));
}

function englishNumber($string) {
    $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];

    $num = range(0, 9);
    $convertedPersianNums = str_replace($persian, $num, $string);
    $englishNumbersOnly = str_replace($arabic, $num, $convertedPersianNums);
    
    return $englishNumbersOnly;
}